/*
 * Decompiled with CFR 0.152.
 */
package io.github.insomniakitten.couplings;

import com.google.common.base.MoreObjects;
import io.github.insomniakitten.couplings.UseContext;
import net.fabricmc.loader.launch.knot.Knot;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Couplings {
    public static final int COUPLING_RANGE = 128;
    private static final Logger LOGGER = LogManager.getLogger((String)"coupled");

    private Couplings() {
    }

    public static boolean isUsable(class_1937 world, class_2338 pos, class_1657 player) {
        if (!player.method_7294()) {
            if (Knot.getLauncher().isDevelopment()) {
                LOGGER.warn("Skipping usage as world modification is disallowed for user {}", (Object)player);
            }
            return false;
        }
        if (!world.method_8591(pos)) {
            if (Knot.getLauncher().isDevelopment()) {
                LOGGER.warn("Skipping usage as block is unloaded at {}", (Object)pos);
            }
            return false;
        }
        if (!world.method_8621().method_11952(pos)) {
            if (Knot.getLauncher().isDevelopment()) {
                LOGGER.warn("Skipping usage as block is outside of the world border at {}", (Object)pos);
            }
            return false;
        }
        return true;
    }

    public static void use(class_2680 state, class_2680 other, class_1937 world, class_1268 hand, class_1657 player, class_3965 origin, class_2338 offset, boolean usageResult) {
        UseContext ctx = UseContext.of(state, other, world, player, hand, origin, offset);
        boolean otherUsageResult = other.method_11629(world, player, hand, ctx.targetHit());
        if (usageResult != otherUsageResult) {
            String result1 = Couplings.toString(world, player, hand, state, origin, usageResult);
            String result2 = Couplings.toString(world, player, hand, other, ctx.targetHit(), usageResult);
            if (Knot.getLauncher().isDevelopment()) {
                throw new IllegalStateException("Usage result mismatch between " + result1 + " and " + result2);
            }
            LOGGER.warn("Usage result mismatch between {} and {}", (Object)result1, (Object)result2);
        }
    }

    private static String toString(class_1937 world, class_1657 player, class_1268 hand, class_2680 state, class_3965 hit, boolean result) {
        return MoreObjects.toStringHelper((String)(result ? "Success" : "Failure")).add("world", (Object)world).add("player", (Object)player).add("hand", (Object)hand).add("state", (Object)state).add("hit", (Object)hit).toString();
    }
}

