/*
 * Decompiled with CFR 0.152.
 */
package io.github.insomniakitten.couplings;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.insomniakitten.couplings.CouplingsOptions;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public final class CouplingsMixins
implements IMixinConfigPlugin {
    private static final String PACKAGE = "io.github.insomniakitten.couplings.mixin";
    private static final ImmutableList<String> MIXINS = ImmutableList.of((Object)"DoorInvoker", (Object)"DoorMixin", (Object)"FenceGateMixin", (Object)"TrapdoorMixin");
    private static final ImmutableMap<String, BooleanSupplier> MIXIN_STATES = ImmutableMap.of((Object)"io.github.insomniakitten.couplings.mixin.DoorInvoker", () -> CouplingsOptions.getFeatures().areDoorsEnabled(), (Object)"io.github.insomniakitten.couplings.mixin.DoorMixin", () -> CouplingsOptions.getFeatures().areDoorsEnabled(), (Object)"io.github.insomniakitten.couplings.mixin.FenceGateMixin", () -> CouplingsOptions.getFeatures().areFenceGatesEnabled(), (Object)"io.github.insomniakitten.couplings.mixin.TrapdoorMixin", () -> CouplingsOptions.getFeatures().areTrapdoorsEnabled());
    private static final AtomicBoolean CONSTRUCTED = new AtomicBoolean();

    @Deprecated
    public CouplingsMixins() {
        if (!CONSTRUCTED.compareAndSet(false, true)) {
            throw new UnsupportedOperationException("Already constructed");
        }
    }

    public void onLoad(String mixinPackage) {
        if (!PACKAGE.equals(mixinPackage)) {
            throw new IllegalArgumentException(mixinPackage);
        }
    }

    public String getRefMapperConfig() {
        throw new UnsupportedOperationException();
    }

    public boolean shouldApplyMixin(String target, String mixin) {
        BooleanSupplier state = (BooleanSupplier)MIXIN_STATES.get((Object)mixin);
        if (state == null) {
            throw new IllegalArgumentException(mixin);
        }
        return state.getAsBoolean();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return MIXINS;
    }

    public void preApply(String target, ClassNode targetClass, String mixin, IMixinInfo info) {
    }

    public void postApply(String target, ClassNode targetClass, String mixin, IMixinInfo info) {
    }
}

