/*
 * Decompiled with CFR 0.152.
 */
package io.github.insomniakitten.couplings;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.FabricLoader;

public final class CouplingsOptions {
    private static final CouplingsOptions DEFAULT = new CouplingsOptions(false, 128, Features.access$000());
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static CouplingsOptions instance = DEFAULT;
    @SerializedName(value="ignore_sneaking")
    private final boolean ignoreSneaking;
    @SerializedName(value="coupling_range")
    private final int couplingRange;
    @SerializedName(value="enabled_features")
    private final Features enabledFeatures;

    private CouplingsOptions(boolean ignoreSneaking, int couplingRange, Features enabledFeatures) {
        this.ignoreSneaking = ignoreSneaking;
        this.couplingRange = couplingRange;
        this.enabledFeatures = enabledFeatures;
    }

    public static boolean isSneakingIgnored() {
        return CouplingsOptions.instance.ignoreSneaking;
    }

    public static int getCouplingRange() {
        return CouplingsOptions.instance.couplingRange;
    }

    public static Features getFeatures() {
        return CouplingsOptions.instance.enabledFeatures;
    }

    private static void load() {
        block31: {
            Path configs = FabricLoader.INSTANCE.getConfigDirectory().toPath();
            File config = configs.resolve("couplings.json").toFile();
            if (config.exists()) {
                try (FileReader reader = new FileReader(config);){
                    instance = (CouplingsOptions)GSON.fromJson((Reader)reader, CouplingsOptions.class);
                    if (instance == null) {
                        throw new IllegalArgumentException(reader.toString());
                    }
                    break block31;
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                if (!config.createNewFile()) break block31;
                try (FileWriter writer = new FileWriter(config);){
                    writer.append(GSON.toJson((Object)instance));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            CouplingsOptions that = (CouplingsOptions)obj;
            return this.ignoreSneaking == that.ignoreSneaking && this.couplingRange == that.couplingRange && Objects.equals(this.enabledFeatures, that.enabledFeatures);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.ignoreSneaking, this.couplingRange, this.enabledFeatures);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ignoreSneaking", this.ignoreSneaking).add("couplingRange", this.couplingRange).add("enabledFeatures", (Object)this.enabledFeatures).toString();
    }

    public static final class Features {
        private static final Features DEFAULT = new Features(true, true, true);
        private final boolean doors;
        @SerializedName(value="fence_gates")
        private final boolean fenceGates;
        private final boolean trapdoors;

        private Features(boolean doors, boolean fenceGates, boolean trapdoors) {
            this.doors = doors;
            this.fenceGates = fenceGates;
            this.trapdoors = trapdoors;
        }

        public boolean areDoorsEnabled() {
            return this.doors;
        }

        public boolean areFenceGatesEnabled() {
            return this.fenceGates;
        }

        public boolean areTrapdoorsEnabled() {
            return this.trapdoors;
        }

        public int hashCode() {
            return Objects.hash(this.doors, this.fenceGates, this.trapdoors);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Features features = (Features)obj;
                return this.doors == features.doors && this.fenceGates == features.fenceGates && this.trapdoors == features.trapdoors;
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("doors", this.doors).add("fenceGates", this.fenceGates).add("trapdoors", this.trapdoors).toString();
        }

        static /* synthetic */ Features access$000() {
            return DEFAULT;
        }
    }

    @Deprecated
    public static final class Loader
    implements ModInitializer {
        public void onInitialize() {
            CouplingsOptions.load();
        }
    }
}

