/*
 * Decompiled with CFR 0.152.
 */
package io.github.insomniakitten.couplings.hook;

import io.github.insomniakitten.couplings.Couplings;
import io.github.insomniakitten.couplings.CouplingsOptions;
import io.github.insomniakitten.couplings.mixin.DoorInvoker;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3965;

public final class DoorHooks {
    private static final ThreadLocal<Boolean> USE_NEIGHBOR = ThreadLocal.withInitial(() -> true);

    private DoorHooks() {
    }

    public static void usageCallback(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, boolean usageResult) {
        if (!CouplingsOptions.getFeatures().areDoorsEnabled()) {
            return;
        }
        if (!USE_NEIGHBOR.get().booleanValue()) {
            return;
        }
        if (player.method_5715() && !CouplingsOptions.isSneakingIgnored()) {
            return;
        }
        USE_NEIGHBOR.set(false);
        class_2338 offset = DoorHooks.getOtherDoor(state, pos);
        if (Couplings.isUsable(world, offset, player)) {
            class_2680 other = world.method_8320(offset);
            if (state.method_11614() == other.method_11614() && DoorHooks.areEquivalent(state, other)) {
                Couplings.use(state, other, world, hand, player, hit, offset, usageResult);
            }
        }
        USE_NEIGHBOR.set(true);
    }

    public static void neighborUpdateCallback(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 neighborPos, boolean isPowered) {
        if (!CouplingsOptions.getFeatures().areDoorsEnabled()) {
            return;
        }
        if (!isPowered && DoorHooks.isPowered(state) || DoorHooks.isSufficientlyPowered(state, world, pos)) {
            class_2338 offset = DoorHooks.getOtherDoor(state, pos);
            class_2680 other = world.method_8320(offset);
            if (state.method_11614() == other.method_11614() && DoorHooks.areEquivalent(state, (class_2680)other.method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(isPowered)))) {
                world.method_8652(offset, (class_2680)other.method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(isPowered)), 2);
                DoorHooks.fireWorldEvent(other, world, offset, isPowered);
            }
        }
    }

    private static boolean areEquivalent(class_2680 self, class_2680 other) {
        return DoorHooks.getFacing(self) == DoorHooks.getFacing(other) && DoorHooks.getHalf(self) == DoorHooks.getHalf(other) && DoorHooks.isOpen(self) != DoorHooks.isOpen(other) && DoorHooks.getHinge(self) != DoorHooks.getHinge(other);
    }

    private static class_2338 getOtherHalf(class_2680 state, class_2338 pos) {
        return pos.method_10093(DoorHooks.getHalf(state) == class_2756.field_12607 ? class_2350.field_11036 : class_2350.field_11033);
    }

    private static class_2338 getOtherDoor(class_2680 self, class_2338 origin) {
        class_2350 facing = (class_2350)self.method_11654((class_2769)class_2323.field_10938);
        boolean left = class_2750.field_12588 == self.method_11654((class_2769)class_2323.field_10941);
        return origin.method_10093(left ? facing.method_10170() : facing.method_10160());
    }

    private static boolean isSufficientlyPowered(class_2680 state, class_1937 world, class_2338 pos) {
        int power = Math.max(world.method_8482(pos), world.method_8482(DoorHooks.getOtherHalf(state, pos)));
        return power > 7;
    }

    private static class_2350 getFacing(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)class_2323.field_10938);
    }

    private static class_2756 getHalf(class_2680 state) {
        return (class_2756)state.method_11654((class_2769)class_2323.field_10946);
    }

    private static boolean isOpen(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2323.field_10945);
    }

    private static boolean isPowered(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2323.field_10940);
    }

    private static class_2750 getHinge(class_2680 state) {
        return (class_2750)state.method_11654((class_2769)class_2323.field_10941);
    }

    private static void fireWorldEvent(class_2680 state, class_1937 world, class_2338 pos, boolean isPowered) {
        class_2248 block = state.method_11614();
        if (!(block instanceof DoorInvoker)) {
            throw new IllegalArgumentException("Not invokable: " + block);
        }
        ((DoorInvoker)block).playUseSound(world, pos, isPowered);
    }
}

