/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client;

import com.irtimaled.bbor.client.ClientDimensionCache;
import com.irtimaled.bbor.client.PlayerData;
import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.models.BoundingBox;
import com.irtimaled.bbor.common.models.BoundingBoxSlimeChunk;
import com.irtimaled.bbor.common.models.BoundingBoxWorldSpawn;
import com.irtimaled.bbor.common.models.WorldData;
import com.irtimaled.bbor.config.ConfigManager;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3532;

class ClientBoundingBoxProvider {
    private static final int CHUNK_SIZE = 16;
    private final ClientDimensionCache dimensionCache;

    ClientBoundingBoxProvider(ClientDimensionCache dimensionCache) {
        this.dimensionCache = dimensionCache;
    }

    private boolean isWithinRenderDistance(class_2338 minBlockPos, class_2338 maxBlockPos) {
        int renderDistanceBlocks = class_310.method_1551().field_1690.field_1870 * 16;
        int minX = class_3532.method_15357((double)(PlayerData.getX() - (double)renderDistanceBlocks));
        int maxX = class_3532.method_15357((double)(PlayerData.getX() + (double)renderDistanceBlocks));
        int minZ = class_3532.method_15357((double)(PlayerData.getZ() - (double)renderDistanceBlocks));
        int maxZ = class_3532.method_15357((double)(PlayerData.getZ() + (double)renderDistanceBlocks));
        return maxBlockPos.method_10263() > minX && maxBlockPos.method_10260() > minZ && minBlockPos.method_10263() < maxX && minBlockPos.method_10260() < maxZ;
    }

    Set<BoundingBox> getBoundingBoxes(class_2874 dimensionType, Boolean outerBoxOnly) {
        Set<BoundingBox> boundingBoxes = this.getClientBoundingBoxes(dimensionType);
        BoundingBoxCache boundingBoxCache = this.dimensionCache.getBoundingBoxes(dimensionType);
        if (boundingBoxCache == null) {
            return boundingBoxes;
        }
        for (Map.Entry<BoundingBox, Set<BoundingBox>> entry : boundingBoxCache.getBoundingBoxes().entrySet()) {
            BoundingBox bb = entry.getKey();
            if (!this.isWithinRenderDistance(bb.getMinBlockPos(), bb.getMaxBlockPos())) continue;
            if (outerBoxOnly.booleanValue()) {
                boundingBoxes.add(bb);
                continue;
            }
            boundingBoxes.addAll((Collection<BoundingBox>)entry.getValue());
        }
        return boundingBoxes;
    }

    private void addIfWithinRenderDistance(Set<BoundingBox> boundingBoxes, BoundingBox boundingBox) {
        if (this.isWithinRenderDistance(boundingBox.getMinBlockPos(), boundingBox.getMaxBlockPos())) {
            boundingBoxes.add(boundingBox);
        }
    }

    private Set<BoundingBox> getClientBoundingBoxes(class_2874 dimensionType) {
        WorldData worldData = this.dimensionCache.getWorldData();
        HashSet<BoundingBox> boundingBoxes = new HashSet<BoundingBox>();
        if (worldData != null && dimensionType == class_2874.field_13072) {
            if (ConfigManager.drawWorldSpawn.getBoolean()) {
                this.addIfWithinRenderDistance(boundingBoxes, this.getSpawnChunksBoundingBox(worldData.getSpawnX(), worldData.getSpawnZ()));
                this.addIfWithinRenderDistance(boundingBoxes, this.getWorldSpawnBoundingBox(worldData.getSpawnX(), worldData.getSpawnZ()));
            }
            if (ConfigManager.drawLazySpawnChunks.getBoolean()) {
                this.addIfWithinRenderDistance(boundingBoxes, this.getLazySpawnChunksBoundingBox(worldData.getSpawnX(), worldData.getSpawnZ()));
            }
            if (ConfigManager.drawSlimeChunks.getBoolean()) {
                boundingBoxes.addAll(this.getSlimeChunks());
            }
        }
        return boundingBoxes;
    }

    private Set<BoundingBoxSlimeChunk> getSlimeChunks() {
        int renderDistanceChunks = class_310.method_1551().field_1690.field_1870;
        int playerChunkX = class_3532.method_15357((double)(PlayerData.getX() / 16.0));
        int playerChunkZ = class_3532.method_15357((double)(PlayerData.getZ() / 16.0));
        HashSet<BoundingBoxSlimeChunk> slimeChunks = new HashSet<BoundingBoxSlimeChunk>();
        for (int chunkX = playerChunkX - renderDistanceChunks; chunkX <= playerChunkX + renderDistanceChunks; ++chunkX) {
            for (int chunkZ = playerChunkZ - renderDistanceChunks; chunkZ <= playerChunkZ + renderDistanceChunks; ++chunkZ) {
                if (!this.isSlimeChunk(chunkX, chunkZ)) continue;
                class_1923 chunk = new class_1923(chunkX, chunkZ);
                class_2338 minBlockPos = new class_2338(chunk.method_8326(), 1, chunk.method_8328());
                class_2338 maxBlockPos = new class_2338(chunk.method_8327(), 38, chunk.method_8329());
                slimeChunks.add(BoundingBoxSlimeChunk.from(minBlockPos, maxBlockPos, Color.GREEN));
            }
        }
        return slimeChunks;
    }

    private boolean isSlimeChunk(int chunkX, int chunkZ) {
        WorldData worldData = this.dimensionCache.getWorldData();
        Random r = new Random(worldData.getSeed() + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ 0x3AD8025FL);
        return r.nextInt(10) == 0;
    }

    private BoundingBox getSpawnChunksBoundingBox(int spawnX, int spawnZ) {
        return this.dimensionCache.getOrSetSpawnChunks(() -> this.buildSpawnChunksBoundingBox(spawnX, spawnZ, 12));
    }

    private BoundingBox getLazySpawnChunksBoundingBox(int spawnX, int spawnZ) {
        return this.dimensionCache.getOrSetLazySpawnChunks(() -> this.buildSpawnChunksBoundingBox(spawnX, spawnZ, 16));
    }

    private BoundingBox buildSpawnChunksBoundingBox(int spawnX, int spawnZ, int size) {
        double midOffset = 16.0 * ((double)size / 2.0);
        double midX = (double)Math.round((float)((double)spawnX / 16.0)) * 16.0;
        double midZ = (double)Math.round((float)((double)spawnZ / 16.0)) * 16.0;
        class_2338 minBlockPos = new class_2338(midX - midOffset, 0.0, midZ - midOffset);
        if ((double)spawnX / 16.0 % 0.5 == 0.0 && (double)spawnZ / 16.0 % 0.5 == 0.0) {
            midX += 16.0;
            midZ += 16.0;
        }
        class_2338 maxBlockPos = new class_2338(midX + midOffset, 0.0, midZ + midOffset);
        return BoundingBoxWorldSpawn.from(minBlockPos, maxBlockPos, Color.RED);
    }

    private BoundingBox getWorldSpawnBoundingBox(int spawnX, int spawnZ) {
        return this.dimensionCache.getOrSetWorldSpawn(() -> this.buildWorldSpawnBoundingBox(spawnX, spawnZ));
    }

    private BoundingBox buildWorldSpawnBoundingBox(int spawnX, int spawnZ) {
        class_2338 minBlockPos = new class_2338(spawnX - 10, 0, spawnZ - 10);
        class_2338 maxBlockPos = new class_2338(spawnX + 10, 0, spawnZ + 10);
        return BoundingBoxWorldSpawn.from(minBlockPos, maxBlockPos, Color.RED);
    }
}

