/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client;

import com.irtimaled.bbor.client.ClientDimensionCache;
import com.irtimaled.bbor.client.ClientRenderer;
import com.irtimaled.bbor.client.NBTFileParser;
import com.irtimaled.bbor.client.PlayerData;
import com.irtimaled.bbor.common.CommonProxy;
import com.irtimaled.bbor.common.VillageColorCache;
import com.irtimaled.bbor.common.VillageProcessor;
import com.irtimaled.bbor.config.ConfigManager;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ClientProxy
extends CommonProxy {
    private boolean active;
    private boolean outerBoxOnly;
    private ClientRenderer renderer;
    private int remoteUserCount = 0;

    public void toggleActive() {
        boolean bl = this.active = !this.active;
        if (this.active) {
            PlayerData.setActiveY();
        }
    }

    public void toggleOuterBoxOnly() {
        this.outerBoxOnly = !this.outerBoxOnly;
    }

    @Override
    public void init() {
        ClientDimensionCache clientDimensionCache = new ClientDimensionCache();
        this.renderer = new ClientRenderer(clientDimensionCache);
        this.dimensionCache = clientDimensionCache;
    }

    public void render(float partialTicks) {
        class_746 entityPlayer = class_310.method_1551().field_1724;
        PlayerData.setPlayerPosition(partialTicks, entityPlayer);
        if (this.active) {
            this.renderer.render(entityPlayer.field_6026, this.outerBoxOnly);
        }
    }

    public void setRemoteUserCount(int remoteUserCount) {
        this.remoteUserCount = remoteUserCount;
    }

    protected boolean hasRemoteUsers() {
        return this.remoteUserCount > 0;
    }

    @Override
    public void tick() {
        if (this.active || this.hasRemoteUsers()) {
            super.tick();
        }
    }

    public void playerConnectedToServer(class_2535 networkManager) {
        SocketAddress remoteAddress = networkManager.method_10755();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
            NBTFileParser.loadLocalDatFiles(socketAddress.getHostName(), socketAddress.getPort(), this.dimensionCache);
        }
    }

    public void playerDisconnectedFromServer() {
        this.active = false;
        this.villageProcessors.forEach(VillageProcessor::close);
        this.villageProcessors.clear();
        if (ConfigManager.keepCacheBetweenSessions.getBoolean()) {
            return;
        }
        VillageColorCache.clear();
        this.dimensionCache.clear();
    }
}

