/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client;

import com.irtimaled.bbor.client.ClientBoundingBoxProvider;
import com.irtimaled.bbor.client.ClientDimensionCache;
import com.irtimaled.bbor.client.renderers.Renderer;
import com.irtimaled.bbor.client.renderers.SlimeChunkRenderer;
import com.irtimaled.bbor.client.renderers.StructureRenderer;
import com.irtimaled.bbor.client.renderers.VillageRenderer;
import com.irtimaled.bbor.client.renderers.WorldSpawnRenderer;
import com.irtimaled.bbor.common.models.BoundingBox;
import com.irtimaled.bbor.common.models.BoundingBoxSlimeChunk;
import com.irtimaled.bbor.common.models.BoundingBoxStructure;
import com.irtimaled.bbor.common.models.BoundingBoxVillage;
import com.irtimaled.bbor.common.models.BoundingBoxWorldSpawn;
import com.irtimaled.bbor.config.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2874;
import org.lwjgl.opengl.GL11;

public class ClientRenderer {
    private final ClientBoundingBoxProvider clientBoundingBoxProvider;
    private static final Map<Class<? extends BoundingBox>, Renderer> boundingBoxRendererMap = new HashMap<Class<? extends BoundingBox>, Renderer>();

    ClientRenderer(ClientDimensionCache dimensionCache) {
        this.clientBoundingBoxProvider = new ClientBoundingBoxProvider(dimensionCache);
        boundingBoxRendererMap.put(BoundingBoxVillage.class, new VillageRenderer());
        boundingBoxRendererMap.put(BoundingBoxSlimeChunk.class, new SlimeChunkRenderer());
        boundingBoxRendererMap.put(BoundingBoxWorldSpawn.class, new WorldSpawnRenderer());
        boundingBoxRendererMap.put(BoundingBoxStructure.class, new StructureRenderer());
    }

    public void render(class_2874 dimensionType, Boolean outerBoxesOnly) {
        Set<BoundingBox> boundingBoxes = this.clientBoundingBoxProvider.getBoundingBoxes(dimensionType, outerBoxesOnly);
        if (boundingBoxes == null || boundingBoxes.size() == 0) {
            return;
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        if (ConfigManager.alwaysVisible.getBoolean()) {
            GL11.glClear((int)256);
        }
        for (BoundingBox bb : boundingBoxes) {
            Renderer renderer = boundingBoxRendererMap.get(bb.getClass());
            if (renderer == null) continue;
            renderer.render(bb);
        }
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
    }
}

