/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client;

import com.irtimaled.bbor.Logger;
import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.DimensionCache;
import com.irtimaled.bbor.common.StructureType;
import com.irtimaled.bbor.common.models.BoundingBox;
import com.irtimaled.bbor.common.models.BoundingBoxStructure;
import com.irtimaled.bbor.common.models.BoundingBoxVillage;
import com.irtimaled.bbor.config.ConfigManager;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2874;

class NBTFileParser {
    NBTFileParser() {
    }

    static void loadLocalDatFiles(String host, int port, DimensionCache dimensionCache) {
        Logger.info("Looking for local structures (host:port=%s:%d)", host, port);
        String path = String.format("BBOutlineReloaded%s%s%s%d", File.separator, host, File.separator, port);
        File localStructuresFolder = new File(ConfigManager.configDir, path);
        Logger.info("Looking for local structures (folder=%s)", localStructuresFolder.getAbsolutePath());
        if (!localStructuresFolder.exists()) {
            path = String.format("BBOutlineReloaded%s%s", File.separator, host);
            localStructuresFolder = new File(ConfigManager.configDir, path);
            Logger.info("Looking for local structures (folder=%s)", localStructuresFolder.getAbsolutePath());
        }
        if (!localStructuresFolder.exists()) {
            path = String.format("BBOutlineReloaded%s%s,%d", File.separator, host, port);
            localStructuresFolder = new File(ConfigManager.configDir, path);
            Logger.info("Looking for local structures (folder=%s)", localStructuresFolder.getAbsolutePath());
        }
        if (!localStructuresFolder.exists()) {
            Logger.info("No local structures folders found", new Object[0]);
            return;
        }
        NBTFileParser.loadWorldData(localStructuresFolder, dimensionCache);
        NBTFileParser.populateBoundingBoxCache(localStructuresFolder, dimensionCache);
    }

    private static void loadWorldData(File localStructuresFolder, DimensionCache dimensionCache) {
        File file = new File(localStructuresFolder, "level.dat");
        class_2487 nbt = NBTFileParser.loadNbtFile(file);
        if (nbt == null) {
            return;
        }
        class_2487 data = nbt.method_10562("Data");
        long seed = data.method_10537("RandomSeed");
        int spawnX = data.method_10550("SpawnX");
        int spawnZ = data.method_10550("SpawnZ");
        Logger.info("Loaded level.dat (seed: %d, spawn: %d,%d)", seed, spawnX, spawnZ);
        dimensionCache.setWorldData(seed, spawnX, spawnZ);
    }

    private static void populateBoundingBoxCache(File localStructuresFolder, DimensionCache dimensionCache) {
        dimensionCache.put(class_2874.field_13072, NBTFileParser.loadOverworldStructures(localStructuresFolder));
        dimensionCache.put(class_2874.field_13076, NBTFileParser.loadNetherStructures(localStructuresFolder));
        dimensionCache.put(class_2874.field_13078, NBTFileParser.loadEndStructures(localStructuresFolder));
    }

    private static BoundingBoxCache loadOverworldStructures(File localStructuresFolder) {
        BoundingBoxCache cache = new BoundingBoxCache();
        if (ConfigManager.drawDesertTemples.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "Temple.dat", StructureType.DesertTemple.getColor(), "TeDP");
        }
        if (ConfigManager.drawJungleTemples.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "Temple.dat", StructureType.JungleTemple.getColor(), "TeJP");
        }
        if (ConfigManager.drawWitchHuts.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "Temple.dat", StructureType.WitchHut.getColor(), "TeSH");
        }
        if (ConfigManager.drawOceanMonuments.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "Monument.dat", StructureType.OceanMonument.getColor(), "*");
        }
        if (ConfigManager.drawStrongholds.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "Stronghold.dat", StructureType.Stronghold.getColor(), "*");
        }
        if (ConfigManager.drawMansions.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "Mansion.dat", StructureType.Mansion.getColor(), "*");
        }
        if (ConfigManager.drawMineShafts.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "Mineshaft.dat", StructureType.MineShaft.getColor(), "*");
        }
        if (ConfigManager.drawVillages.getBoolean()) {
            NBTFileParser.loadVillages(localStructuresFolder, cache, "Villages.dat");
        }
        return cache;
    }

    private static BoundingBoxCache loadNetherStructures(File localStructuresFolder) {
        BoundingBoxCache cache = new BoundingBoxCache();
        if (ConfigManager.drawNetherFortresses.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "Fortress.dat", StructureType.NetherFortress.getColor(), "*");
        }
        if (ConfigManager.drawVillages.getBoolean()) {
            NBTFileParser.loadVillages(localStructuresFolder, cache, "villages_nether.dat");
        }
        return cache;
    }

    private static BoundingBoxCache loadEndStructures(File localStructuresFolder) {
        BoundingBoxCache cache = new BoundingBoxCache();
        if (ConfigManager.drawVillages.getBoolean()) {
            NBTFileParser.loadVillages(localStructuresFolder, cache, "Villages_end.dat");
        }
        if (ConfigManager.drawEndCities.getBoolean()) {
            NBTFileParser.loadStructure(localStructuresFolder, cache, "EndCity.dat", StructureType.EndCity.getColor(), "*");
        }
        return cache;
    }

    private static void loadStructure(File localStructuresFolder, BoundingBoxCache cache, String fileName, Color color, String id) {
        File file = new File(localStructuresFolder, fileName);
        class_2487 nbt = NBTFileParser.loadNbtFile(file);
        if (nbt == null) {
            return;
        }
        class_2487 features = nbt.method_10562("data").method_10562("Features");
        int loadedStructureCount = 0;
        for (String key : features.method_10541()) {
            class_2487[] children;
            class_2487 feature = features.method_10562(key);
            BoundingBoxStructure structure = BoundingBoxStructure.from(feature.method_10561("BB"), color);
            HashSet<BoundingBox> boundingBoxes = new HashSet<BoundingBox>();
            for (class_2487 child : children = NBTFileParser.getChildCompoundTags(feature, "Children")) {
                if (!id.equals(child.method_10558("id")) && !id.equals("*")) continue;
                boundingBoxes.add(BoundingBoxStructure.from(child.method_10561("BB"), color));
            }
            if (boundingBoxes.size() > 0) {
                ++loadedStructureCount;
            }
            cache.addBoundingBoxes(structure, boundingBoxes);
        }
        Logger.info("Loaded %s (%d structures with type %s)", fileName, loadedStructureCount, id);
    }

    private static void loadVillages(File localStructuresFolder, BoundingBoxCache cache, String fileName) {
        class_2487[] villages;
        File file = new File(localStructuresFolder, fileName);
        class_2487 nbt = NBTFileParser.loadNbtFile(file);
        if (nbt == null) {
            return;
        }
        for (class_2487 village : villages = NBTFileParser.getChildCompoundTags(nbt.method_10562("data"), "Villages")) {
            class_2338 center = new class_2338(village.method_10550("CX"), village.method_10550("CY"), village.method_10550("CZ"));
            int radius = village.method_10550("Radius");
            int population = village.method_10550("PopSize");
            Set<class_2338> doors = NBTFileParser.getDoors(village);
            BoundingBoxVillage boundingBox = BoundingBoxVillage.from(center, (Integer)radius, village.hashCode(), population, doors);
            cache.addBoundingBox(boundingBox);
        }
        Logger.info("Loaded %s (%d villages)", fileName, villages.length);
    }

    private static Set<class_2338> getDoors(class_2487 village) {
        HashSet<class_2338> doors = new HashSet<class_2338>();
        for (class_2487 door : NBTFileParser.getChildCompoundTags(village, "Doors")) {
            doors.add(new class_2338(door.method_10550("X"), door.method_10550("Y"), door.method_10550("Z")));
        }
        return doors;
    }

    private static class_2487 loadNbtFile(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return class_2507.method_10629((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class_2487[] getChildCompoundTags(class_2487 parent, String key) {
        class_2499 tagList = parent.method_10554(key, 10);
        class_2487[] result = new class_2487[tagList.size()];
        for (int index = 0; index < tagList.size(); ++index) {
            result[index] = tagList.method_10602(index);
        }
        return result;
    }
}

