/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.PlayerData;
import com.irtimaled.bbor.client.renderers.Renderer;
import com.irtimaled.bbor.common.models.BoundingBoxVillage;
import com.irtimaled.bbor.config.ConfigManager;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import org.lwjgl.opengl.GL11;

public class VillageRenderer
extends Renderer<BoundingBoxVillage> {
    @Override
    public void render(BoundingBoxVillage boundingBox) {
        if (ConfigManager.renderVillageAsSphere.getBoolean()) {
            this.renderBoundingBoxVillageAsSphere(boundingBox);
        } else {
            this.renderBoundingBox(boundingBox);
        }
        if (ConfigManager.drawIronGolemSpawnArea.getBoolean() && boundingBox.getSpawnsIronGolems()) {
            this.renderIronGolemSpawnArea(boundingBox);
        }
        if (ConfigManager.drawVillageDoors.getBoolean()) {
            this.renderVillageDoors(boundingBox);
        }
    }

    private void renderIronGolemSpawnArea(BoundingBoxVillage boundingBox) {
        class_2338 center = boundingBox.getCenter();
        class_238 abb = new class_238(new class_2338(center.method_10263() - 8, center.method_10264() - 3, center.method_10260() - 8), new class_2338(center.method_10263() + 8, center.method_10264() + 3, center.method_10260() + 8)).method_989(boundingBox.getCenterOffsetX().doubleValue(), 0.0, boundingBox.getCenterOffsetZ().doubleValue());
        this.renderCuboid(abb, boundingBox.getColor(), false);
    }

    private void renderVillageDoors(BoundingBoxVillage boundingBox) {
        OffsetPoint center = new OffsetPoint(boundingBox.getCenter()).add(boundingBox.getCenterOffsetX(), 0.0, boundingBox.getCenterOffsetZ());
        Color color = boundingBox.getColor();
        GL11.glPolygonMode((int)1032, (int)6913);
        class_289 tessellator = class_289.method_1348();
        class_287 worldRenderer = tessellator.method_1349();
        int colorR = color.getRed();
        int colorG = color.getGreen();
        int colorB = color.getBlue();
        worldRenderer.method_1328(1, worldRenderer.method_1311());
        for (class_2338 door : boundingBox.getDoors()) {
            OffsetPoint point = new OffsetPoint(door).add(0.5, 0.0, 0.5);
            worldRenderer.method_1315(point.getX(), point.getY(), point.getZ()).method_1323(colorR, colorG, colorB, 255).method_1344();
            worldRenderer.method_1315(center.getX(), center.getY(), center.getZ()).method_1323(colorR, colorG, colorB, 255).method_1344();
        }
        tessellator.method_1350();
    }

    private void renderBoundingBoxVillageAsSphere(BoundingBoxVillage boundingBox) {
        OffsetPoint center = new OffsetPoint(boundingBox.getCenter()).add(boundingBox.getCenterOffsetX(), 0.0, boundingBox.getCenterOffsetZ());
        int radius = boundingBox.getRadius();
        Color color = boundingBox.getColor();
        this.renderSphere(center, radius, color);
    }

    private void renderSphere(OffsetPoint center, double radius, Color color) {
        GL11.glEnable((int)2832);
        GL11.glPointSize((float)2.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 worldRenderer = tessellator.method_1349();
        worldRenderer.method_1328(0, class_290.field_1576);
        for (OffsetPoint point : this.buildPoints(center, radius)) {
            worldRenderer.method_1315(point.getX(), point.getY(), point.getZ()).method_1323(color.getRed(), color.getGreen(), color.getBlue(), 255).method_1344();
        }
        tessellator.method_1350();
    }

    private Set<OffsetPoint> buildPoints(OffsetPoint center, double radius) {
        HashSet<OffsetPoint> points = new HashSet<OffsetPoint>(1200);
        double tau = Math.PI * 2;
        double pi = tau / 2.0;
        double segment = tau / 48.0;
        for (double t = 0.0; t < tau; t += segment) {
            for (double theta = 0.0; theta < pi; theta += segment) {
                double dx = radius * Math.sin(t) * Math.cos(theta);
                double dz = radius * Math.sin(t) * Math.sin(theta);
                double dy = radius * Math.cos(t);
                points.add(center.add(dx, dy, dz));
            }
        }
        return points;
    }

    private class OffsetPoint {
        private final double x;
        private final double y;
        private final double z;

        OffsetPoint(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        OffsetPoint(class_2338 blockPos) {
            this.x = blockPos.method_10263();
            this.y = blockPos.method_10264();
            this.z = blockPos.method_10260();
        }

        double getX() {
            return this.x - PlayerData.getX();
        }

        double getY() {
            return this.y - PlayerData.getY();
        }

        double getZ() {
            return this.z - PlayerData.getZ();
        }

        public OffsetPoint add(double x, double y, double z) {
            return new OffsetPoint(this.x + x, this.y + y, this.z + z);
        }
    }
}

