/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common;

import com.irtimaled.bbor.Logger;
import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.DimensionCache;
import com.irtimaled.bbor.common.DimensionProcessor;
import com.irtimaled.bbor.common.IVillageEventHandler;
import com.irtimaled.bbor.common.VillageProcessor;
import com.irtimaled.bbor.config.ConfigManager;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_3215;

public class CommonProxy {
    protected DimensionCache dimensionCache;
    protected Set<VillageProcessor> villageProcessors = new HashSet<VillageProcessor>();
    private IVillageEventHandler eventHandler = null;

    public void worldLoaded(class_1937 world) {
        class_2802 chunkProvider = world.method_8398();
        if (chunkProvider instanceof class_3215) {
            this.dimensionCache.setWorldData(world.method_8412(), world.method_8401().method_215(), world.method_8401().method_166());
            class_2874 dimensionType = world.field_9247.method_12460();
            Logger.info("create world dimension: %s, %s (seed: %d)", dimensionType, world.getClass().toString(), world.method_8412());
            DimensionProcessor boundingBoxCache = new DimensionProcessor(dimensionType);
            this.dimensionCache.put(dimensionType, boundingBoxCache);
            if (ConfigManager.drawVillages.getBoolean()) {
                this.villageProcessors.add(new VillageProcessor(world, dimensionType, this.eventHandler, boundingBoxCache));
            }
        }
    }

    public void chunkLoaded(class_2818 chunk) {
        class_2874 dimensionType = chunk.method_12200().field_9247.method_12460();
        BoundingBoxCache cache = this.dimensionCache.get(dimensionType);
        if (cache instanceof DimensionProcessor) {
            ((DimensionProcessor)cache).processChunk((class_2791)chunk);
        }
    }

    public void tick() {
        this.villageProcessors.forEach(VillageProcessor::process);
    }

    public void init() {
        this.dimensionCache = new DimensionCache();
    }

    public void setEventHandler(IVillageEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public DimensionCache getDimensionCache() {
        return this.dimensionCache;
    }
}

