/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common;

import com.irtimaled.bbor.Logger;
import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.StructureType;
import com.irtimaled.bbor.common.models.BoundingBox;
import com.irtimaled.bbor.common.models.BoundingBoxStructure;
import com.irtimaled.bbor.config.ConfigManager;
import com.irtimaled.bbor.config.Setting;
import java.awt.Color;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;

public class DimensionProcessor
extends BoundingBoxCache {
    private class_2874 dimensionType;
    private boolean closed = false;

    DimensionProcessor(class_2874 dimensionType) {
        this.dimensionType = dimensionType;
    }

    @Override
    public void close() {
        this.closed = true;
        super.close();
    }

    private void addStructures(Setting drawStructure, StructureType structureType, Map<String, class_3449> structureMap) {
        if (!drawStructure.getBoolean()) {
            return;
        }
        class_3449 structureStart = structureMap.get(structureType.getName());
        if (structureStart == null) {
            return;
        }
        Color color = structureType.getColor();
        class_3341 bb = structureStart.method_14968();
        if (bb == null) {
            return;
        }
        BoundingBoxStructure boundingBox = BoundingBoxStructure.from(bb, color);
        if (this.isCached(boundingBox)) {
            return;
        }
        HashSet<BoundingBox> structureBoundingBoxes = new HashSet<BoundingBox>();
        for (class_3443 structureComponent : structureStart.method_14963()) {
            structureBoundingBoxes.add(BoundingBoxStructure.from(structureComponent.method_14935(), color));
        }
        this.addBoundingBoxes(boundingBox, structureBoundingBoxes);
        Logger.info("[%s] new dimensionCache entries: %d", this.dimensionType, structureBoundingBoxes.size());
    }

    public synchronized void processChunk(class_2791 chunk) {
        if (this.closed) {
            return;
        }
        Map structureMap = chunk.method_12016();
        if (structureMap.size() > 0) {
            this.addStructures(ConfigManager.drawDesertTemples, StructureType.DesertTemple, structureMap);
            this.addStructures(ConfigManager.drawJungleTemples, StructureType.JungleTemple, structureMap);
            this.addStructures(ConfigManager.drawWitchHuts, StructureType.WitchHut, structureMap);
            this.addStructures(ConfigManager.drawOceanMonuments, StructureType.OceanMonument, structureMap);
            this.addStructures(ConfigManager.drawStrongholds, StructureType.Stronghold, structureMap);
            this.addStructures(ConfigManager.drawMansions, StructureType.Mansion, structureMap);
            this.addStructures(ConfigManager.drawMineShafts, StructureType.MineShaft, structureMap);
            this.addStructures(ConfigManager.drawShipwrecks, StructureType.Shipwreck, structureMap);
            this.addStructures(ConfigManager.drawOceanRuins, StructureType.OceanRuin, structureMap);
            this.addStructures(ConfigManager.drawBuriedTreasure, StructureType.BuriedTreasure, structureMap);
            this.addStructures(ConfigManager.drawIgloos, StructureType.Igloo, structureMap);
            this.addStructures(ConfigManager.drawNetherFortresses, StructureType.NetherFortress, structureMap);
            this.addStructures(ConfigManager.drawEndCities, StructureType.EndCity, structureMap);
        }
    }
}

