/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common;

import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.IVillageEventHandler;
import com.irtimaled.bbor.common.models.BoundingBoxVillage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1415;
import net.minecraft.class_1418;
import net.minecraft.class_1937;
import net.minecraft.class_2874;

public class VillageProcessor {
    private class_1937 world;
    private class_2874 dimensionType;
    private IVillageEventHandler eventHandler;
    private BoundingBoxCache boundingBoxCache;
    private Map<Integer, BoundingBoxVillage> villageCache = new HashMap<Integer, BoundingBoxVillage>();
    private boolean closed = false;

    VillageProcessor(class_1937 world, class_2874 dimensionType, IVillageEventHandler eventHandler, BoundingBoxCache boundingBoxCache) {
        this.world = world;
        this.dimensionType = dimensionType;
        this.eventHandler = eventHandler;
        this.boundingBoxCache = boundingBoxCache;
    }

    synchronized void process() {
        if (this.closed) {
            return;
        }
        HashMap<Integer, BoundingBoxVillage> oldVillages = new HashMap<Integer, BoundingBoxVillage>(this.villageCache);
        HashMap<Integer, BoundingBoxVillage> newVillages = new HashMap<Integer, BoundingBoxVillage>();
        class_1418 villageCollection = this.world.method_8557();
        if (villageCollection != null) {
            List villages = villageCollection.method_6436();
            for (int i = 0; i < villages.size(); ++i) {
                class_1415 village = (class_1415)villages.get(i);
                int villageId = village.hashCode();
                BoundingBoxVillage newVillage = (BoundingBoxVillage)oldVillages.get(villageId);
                if (newVillage != null && newVillage.matches(village)) {
                    oldVillages.remove(villageId);
                } else {
                    newVillage = BoundingBoxVillage.from(village);
                }
                newVillages.put(villageId, newVillage);
            }
        }
        for (BoundingBoxVillage village : oldVillages.values()) {
            this.boundingBoxCache.removeBoundingBox(village);
            if (this.eventHandler == null) continue;
            this.eventHandler.villageRemoved(this.dimensionType, village);
        }
        for (BoundingBoxVillage village : newVillages.values()) {
            this.boundingBoxCache.addBoundingBox(village);
        }
        this.villageCache = newVillages;
    }

    public void close() {
        this.closed = true;
        this.world = null;
        this.eventHandler = null;
        this.boundingBoxCache = null;
        this.villageCache.clear();
    }
}

