/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common.models;

import com.irtimaled.bbor.common.VillageColorCache;
import com.irtimaled.bbor.common.models.BoundingBox;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1415;
import net.minecraft.class_1417;
import net.minecraft.class_2338;

public class BoundingBoxVillage
extends BoundingBox {
    private final class_2338 center;
    private final Integer radius;
    private final boolean spawnsIronGolems;
    private Set<class_2338> doors;
    private Double centerOffsetX;
    private Double centerOffsetZ;
    private int villageHash;

    private BoundingBoxVillage(class_2338 center, Integer radius, Color color, boolean spawnsIronGolems, Set<class_2338> doors, class_2338 minBlockPos, class_2338 maxBlockPos) {
        super(minBlockPos, maxBlockPos, color);
        this.center = center;
        this.radius = radius;
        this.spawnsIronGolems = spawnsIronGolems;
        this.doors = doors;
        this.villageHash = BoundingBoxVillage.computeHash(center, radius, spawnsIronGolems, doors);
        this.calculateCenterOffsets(doors);
    }

    public static BoundingBoxVillage from(class_2338 center, Integer radius, Color color, boolean spawnsIronGolems, Set<class_2338> doors) {
        class_2338 minBlockPos = new class_2338(center.method_10263() - radius, center.method_10264() - 4, center.method_10260() - radius);
        class_2338 maxBlockPos = new class_2338(center.method_10263() + radius, center.method_10264() + 4, center.method_10260() + radius);
        return new BoundingBoxVillage(center, radius, color, spawnsIronGolems, doors, minBlockPos, maxBlockPos);
    }

    public static BoundingBoxVillage from(class_2338 center, Integer radius, int villageId, int population, Set<class_2338> doors) {
        Boolean spawnsIronGolems = BoundingBoxVillage.shouldSpawnIronGolems(population, doors.size());
        Color color = VillageColorCache.getColor(villageId);
        return BoundingBoxVillage.from(center, radius, color, spawnsIronGolems, doors);
    }

    private static boolean shouldSpawnIronGolems(int population, int doorCount) {
        return population >= 10 && doorCount >= 21;
    }

    public static BoundingBoxVillage from(class_1415 village) {
        class_2338 center = village.method_6382();
        int radius = village.method_6403();
        Set<class_2338> doors = BoundingBoxVillage.getDoorsFromVillage(village);
        return BoundingBoxVillage.from(center, (Integer)radius, village.hashCode(), village.method_6387(), doors);
    }

    private static Set<class_2338> getDoorsFromVillage(class_1415 village) {
        HashSet<class_2338> doors = new HashSet<class_2338>();
        List doorInfoList = village.method_6405();
        for (int i = 0; i < doorInfoList.size(); ++i) {
            class_1417 doorInfo = (class_1417)doorInfoList.get(i);
            doors.add(doorInfo.method_6429());
        }
        return doors;
    }

    private void calculateCenterOffsets(Set<class_2338> doors) {
        boolean processedFirstDoor = false;
        int minX = 0;
        int maxX = 0;
        int minZ = 0;
        int maxZ = 0;
        for (class_2338 door : doors) {
            if (!processedFirstDoor || minX > door.method_10263()) {
                minX = door.method_10263();
            }
            if (!processedFirstDoor || maxX < door.method_10263()) {
                maxX = door.method_10263();
            }
            if (!processedFirstDoor || minZ > door.method_10260()) {
                minZ = door.method_10260();
            }
            if (!processedFirstDoor || maxZ < door.method_10260()) {
                maxZ = door.method_10260();
            }
            processedFirstDoor = true;
        }
        this.centerOffsetX = Math.abs(maxX - minX) % 2 == 0 ? 0.5 : (double)(minX >= 0 ? 1 : 0);
        this.centerOffsetZ = Math.abs(maxZ - minZ) % 2 == 0 ? 0.5 : (double)(minZ >= 0 ? 1 : 0);
    }

    @Override
    public String toString() {
        return "(" + this.center.toString() + "; " + this.radius.toString() + ")";
    }

    public Integer getRadius() {
        return this.radius;
    }

    public class_2338 getCenter() {
        return this.center;
    }

    public Double getCenterOffsetX() {
        return this.centerOffsetX;
    }

    public Double getCenterOffsetZ() {
        return this.centerOffsetZ;
    }

    private static int computeHash(class_2338 center, Integer radius, boolean spawnsIronGolems, Set<class_2338> doors) {
        int result = center.hashCode() * 31 + radius;
        for (class_2338 door : doors) {
            result = 31 * result + door.hashCode();
        }
        if (spawnsIronGolems) {
            result = 31 * result;
        }
        return result;
    }

    public boolean matches(class_1415 village) {
        return this.villageHash == BoundingBoxVillage.computeHash(village.method_6382(), village.method_6403(), BoundingBoxVillage.shouldSpawnIronGolems(village.method_6387(), village.method_6384()), BoundingBoxVillage.getDoorsFromVillage(village));
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.villageHash;
    }

    public boolean getSpawnsIronGolems() {
        return this.spawnsIronGolems;
    }

    public Set<class_2338> getDoors() {
        return this.doors;
    }
}

