/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.config;

import com.irtimaled.bbor.config.Configuration;
import com.irtimaled.bbor.config.Setting;
import java.io.File;

public class ConfigManager {
    public static File configDir;
    public static Setting fill;
    public static Setting drawVillages;
    public static Setting drawDesertTemples;
    public static Setting drawJungleTemples;
    public static Setting drawWitchHuts;
    public static Setting drawStrongholds;
    public static Setting drawMineShafts;
    public static Setting drawNetherFortresses;
    public static Setting drawOceanMonuments;
    public static Setting alwaysVisible;
    public static Setting renderVillageAsSphere;
    public static Setting drawIronGolemSpawnArea;
    public static Setting drawVillageDoors;
    public static Setting drawSlimeChunks;
    public static Setting slimeChunkMaxY;
    public static Setting keepCacheBetweenSessions;
    public static Setting drawWorldSpawn;
    public static Setting worldSpawnMaxY;
    public static Setting drawLazySpawnChunks;
    public static Setting drawEndCities;
    public static Setting drawMansions;
    public static Setting drawShipwrecks;
    public static Setting drawOceanRuins;
    public static Setting drawBuriedTreasure;
    public static Setting drawIgloos;

    public static void loadConfig(File mcConfigDir) {
        configDir = mcConfigDir;
        configDir.mkdirs();
        Configuration config = new Configuration(new File(configDir, "BBOutlineReloaded.cfg"));
        config.load();
        fill = ConfigManager.SetupBooleanProperty(config, "general", "fill", true, "If set to true the bounding boxes are filled. (default: true)");
        alwaysVisible = ConfigManager.SetupBooleanProperty(config, "general", "alwaysVisible", false, "If set to true boxes will be visible even through other blocks. (default: false)");
        keepCacheBetweenSessions = ConfigManager.SetupBooleanProperty(config, "general", "keepCacheBetweenSessions", false, "If set to true bounding box caches will be kept between sessions. (default: false)");
        drawVillages = ConfigManager.SetupBooleanProperty(config, "features", "drawVillages", true, "If set to true village bounding boxes are drawn. (default: true)");
        renderVillageAsSphere = ConfigManager.SetupBooleanProperty(config, "features", "renderVillageAsSphere", true, "If set to true villages will be drawn as a sphere. (default:true)");
        drawIronGolemSpawnArea = ConfigManager.SetupBooleanProperty(config, "features", "drawIronGolemSpawnArea", true, "If set to true the iron golem spawn area of the village will be drawn. (default:true)");
        drawVillageDoors = ConfigManager.SetupBooleanProperty(config, "features", "drawVillageDoors", false, "If set to true lines between the village centre and doors will be drawn. (default:false)");
        drawDesertTemples = ConfigManager.SetupBooleanProperty(config, "features", "drawDesertTemples", true, "If set to true desert temple bounding boxes are drawn. (default: true)");
        drawJungleTemples = ConfigManager.SetupBooleanProperty(config, "features", "drawJungleTemples", true, "If set to true jungle temple bounding boxes are drawn. (default: true)");
        drawWitchHuts = ConfigManager.SetupBooleanProperty(config, "features", "drawWitchHuts", true, "If set to true witch hut bounding boxes are drawn. (default: true)");
        drawStrongholds = ConfigManager.SetupBooleanProperty(config, "features", "drawStrongholds", false, "If set to true stronghold bounding boxes are drawn. (default: false)");
        drawMineShafts = ConfigManager.SetupBooleanProperty(config, "features", "drawMineShafts", false, "If set to true mineshaft bounding boxes are drawn. (default: false)");
        drawNetherFortresses = ConfigManager.SetupBooleanProperty(config, "features", "drawNetherFortresses", true, "If set to true nether fortress bounding boxes are drawn. (default: true)");
        drawOceanMonuments = ConfigManager.SetupBooleanProperty(config, "features", "drawOceanMonuments", true, "If set to true ocean monument bounding boxes are drawn. (default: true)");
        drawSlimeChunks = ConfigManager.SetupBooleanProperty(config, "features", "drawSlimeChunks", true, "If set to true slime chunks bounding boxes are drawn. (default: true)");
        slimeChunkMaxY = ConfigManager.SetupIntegerProperty(config, "features", "slimeChunkMaxY", -1, "The maximum top of the slime chunk bounding box. If set to -1 it will use the value when activated, if set to 0 it will always track the player's feet. (default: -1)");
        drawWorldSpawn = ConfigManager.SetupBooleanProperty(config, "features", "drawWorldSpawn", true, "If set to true world spawn and spawn chunks bounding boxes are drawn. (default: true)");
        worldSpawnMaxY = ConfigManager.SetupIntegerProperty(config, "features", "worldSpawnMaxY", -1, "The maximum top of the world spawn bounding boxes. If set to -1 it will use the value when activated, if set to 0 it will always track the players feet. (default: -1)");
        drawLazySpawnChunks = ConfigManager.SetupBooleanProperty(config, "features", "drawLazySpawnChunks", false, "If set to true the lazy spawn chunks bounding boxes will be drawn. (default: false)");
        drawEndCities = ConfigManager.SetupBooleanProperty(config, "features", "drawEndCities", true, "If set to true end city bounding boxes will be drawn. (default: true)");
        drawMansions = ConfigManager.SetupBooleanProperty(config, "features", "drawMansions", true, "If set to true woodland mansions will be drawn. (default: true)");
        drawIgloos = ConfigManager.SetupBooleanProperty(config, "features", "drawIgloos", true, "If set to true igloos will be drawn. (default: true)");
        drawShipwrecks = ConfigManager.SetupBooleanProperty(config, "features", "drawShipwrecks", true, "If set to true shipwrecks will be drawn. (default: true)");
        drawOceanRuins = ConfigManager.SetupBooleanProperty(config, "features", "drawOceanRuins", true, "If set to true ocean ruins will be drawn. (default: true)");
        drawBuriedTreasure = ConfigManager.SetupBooleanProperty(config, "features", "drawBuriedTreasures", true, "If set to true buried treasure will be drawn. (default: true)");
        config.save();
    }

    private static Setting SetupBooleanProperty(Configuration config, String category, String settingName, Boolean defaultValue, String comment) {
        Setting property = config.get(category, settingName, defaultValue);
        property.comment = comment;
        property.set(property.getBoolean(defaultValue));
        return property;
    }

    private static Setting SetupIntegerProperty(Configuration config, String category, String settingName, int defaultValue, String comment) {
        Setting property = config.get(category, settingName, defaultValue);
        property.comment = comment;
        property.set(property.getInt(defaultValue));
        return property;
    }
}

