/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.config;

import com.google.common.io.Files;
import com.irtimaled.bbor.config.Setting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Configuration {
    private final File file;
    private Map<String, Map<String, Setting>> settingsGroup = new HashMap<String, Map<String, Setting>>();

    Configuration(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "utf-8"));
            writer.write("# Configuration file\n");
            for (String category : this.settingsGroup.keySet()) {
                writer.write("\n");
                writer.write(String.format("%s {\n", category));
                Map<String, Setting> settings = this.settingsGroup.get(category);
                Boolean first = true;
                for (String settingName : settings.keySet()) {
                    if (!first.booleanValue()) {
                        writer.write("\n");
                    }
                    first = false;
                    Setting setting = settings.get(settingName);
                    writer.write(String.format("    # %s\n", setting.comment));
                    writer.write(String.format("    %s:%s=%s\n", setting.getType(), settingName, setting.getValue()));
                }
                writer.write("}\n");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    void load() {
        try {
            List lines = Files.readLines((File)this.file, (Charset)Charset.forName("utf-8"));
            String category = null;
            String lastCommentLine = null;
            for (String line : lines) {
                String trimmedLine = line.trim();
                if (trimmedLine.isEmpty()) continue;
                if (trimmedLine.startsWith("#")) {
                    lastCommentLine = trimmedLine.substring(1).trim();
                    continue;
                }
                if (trimmedLine.equals("}")) {
                    category = null;
                    continue;
                }
                if (category == null && trimmedLine.endsWith("{")) {
                    category = trimmedLine.substring(0, trimmedLine.length() - 1).trim();
                    this.settingsGroup.put(category, new HashMap());
                    continue;
                }
                if (category == null) continue;
                String[] items = trimmedLine.split("[:=]");
                char type = items[0].charAt(0);
                String name = items[1];
                String stringValue = items[2];
                Object value = this.getTypedValue(type, stringValue);
                Setting setting = new Setting(value);
                setting.comment = lastCommentLine;
                this.settingsGroup.get(category).put(name, setting);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object getTypedValue(char type, String stringValue) {
        switch (type) {
            case 'I': {
                return Integer.parseInt(stringValue);
            }
            case 'B': {
                return stringValue.equals("1") || stringValue.toLowerCase().equals("true");
            }
        }
        return stringValue;
    }

    public Setting get(String category, String settingName, Object defaultValue) {
        Map<String, Setting> settings;
        if (!this.settingsGroup.containsKey(category)) {
            this.settingsGroup.put(category, new HashMap());
        }
        if (!(settings = this.settingsGroup.get(category)).containsKey(settingName)) {
            settings.put(settingName, new Setting(defaultValue));
        }
        return settings.get(settingName);
    }
}

