/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import de.siphalor.nbtcrafting.util.NbtHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;

public class IngredientEntryCondition {
    private class_2487 requiredElements;
    private class_2487 deniedElements;

    public IngredientEntryCondition() {
        this.requiredElements = new class_2487();
        this.deniedElements = new class_2487();
    }

    public IngredientEntryCondition(class_2487 requiredElements, class_2487 deniedElements) {
        this.requiredElements = requiredElements;
        this.deniedElements = deniedElements;
    }

    public boolean matches(class_1799 stack) {
        if (!stack.method_7985()) {
            return this.requiredElements.isEmpty();
        }
        class_2487 tag = stack.method_7969();
        if (NbtHelper.compoundsOverlap(tag, this.deniedElements)) {
            return false;
        }
        return NbtHelper.isCompoundContained(this.requiredElements, tag);
    }

    public void addToJson(JsonObject json) {
        if (this.requiredElements.method_10546() > 0) {
            json.add("require", (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)this.requiredElements));
        }
        if (this.deniedElements.method_10546() > 0) {
            json.add("deny", (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)this.deniedElements));
        }
    }

    public class_2487 getPreviewTag() {
        return this.requiredElements;
    }

    public static IngredientEntryCondition fromJson(JsonObject json) {
        IngredientEntryCondition condition = new IngredientEntryCondition();
        if (json.has("require")) {
            if (!json.get("require").isJsonObject()) {
                throw new JsonParseException("data.require must be an object");
            }
            condition.requiredElements = (class_2487)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)class_2509.field_11560, (Object)json.getAsJsonObject("require"));
        }
        if (json.has("deny")) {
            if (!json.get("deny").isJsonObject()) {
                throw new JsonParseException("data.deny must be an object");
            }
            condition.deniedElements = (class_2487)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)class_2509.field_11560, (Object)json.getAsJsonObject("deny"));
        }
        return condition;
    }

    public void write(class_2540 buf) {
        buf.method_10794(this.requiredElements);
        buf.method_10794(this.deniedElements);
    }

    public static IngredientEntryCondition read(class_2540 buf) {
        return new IngredientEntryCondition(buf.method_10798(), buf.method_10798());
    }
}

