/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting.ingredient.IngredientEntry;
import de.siphalor.nbtcrafting.ingredient.IngredientEntryCondition;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class IngredientMultiStackEntry
extends IngredientEntry {
    private IngredientEntryCondition condition;
    private IntList itemIds;
    private String tag;

    public IngredientMultiStackEntry(Collection<Integer> items, IngredientEntryCondition condition) {
        this.condition = condition;
        this.itemIds = new IntArrayList(items);
        this.tag = "";
    }

    @Override
    public boolean matches(class_1799 stack) {
        return this.itemIds.contains(class_2378.field_11142.method_10249((Object)stack.method_7909())) && this.condition.matches(stack);
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.tag);
        this.condition.addToJson(json);
        return json;
    }

    @Override
    public Collection<class_1799> getPreviewStacks() {
        class_2487 tag = this.condition.getPreviewTag();
        Collection stacks = this.itemIds.stream().map(id -> new class_1799((class_1935)class_2378.field_11142.method_10200(id.intValue()))).collect(Collectors.toList());
        for (class_1799 itemStack : stacks) {
            itemStack.method_7980(tag);
        }
        return stacks;
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10804(this.itemIds.size());
        for (int i = 0; i < this.itemIds.size(); ++i) {
            buf.method_10804(this.itemIds.getInt(i));
        }
        this.condition.write(buf);
    }

    public static IngredientMultiStackEntry read(class_2540 buf) {
        int length = buf.method_10816();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < length; ++i) {
            ids.add(buf.method_10816());
        }
        return new IngredientMultiStackEntry(ids, IngredientEntryCondition.read(buf));
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

