/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.mixin;

import com.google.common.base.Predicates;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import de.siphalor.nbtcrafting.ingredient.IngredientEntry;
import de.siphalor.nbtcrafting.ingredient.IngredientEntryCondition;
import de.siphalor.nbtcrafting.ingredient.IngredientMultiStackEntry;
import de.siphalor.nbtcrafting.ingredient.IngredientStackEntry;
import de.siphalor.nbtcrafting.util.ICloneable;
import de.siphalor.nbtcrafting.util.IIngredient;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1856.class})
public abstract class IngredientMixin
implements IIngredient,
ICloneable {
    private IngredientEntry[] realEntries;
    @Shadow
    private class_1799[] field_9018;
    @Shadow
    private IntList field_9016;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(Stream stream, CallbackInfo ci) {
        this.realEntries = new IngredientEntry[0];
    }

    @Overwrite
    private void method_8096() {
        if (this.field_9018 != null) {
            return;
        }
        this.field_9018 = (class_1799[])Arrays.stream(this.realEntries).flatMap(entry -> entry.getPreviewStacks().stream()).distinct().toArray(class_1799[]::new);
    }

    @Overwrite
    public boolean method_8093(class_1799 stack) {
        if (this.realEntries.length == 0) {
            return stack.method_7960();
        }
        for (int i = 0; i < this.realEntries.length; ++i) {
            if (!this.realEntries[i].matches(stack)) continue;
            return true;
        }
        return false;
    }

    @Overwrite
    public IntList method_8100() {
        if (this.field_9016 == null) {
            this.method_8096();
            this.field_9016 = new IntArrayList(Arrays.stream(this.field_9018).map(stack -> class_1662.method_7408((class_1799)stack)).iterator());
        }
        return this.field_9016;
    }

    @Overwrite
    public void method_8088(class_2540 buf) {
        buf.method_10804(this.realEntries.length);
        for (int i = 0; i < this.realEntries.length; ++i) {
            IngredientEntry entry = this.realEntries[i];
            buf.writeBoolean(entry instanceof IngredientMultiStackEntry);
            entry.write(buf);
        }
    }

    @Overwrite
    public JsonElement method_8089() {
        if (this.realEntries.length == 1) {
            return this.realEntries[0].toJson();
        }
        JsonArray array = new JsonArray();
        for (int i = 0; i < this.realEntries.length; ++i) {
            array.add(this.realEntries[i].toJson());
        }
        return array;
    }

    @Overwrite
    public boolean method_8103() {
        return this.realEntries.length == 0;
    }

    private static class_1856 ofRealEntries(Stream<? extends IngredientEntry> entries) {
        if (entries == null) {
            System.out.println("ERROR");
        }
        try {
            class_1856 ingredient = (class_1856)((ICloneable)class_1856.field_9017).clone();
            ((IIngredient)IIngredient.class.cast(ingredient)).setRealEntries(entries);
            return ingredient;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return class_1856.field_9017;
        }
    }

    @Overwrite
    public static class_1856 method_8091(class_1935 ... arr) {
        return IngredientMixin.ofRealEntries(Stream.of(new IngredientMultiStackEntry(Arrays.stream(arr).map(item -> class_2378.field_11142.method_10249((Object)item.method_8389())).collect(Collectors.toList()), new IngredientEntryCondition())));
    }

    @Overwrite
    public static class_1856 method_8101(class_1799 ... arr) {
        return IngredientMixin.ofRealEntries(Arrays.stream(arr).map(stack -> new IngredientStackEntry((class_1799)stack)));
    }

    @Overwrite
    public static class_1856 method_8106(class_3494<class_1792> tag) {
        return IngredientMixin.ofRealEntries(Stream.of(new IngredientMultiStackEntry(tag.method_15138().stream().map(item -> class_2378.field_11142.method_10249(item)).collect(Collectors.toList()), new IngredientEntryCondition())));
    }

    @Overwrite
    public static class_1856 method_8086(class_2540 buf) {
        ArrayList<IngredientEntry> entries = new ArrayList<IngredientEntry>();
        int length = buf.method_10816();
        for (int i = 0; i < length; ++i) {
            if (buf.readBoolean()) {
                entries.add(IngredientMultiStackEntry.read(buf));
                continue;
            }
            entries.add(IngredientStackEntry.read(buf));
        }
        return IngredientMixin.ofRealEntries(entries.stream());
    }

    @Overwrite
    public static class_1856 method_8102(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (element.isJsonObject()) {
            return IngredientMixin.ofRealEntries(Stream.of(IngredientMixin.realEntryFromJson(element.getAsJsonObject())));
        }
        if (!element.isJsonArray()) {
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        JsonArray jsonArray = element.getAsJsonArray();
        if (jsonArray.size() == 0) {
            throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
        }
        return IngredientMixin.ofRealEntries(StreamSupport.stream(jsonArray.spliterator(), false).map(e -> IngredientMixin.realEntryFromJson(class_3518.method_15295((JsonElement)e, (String)"item"))));
    }

    private static IngredientEntry realEntryFromJson(JsonObject jsonObject) {
        if (jsonObject.has("item") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (jsonObject.has("item")) {
            class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"item"));
            try {
                class_1792 item2 = (class_1792)class_2378.field_11142.method_17966(identifier).orElseThrow(() -> {
                    throw new JsonSyntaxException("Unknown item '" + identifier.toString() + "'");
                });
                return new IngredientStackEntry(class_2378.field_11142.method_10249((Object)item2), IngredientMixin.loadIngredientEntryCondition(jsonObject));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        if (!jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry needs either a tag or an item");
        }
        class_2960 identifier2 = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"tag"));
        class_3494 tag = class_3489.method_15106().method_15193(identifier2);
        if (tag == null) {
            throw new JsonSyntaxException("Unknown item tag '" + identifier2 + "'");
        }
        IngredientMultiStackEntry entry = new IngredientMultiStackEntry(tag.method_15138().stream().map(item -> class_2378.field_11142.method_10249(item)).collect(Collectors.toList()), IngredientMixin.loadIngredientEntryCondition(jsonObject));
        entry.setTag(tag.toString());
        return entry;
    }

    private static IngredientEntryCondition loadIngredientEntryCondition(JsonObject jsonObject) {
        if (jsonObject.has("data")) {
            if (class_3518.method_15286((JsonElement)jsonObject.get("data"))) {
                throw new JsonParseException("The data tag on recipes cannot be a string anymore; See the wiki for more information ;)");
            }
            if (jsonObject.get("data").isJsonObject()) {
                return IngredientEntryCondition.fromJson(jsonObject.get("data").getAsJsonObject());
            }
        }
        return new IngredientEntryCondition();
    }

    @Override
    public void setRealEntries(Stream<? extends IngredientEntry> entries) {
        this.realEntries = (IngredientEntry[])entries.filter((Predicate<? extends IngredientEntry>)Predicates.notNull()).toArray(IngredientEntry[]::new);
    }
}

