/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.util;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import de.siphalor.nbtcrafting.util.NbtNumberRange;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2520;

public class NbtHelper {
    public static boolean tagsMatch(class_2520 main, class_2520 reference) {
        if (NbtHelper.isString(reference) && reference.method_10714().equals("")) {
            return true;
        }
        if (NbtHelper.isString(main) && NbtHelper.isString(reference)) {
            return main.method_10714().equals(reference.method_10714());
        }
        if (NbtHelper.isNumeric(main)) {
            if (NbtHelper.isNumeric(reference)) {
                return ((class_2514)main).method_10697() == ((class_2514)reference).method_10697();
            }
            if (NbtHelper.isString(reference) && reference.method_10714().startsWith("$")) {
                return NbtNumberRange.ofString(reference.method_10714().substring(1)).matches(((class_2514)main).method_10697());
            }
            return false;
        }
        return false;
    }

    public static boolean compoundsOverlap(class_2487 main, class_2487 reference) {
        for (String key : main.method_10541()) {
            if (!reference.method_10545(key) || !(NbtHelper.isCompound(main.method_10580(key)) && NbtHelper.isCompound(reference.method_10580(key)) ? NbtHelper.compoundsOverlap(main.method_10562(key), reference.method_10562(key)) : (NbtHelper.isList(main.method_10580(key)) && NbtHelper.isList(reference.method_10580(key)) ? NbtHelper.listsOverlap((class_2499)main.method_10580(key), (class_2499)reference.method_10580(key)) : NbtHelper.tagsMatch(main.method_10580(key), reference.method_10580(key))))) continue;
            return true;
        }
        return false;
    }

    public static boolean listsOverlap(class_2499 main, class_2499 reference) {
        for (class_2520 mainTag : main) {
            for (class_2520 referenceTag : main) {
                if (!(NbtHelper.isCompound(mainTag) && NbtHelper.isCompound(referenceTag) ? NbtHelper.compoundsOverlap((class_2487)mainTag, (class_2487)referenceTag) : (NbtHelper.isList(mainTag) && NbtHelper.isList(referenceTag) ? NbtHelper.listsOverlap((class_2499)mainTag, (class_2499)referenceTag) : NbtHelper.tagsMatch(mainTag, referenceTag)))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCompoundContained(class_2487 inner, class_2487 outer) {
        for (String key : inner.method_10541()) {
            class_2520 innerTag = inner.method_10580(key);
            if (!outer.method_10545(key)) {
                return false;
            }
            class_2520 outerTag = outer.method_10580(key);
            if (NbtHelper.isCompound(innerTag) && NbtHelper.isCompound(outerTag)) {
                if (NbtHelper.isCompoundContained((class_2487)innerTag, (class_2487)outerTag)) continue;
                return false;
            }
            if (NbtHelper.isList(innerTag) && NbtHelper.isList(outerTag)) {
                if (NbtHelper.isListContained((class_2499)innerTag, (class_2499)outerTag)) continue;
                return false;
            }
            if (NbtHelper.tagsMatch(outerTag, innerTag)) continue;
            return false;
        }
        return true;
    }

    public static boolean isListContained(class_2499 inner, class_2499 outer) {
        for (class_2520 innerTag : inner) {
            boolean success = false;
            for (class_2520 outerTag : outer) {
                if (NbtHelper.isCompound(innerTag) && NbtHelper.isCompound(outerTag) && NbtHelper.isCompoundContained((class_2487)innerTag, (class_2487)outerTag)) {
                    success = true;
                    break;
                }
                if (NbtHelper.isList(innerTag) && NbtHelper.isList(outerTag) && NbtHelper.isListContained((class_2499)innerTag, (class_2499)outerTag)) {
                    success = true;
                    break;
                }
                if (!NbtHelper.tagsMatch(innerTag, outerTag)) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    public static boolean sameType(class_2520 tag1, class_2520 tag2) {
        return Objects.equals(class_2509.field_11560.method_10642(tag1), class_2509.field_11560.method_10642(tag2));
    }

    public static boolean isString(class_2520 tag) {
        return Objects.equals(class_2509.field_11560.method_10642(tag), DSL.string());
    }

    public static boolean isCompound(class_2520 tag) {
        return Objects.equals(class_2509.field_11560.method_10642(tag), DSL.compoundList((Type)DSL.remainderType(), (Type)DSL.remainderType()));
    }

    public static boolean isList(class_2520 tag) {
        return Objects.equals(class_2509.field_11560.method_10642(tag), DSL.list((Type)DSL.remainderType()));
    }

    public static boolean isNumeric(class_2520 tag) {
        Type type = class_2509.field_11560.method_10642(tag);
        return Objects.equals(type, DSL.byteType()) || Objects.equals(type, DSL.shortType()) || Objects.equals(type, DSL.intType()) || Objects.equals(type, DSL.longType()) || Objects.equals(type, DSL.floatType()) || Objects.equals(type, DSL.doubleType());
    }
}

