/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.prefab.module;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.TransformUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3965;
import net.minecraft.class_824;

public abstract class AbstractModule
implements Module {
    private final Casing casing;
    private final Face face;

    protected AbstractModule(Casing casing, Face face) {
        this.casing = casing;
        this.face = face;
    }

    protected void cancelWrite() {
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            sendingPipe.cancelWrite();
        }
    }

    protected void cancelRead() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            receivingPipe.cancelRead();
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected boolean isObserverLookingAt(class_824 rendererDispatcher) {
        class_239 hitResult = rendererDispatcher.field_4350;
        if (hitResult == null) {
            return false;
        }
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return false;
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        if (!this.getCasing().getPosition().equals((Object)blockHitResult.method_17777())) {
            return false;
        }
        return blockHitResult.method_17780() == Face.toDirection(this.getFace());
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    protected class_243 getObserverLookAt(class_824 rendererDispatcher) {
        class_239 hitResult = rendererDispatcher.field_4350;
        if (hitResult == null) {
            return null;
        }
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        if (!this.getCasing().getPosition().equals((Object)blockHitResult.method_17777())) {
            return null;
        }
        if (blockHitResult.method_17780() != Face.toDirection(this.getFace())) {
            return null;
        }
        return new class_243(hitResult.method_17784().field_1352 - (double)blockHitResult.method_17777().method_10263(), hitResult.method_17784().field_1351 - (double)blockHitResult.method_17777().method_10264(), hitResult.method_17784().field_1350 - (double)blockHitResult.method_17777().method_10260());
    }

    protected class_243 hitToUV(class_243 hitPos) {
        return TransformUtil.hitToUV(this.getFace(), hitPos);
    }

    protected boolean isVisible() {
        class_2338 neighborPos;
        class_1937 world = this.getCasing().getCasingWorld();
        if (!world.method_8591(neighborPos = this.getCasing().getPosition().method_10093(Face.toDirection(this.getFace())))) {
            return false;
        }
        class_2791 chunk = world.method_16955(neighborPos);
        if (chunk instanceof class_2818 && ((class_2818)chunk).method_12223()) {
            return true;
        }
        class_2680 neighborState = world.method_8320(neighborPos);
        return !neighborState.method_11620().method_15804();
    }

    @Override
    public Casing getCasing() {
        return this.casing;
    }

    @Override
    public Face getFace() {
        return this.face;
    }

    @Override
    public void step() {
    }

    @Override
    public void onInstalled(class_1799 stack) {
    }

    @Override
    public void onUninstalled(class_1799 stack) {
    }

    @Override
    public void onEnabled() {
    }

    @Override
    public void onDisabled() {
    }

    @Override
    public void onDisposed() {
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
    }

    @Override
    public void onWriteComplete(Port port) {
    }

    @Override
    public boolean onActivate(class_1657 player, class_1268 hand, class_243 hit) {
        return false;
    }

    @Override
    public void onData(class_2487 nbt) {
    }

    @Override
    public void onData(ByteBuf data) {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks) {
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
    }
}

