/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.item.CodeBookItem;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.CodeBookDataMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class CodeBookGui
extends class_437 {
    private static final int GUI_WIDTH = 148;
    private static final int GUI_HEIGHT = 230;
    private static final int BUTTON_PAGE_CHANGE_PREV_X = 8;
    private static final int BUTTON_PAGE_CHANGE_NEXT_X = 116;
    private static final int BUTTON_PAGE_CHANGE_Y = 224;
    private static final int BUTTON_PAGE_DELETE_X = 66;
    private static final int BUTTON_PAGE_DELETE_Y = 224;
    private static final int CODE_POS_X = 18;
    private static final int CODE_POS_Y = 16;
    private static final int CODE_WIDTH = 120;
    private static final int CODE_MARGIN = 30;
    private static final int PAGE_NUMBER_X = 74;
    private static final int PAGE_NUMBER_Y = 212;
    private static final int COLOR_CODE = -13421773;
    private static final int COLOR_CODE_SELECTED = -1118482;
    private static final int COLOR_SELECTION = -869059687;
    private static final int ID_BUTTON_PAGE_NEXT = 1;
    private static final int ID_BUTTON_PAGE_PREV = 2;
    private static final int ID_BUTTON_PAGE_DELETE = 3;
    private ButtonChangePage buttonNextPage;
    private ButtonChangePage buttonPreviousPage;
    private ButtonDeletePage buttonDeletePage;
    private final class_1657 player;
    private final class_1268 hand;
    private final CodeBookItem.Data data;
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private int guiX = 0;
    private int guiY = 0;
    private int selectionStart = 0;
    private int selectionEnd = 0;
    private Optional<ParseException> compileError = Optional.empty();

    CodeBookGui(class_1657 player, class_1268 hand) {
        this.player = player;
        this.hand = hand;
        this.data = CodeBookItem.Data.loadFromStack(player.method_5998(hand));
        this.rebuildLines();
    }

    public void method_2224() {
        super.method_2224();
        this.guiX = (this.field_2561 - 148) / 2;
        this.guiY = 2;
        this.buttonPreviousPage = new ButtonChangePage(2, this.guiX + 8, this.guiY + 224, PageChangeType.Previous);
        this.method_2219(this.buttonPreviousPage);
        this.buttonNextPage = new ButtonChangePage(1, this.guiX + 116, this.guiY + 224, PageChangeType.Next);
        this.method_2219(this.buttonNextPage);
        this.buttonDeletePage = new ButtonDeletePage(3, this.guiX + 66, this.guiY + 224);
        this.method_2219(this.buttonDeletePage);
        this.field_2563.field_1774.method_1462(true);
    }

    public void method_2234() {
        super.method_2234();
        this.saveProgram();
        class_2487 nbt = new class_2487();
        this.data.writeToNBT(nbt);
        Network.INSTANCE.sendToServer(new CodeBookDataMessage(nbt, this.hand));
        this.field_2563.field_1774.method_1462(false);
    }

    public void method_2214(int mouseX, int mouseY, float partialTicks) {
        if (!this.player.method_5805() || !Items.isBookCode(this.player.method_5998(this.hand))) {
            class_310.method_1551().method_1494(null);
            return;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310.method_1551().method_1531().method_4618(Textures.LOCATION_GUI_BOOK_CODE_BACKGROUND);
        this.method_1788(this.guiX, this.guiY, 0, 0, 148, 230);
        this.buttonPreviousPage.field_2076 = this.data.getSelectedPage() > 0 && this.data.getPageCount() > 0;
        this.buttonNextPage.field_2076 = this.data.getSelectedPage() < this.data.getPageCount() - 1 || this.data.getSelectedPage() == this.data.getPageCount() - 1 && this.isCurrentProgramNonEmpty();
        this.buttonDeletePage.field_2076 = this.data.getPageCount() > 1 || this.isCurrentProgramNonEmpty();
        super.method_2214(mouseX, mouseY, partialTicks);
        this.drawProgram(mouseX, mouseY);
        String pageInfo = String.format("%d/%d", this.data.getSelectedPage() + 1, this.data.getPageCount());
        this.getFontRenderer().method_1729(pageInfo, (float)(this.guiX + 74 - this.getFontRenderer().method_1727(pageInfo) / 2), (float)(this.guiY + 212), -13421773);
    }

    public boolean method_16807(double mouseXd, double mouseYd, int mouseButton) {
        int mouseY;
        if (super.method_16807(mouseXd, mouseYd, mouseButton)) {
            return true;
        }
        int mouseX = (int)Math.round(mouseXd);
        if (this.isInCodeArea(mouseX, mouseY = (int)Math.round(mouseYd))) {
            int line = this.cursorToLine(mouseY);
            int column = this.cursorToColumn(mouseX + 2, mouseY);
            this.selectionStart = this.selectionEnd = this.positionToIndex(line, column);
            return true;
        }
        return false;
    }

    public boolean method_16801(double mouseXd, double mouseYd, int clickedMouseButton, double da, double db) {
        int mouseY;
        if (super.method_16801(mouseXd, mouseYd, clickedMouseButton, da, db)) {
            return true;
        }
        int mouseX = (int)Math.round(mouseXd);
        if (this.isInCodeArea(mouseX, mouseY = (int)Math.round(mouseYd))) {
            int line = this.cursorToLine(mouseY);
            int column = this.cursorToColumn(mouseX + 2, mouseY);
            this.selectionEnd = this.positionToIndex(line, column);
            return true;
        }
        return false;
    }

    public boolean method_16805(int keyCode, int scancode, int mods) {
        if (super.method_16805(keyCode, scancode, mods)) {
            return true;
        }
        int line = this.indexToLine(this.getSelectionStart());
        int column = this.indexToColumn(this.getSelectionStart());
        if (keyCode == 263) {
            if (column > 0 || line > 0) {
                if (CodeBookGui.method_2223()) {
                    --this.selectionEnd;
                } else {
                    this.selectionStart = --this.selectionEnd;
                }
            }
        } else if (keyCode == 262) {
            if (column < this.lines.get(line).length() || line < this.lines.size() - 1) {
                if (CodeBookGui.method_2223()) {
                    ++this.selectionEnd;
                } else {
                    this.selectionStart = ++this.selectionEnd;
                }
            }
        } else if (keyCode == 265) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (currLine > 0) {
                int currColumn = this.indexToColumn(this.selectionEnd);
                int x = this.columnToX(currLine, currColumn) + 2;
                int prevLine = currLine - 1;
                int prevColumn = this.xToColumn(x, prevLine);
                int index = this.positionToIndex(prevLine, prevColumn);
                if (CodeBookGui.method_2223()) {
                    this.selectionEnd = index;
                } else {
                    this.selectionStart = this.selectionEnd = index;
                }
            }
        } else if (keyCode == 264) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (currLine < this.lines.size() - 1) {
                int currColumn = this.indexToColumn(this.selectionEnd);
                int x = this.columnToX(currLine, currColumn) + 2;
                int nextLine = currLine + 1;
                int nextColumn = this.xToColumn(x, nextLine);
                int index = this.positionToIndex(nextLine, nextColumn);
                if (CodeBookGui.method_2223()) {
                    this.selectionEnd = index;
                } else {
                    this.selectionStart = this.selectionEnd = index;
                }
            }
        } else if (keyCode == 268) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (CodeBookGui.method_2223()) {
                this.selectionEnd = this.positionToIndex(currLine, 0);
            } else {
                this.selectionStart = this.selectionEnd = this.positionToIndex(currLine, 0);
            }
        } else if (keyCode == 269) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (CodeBookGui.method_2223()) {
                this.selectionEnd = this.positionToIndex(currLine, this.lines.get(currLine).length());
            } else {
                this.selectionStart = this.selectionEnd = this.positionToIndex(currLine, this.lines.get(currLine).length());
            }
        } else if (keyCode == 261) {
            if (!this.deleteSelection()) {
                if (CodeBookGui.method_2223()) {
                    if (this.lines.size() > 1) {
                        this.lines.remove(line);
                    } else {
                        this.lines.get(0).setLength(0);
                    }
                    this.selectionStart = this.selectionEnd = this.positionToIndex(Math.min(this.lines.size() - 1, line), 0);
                } else if (column < this.lines.get(line).length()) {
                    this.lines.get(line).deleteCharAt(column);
                } else if (line < this.lines.size() - 1) {
                    StringBuilder currLine = this.lines.get(line);
                    StringBuilder nextLine = this.lines.get(line + 1);
                    if (currLine.length() + nextLine.length() < Settings.maxColumnsPerLine) {
                        currLine.append((CharSequence)nextLine);
                        this.lines.remove(line + 1);
                    }
                }
            }
            this.recompile();
        } else if (keyCode == 259) {
            if (!this.deleteSelection()) {
                if (column > 0) {
                    this.lines.get(line).deleteCharAt(column - 1);
                } else if (line > 0) {
                    StringBuilder prevLine = this.lines.get(line - 1);
                    StringBuilder currLine = this.lines.get(line);
                    if (prevLine.length() + currLine.length() < Settings.maxColumnsPerLine) {
                        prevLine.append((CharSequence)currLine);
                        this.lines.remove(line);
                    }
                }
                this.selectionStart = this.selectionEnd = Math.max(0, this.selectionEnd - 1);
            }
            this.recompile();
        } else if (keyCode == 257) {
            this.deleteSelection();
            if (this.lines.size() < 20) {
                StringBuilder oldLine = this.lines.get(line);
                StringBuilder newLine = new StringBuilder();
                if (column < oldLine.length()) {
                    newLine.append(oldLine.substring(column));
                    oldLine.setLength(column);
                }
                this.lines.add(line + 1, newLine);
                this.selectionStart = ++this.selectionEnd;
            }
            this.recompile();
        } else if (CodeBookGui.method_2238()) {
            if (keyCode == 65) {
                this.selectionStart = 0;
                this.selectionEnd = this.positionToIndex(Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else if (keyCode == 67) {
                class_310.method_1551().field_1774.method_1455(this.selectionToString());
            } else if (keyCode == 88) {
                class_310.method_1551().field_1774.method_1455(this.selectionToString());
                this.deleteSelection();
                this.recompile();
            } else if (keyCode == 86) {
                this.deleteSelection();
                String[] pastedLines = Constants.PATTERN_LINES.split(class_310.method_1551().field_1774.method_1460());
                if (!this.isValidPaste(pastedLines)) {
                    return true;
                }
                this.lines.get(line).insert(this.indexToColumn(column), pastedLines[0].toUpperCase(Locale.US));
                this.lines.addAll(line + 1, Arrays.stream(pastedLines).skip(1L).map(l -> l.toUpperCase(Locale.US)).map(StringBuilder::new).collect(Collectors.toList()));
                this.selectionStart = this.selectionEnd += pastedLines[0].length();
                for (int i = 1; i < pastedLines.length; ++i) {
                    this.selectionStart = this.selectionEnd = this.selectionEnd + 1 + pastedLines[i].length();
                }
                this.recompile();
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean method_16806(char chr, int code) {
        if (super.method_16806(chr, code)) {
            return true;
        }
        if (Character.isISOControl(chr)) {
            return false;
        }
        this.deleteSelection();
        int line = this.indexToLine(this.getSelectionStart());
        int column = this.indexToColumn(this.getSelectionStart());
        if (this.lines.get(line).length() < Settings.maxColumnsPerLine) {
            this.lines.get(line).insert(column, String.valueOf(chr).toUpperCase(Locale.US));
            this.selectionStart = ++this.selectionEnd;
        }
        this.recompile();
        return true;
    }

    public boolean method_2222() {
        return false;
    }

    private class_327 getFontRenderer() {
        return this.field_2554;
    }

    private int getSelectionStart() {
        return Math.min(this.selectionStart, this.selectionEnd);
    }

    private int getSelectionEnd() {
        return Math.max(this.selectionStart, this.selectionEnd);
    }

    private boolean intersectsSelection(int start, int end) {
        return start < this.getSelectionEnd() && end > this.getSelectionStart();
    }

    private String selectionToString() {
        int startLine = this.indexToLine(this.getSelectionStart());
        int endLine = this.indexToLine(this.getSelectionEnd());
        if (this.selectionStart == this.selectionEnd) {
            return this.lines.get(startLine).toString();
        }
        int startColumn = this.indexToColumn(this.getSelectionStart());
        int endColumn = this.indexToColumn(this.getSelectionEnd());
        if (startLine == endLine) {
            return this.lines.get(startLine).substring(startColumn, endColumn);
        }
        StringBuilder selection = new StringBuilder();
        selection.append(this.lines.get(startLine).subSequence(startColumn, this.lines.get(startLine).length())).append('\n');
        for (int line = startLine + 1; line < endLine; ++line) {
            selection.append(this.lines.get(line).toString()).append('\n');
        }
        selection.append(this.lines.get(endLine).subSequence(0, endColumn)).append('\n');
        return selection.toString();
    }

    private int cursorToLine(int y) {
        int n = Math.min(this.lines.size() - 1, 20);
        this.getFontRenderer().getClass();
        return Math.max(0, Math.min(n, (y - this.guiY - 16) / 9));
    }

    private int cursorToColumn(int x, int y) {
        return this.xToColumn(x, this.cursorToLine(y));
    }

    private int xToColumn(int x, int line) {
        int relX = Math.max(0, x - this.guiX - 18);
        return this.getFontRenderer().method_1714(this.lines.get(line).toString(), relX).length();
    }

    private int columnToX(int line, int column) {
        return this.guiX + 18 + this.getFontRenderer().method_1727(this.lines.get(line).substring(0, Math.min(column, this.lines.get(line).length())));
    }

    private int positionToIndex(int line, int column) {
        int index = 0;
        for (int l = 0; l < Math.min(line, this.lines.size()); ++l) {
            index += this.lines.get(l).length() + 1;
        }
        return index += Math.min(column, this.lines.get(Math.min(line, this.lines.size() - 1)).length());
    }

    private int indexToLine(int index) {
        int position = 0;
        for (int line = 0; line < this.lines.size(); ++line) {
            if ((position += this.lines.get(line).length() + 1) <= index) continue;
            return line;
        }
        return this.lines.size() - 1;
    }

    private int indexToColumn(int index) {
        int position = 0;
        for (StringBuilder line : this.lines) {
            if (position + line.length() + 1 > index) {
                return index - position;
            }
            position += line.length() + 1;
        }
        return this.lines.get(this.lines.size() - 1).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInCodeArea(int mouseX, int mouseY) {
        if (mouseX < this.guiX + 18 - 30) return false;
        if (mouseX > this.guiX + 18 + 120 + 30) return false;
        if (mouseY < this.guiY + 16 - 30) return false;
        this.getFontRenderer().getClass();
        if (mouseY > this.guiY + 16 + 9 * 20 + 30) return false;
        return true;
    }

    private boolean isCurrentProgramNonEmpty() {
        return this.lines.size() > 1 || this.lines.get(0).length() > 0;
    }

    private void recompile() {
        this.compileError = Optional.empty();
        List<String> program = this.lines.stream().map(StringBuilder::toString).collect(Collectors.toList());
        ArrayList<String> leadingCode = new ArrayList<String>();
        ArrayList<String> trailingCode = new ArrayList<String>();
        this.data.getExtendedProgram(this.data.getSelectedPage(), program, leadingCode, trailingCode);
        program.addAll(0, leadingCode);
        program.addAll(trailingCode);
        try {
            Compiler.compile(program, new MachineState());
        }
        catch (ParseException e) {
            int lineNumber = e.getLineNumber() - leadingCode.size();
            this.compileError = Optional.of(new ParseException(e.getMessage(), lineNumber, e.getStart(), e.getEnd()));
        }
    }

    private boolean deleteSelection() {
        if (this.selectionStart != this.selectionEnd) {
            int startLine = this.indexToLine(this.getSelectionStart());
            int endLine = this.indexToLine(this.getSelectionEnd());
            int startColumn = this.indexToColumn(this.getSelectionStart());
            int endColumn = this.indexToColumn(this.getSelectionEnd());
            if (startLine == endLine) {
                this.lines.get(startLine).delete(startColumn, endColumn);
            } else {
                this.lines.get(startLine).delete(startColumn, this.lines.get(startLine).length());
                this.lines.get(endLine).delete(0, endColumn);
                this.lines.get(startLine).append((CharSequence)this.lines.get(endLine));
                this.lines.subList(startLine + 1, endLine + 1).clear();
            }
            this.selectionStart = this.selectionEnd = this.getSelectionStart();
            return true;
        }
        return false;
    }

    private boolean isValidPaste(String[] pastedLines) {
        int selectedLine = this.indexToLine(this.selectionEnd);
        if (pastedLines.length == 0) {
            return false;
        }
        if (pastedLines.length - 1 + this.lines.size() > 20) {
            return false;
        }
        if (pastedLines[0].length() + this.lines.get(selectedLine).length() > Settings.maxColumnsPerLine) {
            return false;
        }
        for (String pastedLine : pastedLines) {
            if (pastedLine.length() <= Settings.maxColumnsPerLine) continue;
            return false;
        }
        return true;
    }

    private void changePage(int delta) {
        this.saveProgram();
        if (this.data.getSelectedPage() + delta == this.data.getPageCount()) {
            this.data.addPage();
        }
        this.data.setSelectedPage(this.data.getSelectedPage() + delta);
        this.selectionEnd = 0;
        this.selectionStart = 0;
        this.rebuildLines();
    }

    private void saveProgram() {
        this.data.setPage(this.data.getSelectedPage(), this.lines.stream().map(StringBuilder::toString).collect(Collectors.toList()));
    }

    private void rebuildLines() {
        if (this.data.getPageCount() < 1) {
            this.data.addPage();
        }
        List<String> program = this.data.getPage(this.data.getSelectedPage());
        this.lines.clear();
        program.forEach(line -> this.lines.add(new StringBuilder(line.toUpperCase(Locale.US))));
        this.recompile();
    }

    private void drawProgram(int mouseX, int mouseY) {
        int position = 0;
        for (int lineNumber = 0; lineNumber < this.lines.size(); ++lineNumber) {
            StringBuilder line = this.lines.get(lineNumber);
            int end = position + line.length();
            this.getFontRenderer().getClass();
            int offsetY = lineNumber * 9;
            int lineX = this.guiX + 18;
            int lineY = this.guiY + 16 + offsetY;
            if (this.selectionStart != this.selectionEnd && this.intersectsSelection(position, end)) {
                int currX = lineX;
                int prefix = Math.max(0, this.getSelectionStart() - position);
                int selected = Math.min(line.length() - prefix, this.getSelectionEnd() - (position + prefix));
                String prefixText = line.substring(0, prefix);
                this.getFontRenderer().method_1729(prefixText, (float)currX, (float)lineY, -13421773);
                String selectedText = line.substring(prefix, prefix + selected);
                int selectedWidth = this.getFontRenderer().method_1727(selectedText);
                this.getFontRenderer().getClass();
                CodeBookGui.method_1785((int)((currX += this.getFontRenderer().method_1727(prefixText)) - 1), (int)(lineY - 1), (int)(currX + selectedWidth), (int)(lineY + 9 - 1), (int)-869059687);
                this.getFontRenderer().method_1729(selectedText, (float)currX, (float)lineY, -1118482);
                String postfixString = line.substring(prefix + selected);
                this.getFontRenderer().method_1729(postfixString, (float)(currX += selectedWidth), (float)lineY, -13421773);
            } else {
                this.getFontRenderer().method_1729(line.toString(), (float)lineX, (float)lineY, -13421773);
            }
            position += line.length() + 1;
        }
        if (this.compileError.isPresent()) {
            int rawEndX;
            int startX;
            int localLineNumber;
            boolean isErrorOnNextPage;
            ParseException exception = this.compileError.get();
            boolean isErrorOnPreviousPage = exception.getLineNumber() < 0;
            boolean bl = isErrorOnNextPage = exception.getLineNumber() >= this.lines.size();
            if (isErrorOnPreviousPage) {
                localLineNumber = 0;
                startX = this.columnToX(localLineNumber, 0);
                rawEndX = this.columnToX(localLineNumber, Settings.maxColumnsPerLine);
            } else if (isErrorOnNextPage) {
                localLineNumber = this.lines.size() - 1;
                startX = this.columnToX(localLineNumber, 0);
                rawEndX = this.columnToX(localLineNumber, Settings.maxColumnsPerLine);
            } else {
                localLineNumber = exception.getLineNumber();
                startX = this.columnToX(localLineNumber, exception.getStart());
                rawEndX = this.columnToX(localLineNumber, exception.getEnd());
            }
            this.getFontRenderer().getClass();
            int startY = this.guiY + 16 + localLineNumber * 9 - 1;
            int endX = Math.max(rawEndX, startX + this.getFontRenderer().method_1727(" "));
            this.getFontRenderer().getClass();
            this.getFontRenderer().getClass();
            CodeBookGui.method_1785((int)(startX - 1), (int)(startY + 9 - 1), (int)endX, (int)(startY + 9), (int)-52429);
            this.drawTextCursor();
            if (mouseX >= startX && mouseX <= endX && mouseY >= startY) {
                this.getFontRenderer().getClass();
                if (mouseY <= startY + 9) {
                    ArrayList<String> tooltip = new ArrayList<String>();
                    if (isErrorOnPreviousPage) {
                        tooltip.add(class_1074.method_4662((String)"tis3d.book_code.error_on_previous_page", (Object[])new Object[0]));
                    } else if (isErrorOnNextPage) {
                        tooltip.add(class_1074.method_4662((String)"tis3d.book_code.error_on_next_page", (Object[])new Object[0]));
                    }
                    tooltip.addAll(Arrays.asList(Constants.PATTERN_LINES.split(class_1074.method_4662((String)exception.getMessage(), (Object[])new Object[0]))));
                    this.method_2211(tooltip, mouseX, mouseY);
                    GlStateManager.disableLighting();
                }
            }
        } else {
            this.drawTextCursor();
        }
    }

    private void drawTextCursor() {
        if (System.currentTimeMillis() % 800L <= 400L) {
            int line = this.indexToLine(this.selectionEnd);
            int column = this.indexToColumn(this.selectionEnd);
            StringBuilder sb = this.lines.get(line);
            int x = this.guiX + 18 + this.getFontRenderer().method_1727(sb.substring(0, column)) - 1;
            this.getFontRenderer().getClass();
            int y = this.guiY + 16 + line * 9 - 1;
            this.getFontRenderer().getClass();
            CodeBookGui.method_1785((int)(x + 1), (int)(y + 1), (int)(x + 2 + 1), (int)(y + 9 + 1), (int)-869059789);
            this.getFontRenderer().getClass();
            CodeBookGui.method_1785((int)x, (int)y, (int)(x + 2), (int)(y + 9), (int)-1118482);
        }
    }

    private class ButtonDeletePage
    extends class_339 {
        private static final int TEXTURE_X = 158;
        private static final int TEXTURE_Y = 231;
        private static final int BUTTON_WIDTH = 14;
        private static final int BUTTON_HEIGHT = 14;

        ButtonDeletePage(int buttonId, int x, int y) {
            super(buttonId, x, y, 14, 14, "");
        }

        public void method_1826(double p_mouseClicked_1_, double p_mouseClicked_3_) {
            CodeBookGui.this.data.removePage(CodeBookGui.this.data.getSelectedPage());
            CodeBookGui.this.rebuildLines();
        }

        public void method_1824(int mouseX, int mouseY, float partialTicks) {
            if (!this.field_2076) {
                return;
            }
            boolean isHovered = mouseX >= this.field_2069 && mouseY >= this.field_2068 && mouseX < this.field_2069 + this.field_2071 && mouseY < this.field_2068 + this.field_2070;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CodeBookGui.this.field_2563.method_1531().method_4618(Textures.LOCATION_GUI_BOOK_CODE_BACKGROUND);
            int offsetX = isHovered ? 14 : 0;
            this.method_1788(this.field_2069, this.field_2068, 158 + offsetX, 231, 14, 14);
        }
    }

    private class ButtonChangePage
    extends class_339 {
        private static final int TEXTURE_X = 110;
        private static final int TEXTURE_Y = 231;
        private static final int BUTTON_WIDTH = 23;
        private static final int BUTTON_HEIGHT = 12;
        private final PageChangeType type;

        ButtonChangePage(int buttonId, int x, int y, PageChangeType type) {
            super(buttonId, x, y, 23, 12, "");
            this.type = type;
        }

        public void method_1826(double p_mouseClicked_1_, double p_mouseClicked_3_) {
            if (this.type == PageChangeType.Next) {
                CodeBookGui.this.changePage(1);
            } else if (this.type == PageChangeType.Previous) {
                CodeBookGui.this.changePage(-1);
            }
        }

        public void method_1824(int mouseX, int mouseY, float partialTicks) {
            if (!this.field_2076) {
                return;
            }
            boolean isHovered = mouseX >= this.field_2069 && mouseY >= this.field_2068 && mouseX < this.field_2069 + this.field_2071 && mouseY < this.field_2068 + this.field_2070;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CodeBookGui.this.field_2563.method_1531().method_4618(Textures.LOCATION_GUI_BOOK_CODE_BACKGROUND);
            int offsetX = isHovered ? 23 : 0;
            int offsetY = this.type == PageChangeType.Previous ? 12 : 0;
            this.method_1788(this.field_2069, this.field_2068, 110 + offsetX, 231 + offsetY, 23, 12);
        }
    }

    private static enum PageChangeType {
        Previous,
        Next;

    }
}

