/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.Optional;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.client.manual.Document;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import li.cil.tis3d.common.api.ManualAPIImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class ManualGui
extends class_437 {
    private static final int DOCUMENT_MAX_WIDTH = 220;
    private static final int DOCUMENT_MAX_HEIGHT = 176;
    private static final int SCROLL_POS_X = 250;
    private static final int SCROLL_POS_Y = 48;
    private static final int SCROLL_WIDTH = 26;
    private static final int SCROLL_HEIGHT = 180;
    private static final int TAB_POS_X = -52;
    private static final int TAB_POS_Y = 40;
    private static final int TAB_WIDTH = 64;
    private static final int TAB_HEIGHT = 32;
    private static final int TAB_OVERLAP = 8;
    private static final int MAX_TABS_PER_SIDE = 7;
    private static final int WINDOW_WIDTH = 256;
    private static final int WINDOW_HEIGHT = 256;
    private int guiLeft = 0;
    private int guiTop = 0;
    private int xSize = 0;
    private int ySize = 0;
    private boolean isDragging = false;
    private Segment document = null;
    private int documentHeight = 0;
    private Optional<InteractiveSegment> currentSegment = Optional.empty();
    private ImageButton scrollButton = null;

    public void pushPage(String path) {
        if (!ManualAPIImpl.peekPath().equals(path)) {
            ManualAPIImpl.pushPath(path);
            this.refreshPage();
        }
    }

    public void method_2224() {
        super.method_2224();
        ScaledResolution screenSize = new ScaledResolution(this.field_2563.field_1704.method_4486(), this.field_2563.field_1704.method_4502());
        ScaledResolution guiSize = new ScaledResolution(256, 256);
        int midX = screenSize.scaledWidth / 2;
        int midY = screenSize.scaledHeight / 2;
        this.guiLeft = midX - guiSize.scaledWidth / 2;
        this.guiTop = midY - guiSize.scaledHeight / 2;
        this.xSize = guiSize.scaledWidth;
        this.ySize = guiSize.scaledHeight;
        for (int i = 0; i < ManualAPIImpl.getTabs().size() && i < 7; ++i) {
            int x = this.guiLeft + -52;
            int y = this.guiTop + 40 + i * 24;
            this.method_2219(new ImageButton(i, x, y, 64, 23, Textures.LOCATION_GUI_MANUAL_TAB){

                public void method_1826(double x, double y) {
                    ManualAPI.navigate(ManualAPIImpl.getTabs().get((int)this.field_2077).path);
                }
            }.setImageHeight(32).setVerticalImageOffset(-4));
        }
        this.scrollButton = new ImageButton(-1, this.guiLeft + 250, this.guiTop + 48, 26, 13, Textures.LOCATION_GUI_MANUAL_SCROLL){

            public boolean method_16807(double x, double y, int button) {
                return false;
            }
        };
        this.method_2219(this.scrollButton);
        this.refreshPage();
    }

    public void method_2214(int mouseX, int mouseY, float partialTicks) {
        ImageButton button;
        ManualAPIImpl.Tab tab;
        int i;
        GlStateManager.enableBlend();
        super.method_2214(mouseX, mouseY, partialTicks);
        this.field_2563.method_1531().method_4618(Textures.LOCATION_GUI_MANUAL_BACKGROUND);
        class_332.method_1781((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (float)256.0f, (float)256.0f);
        this.scrollButton.field_2078 = this.canScroll();
        this.scrollButton.hoverOverride = this.isDragging;
        for (i = 0; i < ManualAPIImpl.getTabs().size() && i < 7; ++i) {
            tab = ManualAPIImpl.getTabs().get(i);
            button = (ImageButton)((Object)this.field_2564.get(i));
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)(button.field_2069 + 30), (float)(button.field_2068 + 4 - 4), (float)((int)this.field_2050));
            tab.renderer.render();
            GlStateManager.popMatrix();
        }
        this.currentSegment = Document.render(this.document, this.guiLeft + 16, this.guiTop + 48, 220, 176, this.offset(), this.getFontRenderer(), mouseX, mouseY);
        if (!this.isDragging) {
            this.currentSegment.ifPresent(s -> s.tooltip().ifPresent(t -> this.method_2211(Collections.singletonList(class_1074.method_4662((String)t, (Object[])new Object[0])), mouseX, mouseY)));
            for (i = 0; i < ManualAPIImpl.getTabs().size() && i < 7; ++i) {
                tab = ManualAPIImpl.getTabs().get(i);
                button = (ImageButton)((Object)this.field_2564.get(i));
                if (mouseX <= button.field_2069 || mouseX >= button.field_2069 + button.method_1825() || mouseY <= button.field_2068 || mouseY >= button.field_2068 + button.getHeight() || tab.tooltip == null) continue;
                this.method_2211(Collections.singletonList(class_1074.method_4662((String)tab.tooltip, (Object[])new Object[0])), mouseX, mouseY);
            }
        }
        if (this.canScroll() && (this.isCoordinateOverScrollBar(mouseX - this.guiLeft, mouseY - this.guiTop) || this.isDragging)) {
            this.method_2211(Collections.singletonList(100 * this.offset() / this.maxOffset() + "%"), this.guiLeft + 250 + 26, this.scrollButton.field_2068 + this.scrollButton.getHeight() + 1);
        }
    }

    public boolean method_16802(double value) {
        if (value != 0.0) {
            this.scroll(-value);
        }
        return true;
    }

    public boolean method_16805(int code, int scancode, int mods) {
        if (this.field_2563.field_1690.field_1903.method_1417(code, scancode)) {
            this.popPage();
            return true;
        }
        if (this.field_2563.field_1690.field_1822.method_1417(code, scancode)) {
            this.field_2563.field_1724.method_7346();
            return true;
        }
        return super.method_16805(code, scancode, mods);
    }

    public boolean method_16807(double mouseXd, double mouseYd, int button) {
        if (super.method_16807(mouseXd, mouseYd, button)) {
            return true;
        }
        int mouseX = (int)Math.round(mouseXd);
        int mouseY = (int)Math.round(mouseYd);
        if (this.canScroll() && button == 0 && this.isCoordinateOverScrollBar(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            this.isDragging = true;
            this.scrollMouse(mouseYd);
            return true;
        }
        if (button == 0) {
            this.currentSegment.ifPresent(s -> s.onMouseClick(mouseX, mouseY));
            return true;
        }
        if (button == 1) {
            this.popPage();
            return true;
        }
        return false;
    }

    public boolean method_16801(double mouseXd, double mouseYd, int clickedMouseButton, double da, double db) {
        if (super.method_16801(mouseXd, mouseYd, clickedMouseButton, da, db)) {
            return true;
        }
        if (this.isDragging) {
            this.scrollMouse(mouseYd);
            return true;
        }
        return false;
    }

    public boolean method_16804(double mouseX, double mouseY, int button) {
        super.method_16804(mouseX, mouseY, button);
        if (button == 0) {
            this.isDragging = false;
        }
        return true;
    }

    public boolean method_2222() {
        return false;
    }

    private class_327 getFontRenderer() {
        return this.field_2554;
    }

    private boolean canScroll() {
        return this.maxOffset() > 0;
    }

    private int offset() {
        return ManualAPIImpl.peekOffset();
    }

    private int maxOffset() {
        return this.documentHeight - 176;
    }

    private void refreshPage() {
        Iterable<String> content = ManualAPI.contentFor(ManualAPIImpl.peekPath());
        this.document = Document.parse(content != null ? content : Collections.singletonList("Document not found: " + ManualAPIImpl.peekPath()));
        this.documentHeight = Document.height(this.document, 220, this.getFontRenderer());
        this.scrollTo(this.offset());
    }

    private void popPage() {
        if (ManualAPIImpl.getHistorySize() > 1) {
            ManualAPIImpl.popPath();
            this.refreshPage();
        } else {
            this.field_2563.field_1724.method_7346();
        }
    }

    private void scrollMouse(double mouseY) {
        this.scrollTo((int)Math.round((mouseY - (double)this.guiTop - 48.0 - 6.5) * (double)this.maxOffset() / 167.0));
    }

    private void scroll(double amount) {
        this.scrollTo(this.offset() + (int)Math.round((double)(Document.lineHeight(this.getFontRenderer()) * 3) * amount));
    }

    private void scrollTo(int row) {
        ManualAPIImpl.setOffset(Math.max(0, Math.min(this.maxOffset(), row)));
        int yMin = this.guiTop + 48;
        this.scrollButton.field_2068 = this.maxOffset() > 0 ? yMin + 167 * this.offset() / this.maxOffset() : yMin;
    }

    private boolean isCoordinateOverScrollBar(int x, int y) {
        return x > 250 && x < 276 && y >= 48 && y < 228;
    }

    private static class ScaledResolution {
        final int scaledWidth;
        final int scaledHeight;

        ScaledResolution(int width, int height) {
            int scaleFactor = 1;
            int guiScale = class_310.method_1551().field_1690.field_1868;
            if (guiScale == 0) {
                guiScale = 1000;
            }
            while (scaleFactor < guiScale && width / (scaleFactor + 1) >= 320 && height / (scaleFactor + 1) >= 240) {
                ++scaleFactor;
            }
            if (class_310.method_1551().method_1573() && scaleFactor % 2 != 0 && scaleFactor != 1) {
                --scaleFactor;
            }
            this.scaledWidth = class_3532.method_15384((double)((double)width / (double)scaleFactor));
            this.scaledHeight = class_3532.method_15384((double)((double)height / (double)scaleFactor));
        }
    }

    private static class ImageButton
    extends class_339 {
        private final class_2960 image;
        private boolean hoverOverride = false;
        private int verticalImageOffset = 0;
        private int imageHeightOverride = 0;

        ImageButton(int id, int x, int y, int w, int h, class_2960 image) {
            super(id, x, y, w, h, "");
            this.image = image;
        }

        ImageButton setImageHeight(int height) {
            this.imageHeightOverride = height;
            return this;
        }

        ImageButton setVerticalImageOffset(int offset) {
            this.verticalImageOffset = offset;
            return this;
        }

        public int method_1825() {
            return this.field_2071;
        }

        public int getHeight() {
            return this.field_2070;
        }

        public void method_1824(int mouseX, int mouseY, float partialTicks) {
            if (this.field_2076) {
                class_310.method_1551().method_1531().method_4618(this.image);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_2075 = mouseX >= this.field_2069 && mouseY >= this.field_2068 && mouseX < this.field_2069 + this.field_2071 && mouseY < this.field_2068 + this.field_2070;
                int x0 = this.field_2069;
                int x1 = this.field_2069 + this.field_2071;
                int y0 = this.field_2068 + this.verticalImageOffset;
                int y1 = this.field_2068 + this.verticalImageOffset + (this.imageHeightOverride > 0 ? this.imageHeightOverride : this.field_2070);
                double u0 = 0.0;
                double u1 = 1.0;
                double v0 = this.hoverOverride || this.method_1828() ? 0.5 : 0.0;
                double v1 = v0 + 0.5;
                class_289 t = class_289.method_1348();
                class_287 b = t.method_1349();
                b.method_1328(7, class_290.field_1585);
                b.method_1315((double)x0, (double)y1, (double)this.field_2050).method_1312(0.0, v1).method_1344();
                b.method_1315((double)x1, (double)y1, (double)this.field_2050).method_1312(1.0, v1).method_1344();
                b.method_1315((double)x1, (double)y0, (double)this.field_2050).method_1312(1.0, v0).method_1344();
                b.method_1315((double)x0, (double)y0, (double)this.field_2050).method_1312(0.0, v0).method_1344();
                t.method_1350();
            }
        }
    }
}

