/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import li.cil.tis3d.api.FontRendererAPI;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.ReadOnlyMemoryModuleDataMessage;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_437;

public final class ReadOnlyMemoryModuleGui
extends class_437 {
    private static final int GUI_WIDTH = 190;
    private static final int GUI_HEIGHT = 130;
    private static final int GRID_LEFT = 25;
    private static final int GRID_TOP = 13;
    private static final int CELL_WIDTH = 10;
    private static final int CELL_HEIGHT = 7;
    private static final String LABEL_INITIALIZING = "INITIALIZING...";
    private final class_1657 player;
    private final class_1268 hand;
    private final byte[] data = new byte[256];
    private int guiX = 0;
    private int guiY = 0;
    private static int selectedCell = 0;
    private boolean highNibble = true;
    private boolean receivedData;
    private long initTime;

    ReadOnlyMemoryModuleGui(class_1657 player, class_1268 hand) {
        this.player = player;
        this.hand = hand;
    }

    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.data, 0, Math.min(data.length, this.data.length));
        this.receivedData = true;
        this.initTime = System.currentTimeMillis();
    }

    public void method_2224() {
        super.method_2224();
        this.guiX = (this.field_2561 - 190) / 2;
        this.guiY = (this.field_2559 - 130) / 2;
        this.field_2563.field_1774.method_1462(true);
    }

    public void method_2234() {
        super.method_2234();
        if (this.receivedData) {
            Network.INSTANCE.sendToServer(new ReadOnlyMemoryModuleDataMessage(this.data, this.hand));
        }
        this.field_2563.field_1774.method_1462(false);
    }

    public void method_2214(int mouseX, int mouseY, float partialTicks) {
        if (!this.player.method_5805() || !Items.isModuleReadOnlyMemory(this.player.method_5998(this.hand))) {
            this.field_2563.method_1507(null);
            return;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_2563.method_1531().method_4618(Textures.LOCATION_GUI_MEMORY);
        this.method_1788(this.guiX, this.guiY, 0, 0, 190, 130);
        this.drawHeaders();
        this.drawInitializing();
        if (!this.receivedData) {
            return;
        }
        this.drawMemory();
        this.drawSelectionBox();
    }

    public boolean method_16807(double mouseXd, double mouseYd, int mouseButton) {
        if (super.method_16807(mouseXd, mouseYd, mouseButton)) {
            return true;
        }
        int mouseX = (int)Math.round(mouseXd);
        int mouseY = (int)Math.round(mouseYd);
        this.selectCellAt(mouseX, mouseY);
        return true;
    }

    public boolean method_16801(double mouseXd, double mouseYd, int clickedMouseButton, double da, double db) {
        if (super.method_16801(mouseXd, mouseYd, clickedMouseButton, da, db)) {
            return true;
        }
        int mouseX = (int)Math.round(mouseXd);
        int mouseY = (int)Math.round(mouseYd);
        this.selectCellAt(mouseX, mouseY);
        return true;
    }

    public boolean method_16805(int keyCode, int scancode, int mods) {
        if (super.method_16805(keyCode, scancode, mods)) {
            return true;
        }
        if (!this.receivedData) {
            return false;
        }
        int digit = Character.digit(keyCode, 16);
        if (digit >= 0) {
            if (this.highNibble) {
                byte value = this.data[selectedCell];
                value = (byte)(value & 0xF);
                this.data[ReadOnlyMemoryModuleGui.selectedCell] = value = (byte)(value | (digit & 0xF) << 4);
            } else {
                byte value = this.data[selectedCell];
                value = (byte)(value & 0xF0);
                this.data[ReadOnlyMemoryModuleGui.selectedCell] = value = (byte)(value | digit & 0xF);
            }
            boolean bl = this.highNibble = !this.highNibble;
            if (this.highNibble) {
                selectedCell = (selectedCell + 1) % this.data.length;
            }
        } else if (keyCode == 261) {
            this.data[ReadOnlyMemoryModuleGui.selectedCell] = 0;
            this.highNibble = true;
        } else if (keyCode == 259) {
            if (this.highNibble) {
                selectedCell = (selectedCell - 1 + this.data.length) % this.data.length;
            }
            this.data[ReadOnlyMemoryModuleGui.selectedCell] = 0;
            this.highNibble = true;
        } else {
            int col = selectedCell & 0xF;
            int row = (selectedCell & 0xF0) >> 4;
            switch (keyCode) {
                case 72: 
                case 263: {
                    if (col == 0) {
                        col = 15;
                        row = (row - 1 + 16) % 16;
                        break;
                    }
                    --col;
                    break;
                }
                case 76: 
                case 262: {
                    if (col == 15) {
                        col = 0;
                        row = (row + 1) % 16;
                        break;
                    }
                    ++col;
                    break;
                }
                case 75: 
                case 265: {
                    row = (row - 1 + 16) % 16;
                    break;
                }
                case 74: 
                case 264: {
                    row = (row + 1) % 16;
                    break;
                }
                default: {
                    return false;
                }
            }
            selectedCell = row << 4 | col;
            this.highNibble = true;
        }
        return true;
    }

    public boolean method_2222() {
        return false;
    }

    private void selectCellAt(int mouseX, int mouseY) {
        if (!this.receivedData) {
            return;
        }
        int col = (mouseX + 1 - this.guiX - 25) / 10;
        int row = (mouseY + 1 - this.guiY - 13) / 7;
        if (this.isInGridArea(col, row)) {
            selectedCell = row << 4 | col;
            this.highNibble = true;
        }
    }

    private boolean isInGridArea(int col, int row) {
        return col >= 0 && row >= 0 && col <= 15 && row <= 15;
    }

    private void drawHeaders() {
        GlStateManager.color4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.guiX + 25 + 3), (float)(this.guiY + 6), (float)0.0f);
        for (int col = 0; col < 16; ++col) {
            FontRendererAPI.drawString(String.format("%X", col));
            GlStateManager.translatef((float)10.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.guiX + 7), (float)(this.guiY + 14), (float)0.0f);
        for (int row = 0; row < 16; ++row) {
            FontRendererAPI.drawString(String.format("0X%X0", row));
            GlStateManager.translatef((float)0.0f, (float)7.0f, (float)0.0f);
        }
        GlStateManager.popMatrix();
    }

    private void drawInitializing() {
        float sinceInitialized = (float)(System.currentTimeMillis() - this.initTime) / 1000.0f;
        if (this.receivedData && sinceInitialized > 0.5f) {
            return;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - sinceInitialized / 0.5f));
        GlStateManager.enableBlend();
        int labelWidth = FontRendererAPI.getCharWidth() * LABEL_INITIALIZING.length();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.guiX + 25 + 3 + 70 - labelWidth / 2), (float)(this.guiY + 13 + 1 + 49), (float)0.0f);
        FontRendererAPI.drawString(LABEL_INITIALIZING);
        GlStateManager.popMatrix();
    }

    private void drawMemory() {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int visibleCells = (int)(System.currentTimeMillis() - this.initTime);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.guiX + 25 + 1), (float)(this.guiY + 13 + 1), (float)0.0f);
        int count = Math.min(visibleCells, this.data.length);
        for (int i = 0; i < count; ++i) {
            FontRendererAPI.drawString(String.format("%02X", this.data[i]));
            int col = i & 0xF;
            if (col < 15) {
                GlStateManager.translatef((float)10.0f, (float)0.0f, (float)0.0f);
                continue;
            }
            GlStateManager.translatef((float)-150.0f, (float)7.0f, (float)0.0f);
        }
        GlStateManager.popMatrix();
    }

    private void drawSelectionBox() {
        int visibleCells = (int)(System.currentTimeMillis() - this.initTime) * 2;
        if (selectedCell > visibleCells) {
            return;
        }
        int col = selectedCell & 0xF;
        int row = (selectedCell & 0xF0) >> 4;
        int x = this.guiX + 25 + 10 * col - 1;
        int y = this.guiY + 13 + 7 * row - 1;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)x, (float)y, (float)0.0f);
        this.field_2563.method_1531().method_4618(Textures.LOCATION_GUI_MEMORY);
        int vPos = (int)(this.field_2563.field_1687.method_8510() % 16L) * 8;
        this.method_1788(0, 0, 245, vPos, 11, 8);
        GlStateManager.popMatrix();
    }
}

