/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.manual;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.api.manual.ImageRenderer;
import li.cil.tis3d.client.manual.segment.BoldSegment;
import li.cil.tis3d.client.manual.segment.CodeSegment;
import li.cil.tis3d.client.manual.segment.HeaderSegment;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.ItalicSegment;
import li.cil.tis3d.client.manual.segment.LinkSegment;
import li.cil.tis3d.client.manual.segment.RenderSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import li.cil.tis3d.client.manual.segment.SegmentRefiner;
import li.cil.tis3d.client.manual.segment.StrikethroughSegment;
import li.cil.tis3d.client.manual.segment.TextSegment;
import net.minecraft.class_310;
import net.minecraft.class_327;
import org.lwjgl.opengl.GL11;

public final class Document {
    private static final PatternMapping[] SEGMENT_TYPES = new PatternMapping[]{new PatternMapping("^(#+)\\s(.*)", Document::HeaderSegment), new PatternMapping("(`)(.*?)\\1", Document::CodeSegment), new PatternMapping("!\\[([^\\[]*)\\]\\(([^\\)]+)\\)", Document::ImageSegment), new PatternMapping("\\[([^\\[]+)\\]\\(([^\\)]+)\\)", Document::LinkSegment), new PatternMapping("(\\*\\*|__)(\\S.*?\\S|$)\\1", Document::BoldSegment), new PatternMapping("(\\*|_)(\\S.*?\\S|$)\\1", Document::ItalicSegment), new PatternMapping("~~(\\S.*?\\S|$)~~", Document::StrikethroughSegment)};

    /*
     * WARNING - void declaration
     */
    public static Segment parse(Iterable<String> document) {
        void var3_6;
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        for (String string : document) {
            segments.add(new TextSegment(null, Document.trimRight(string)));
        }
        ArrayList workSegments = new ArrayList();
        for (PatternMapping type : SEGMENT_TYPES) {
            for (Segment segment : segments) {
                segment.refine(type.pattern, type.refiner).forEach(workSegments::add);
            }
            ArrayList<TextSegment> tmp = segments;
            segments = workSegments;
            workSegments = tmp;
            workSegments.clear();
        }
        boolean bl = false;
        while (var3_6 < segments.size() - 1) {
            ((Segment)segments.get((int)var3_6)).setNext((Segment)segments.get((int)(var3_6 + true)));
            ++var3_6;
        }
        return segments.size() > 0 ? (Segment)segments.get(0) : new TextSegment(null, "");
    }

    public static int height(Segment document, int maxWidth, class_327 renderer) {
        int currentX = 0;
        int currentY = 0;
        for (Segment segment = document; segment != null; segment = segment.next()) {
            currentY += segment.nextY(currentX, maxWidth, renderer);
            currentX = segment.nextX(currentX, maxWidth, renderer);
        }
        return currentY;
    }

    public static int lineHeight(class_327 renderer) {
        renderer.getClass();
        return 9 + 1;
    }

    public static Optional<InteractiveSegment> render(Segment document, int x, int y, int maxWidth, int maxHeight, int yOffset, class_327 renderer, int mouseX, int mouseY) {
        class_310 mc = class_310.method_1551();
        GlStateManager.pushLightingAttributes();
        GlStateManager.disableAlphaTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.clear((int)256, (boolean)false);
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)500.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)0.0f, (float)y);
        GL11.glVertex2f((float)mc.field_1704.method_4489(), (float)y);
        GL11.glVertex2f((float)mc.field_1704.method_4489(), (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)mc.field_1704.method_4506());
        GL11.glVertex2f((float)mc.field_1704.method_4489(), (float)mc.field_1704.method_4506());
        GL11.glVertex2f((float)mc.field_1704.method_4489(), (float)(y + maxHeight));
        GL11.glVertex2f((float)0.0f, (float)(y + maxHeight));
        GL11.glEnd();
        GlStateManager.popMatrix();
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Optional<InteractiveSegment> hovered = Optional.empty();
        int indent = 0;
        int currentY = y - yOffset;
        int minY = y - Document.lineHeight(renderer);
        int maxY = y + maxHeight + Document.lineHeight(renderer);
        for (Segment segment = document; segment != null; segment = segment.next()) {
            int segmentHeight = segment.nextY(indent, maxWidth, renderer);
            if (currentY + segmentHeight >= minY && currentY <= maxY) {
                Optional<InteractiveSegment> result = segment.render(x, currentY, indent, maxWidth, renderer, mouseX, mouseY);
                if (!hovered.isPresent()) {
                    hovered = result;
                }
            }
            currentY += segmentHeight;
            indent = segment.nextX(indent, maxWidth, renderer);
        }
        if (mouseX < x || mouseX > x + maxWidth || mouseY < y || mouseY > y + maxHeight) {
            hovered = Optional.empty();
        }
        hovered.ifPresent(InteractiveSegment::notifyHover);
        GlStateManager.popAttributes();
        GlStateManager.bindTexture((int)0);
        return hovered;
    }

    private static String trimRight(String s) {
        for (int i = s.length(); i > 0; --i) {
            if (Character.isWhitespace(s.charAt(i - 1))) continue;
            return s.substring(0, i);
        }
        return s;
    }

    private static Segment HeaderSegment(Segment s, Matcher m) {
        return new HeaderSegment(s, m.group(2), m.group(1).length());
    }

    private static Segment CodeSegment(Segment s, Matcher m) {
        return new CodeSegment(s, m.group(2));
    }

    private static Segment LinkSegment(Segment s, Matcher m) {
        return new LinkSegment(s, m.group(1), m.group(2));
    }

    private static Segment BoldSegment(Segment s, Matcher m) {
        return new BoldSegment(s, m.group(2));
    }

    private static Segment ItalicSegment(Segment s, Matcher m) {
        return new ItalicSegment(s, m.group(2));
    }

    private static Segment StrikethroughSegment(Segment s, Matcher m) {
        return new StrikethroughSegment(s, m.group(1));
    }

    private static Segment ImageSegment(Segment s, Matcher m) {
        try {
            ImageRenderer renderer = ManualAPI.imageFor(m.group(2));
            if (renderer != null) {
                return new RenderSegment(s, m.group(1), renderer);
            }
            return new TextSegment(s, "No renderer found for: " + m.group(2));
        }
        catch (Throwable t) {
            return new TextSegment(s, Strings.isNullOrEmpty((String)t.toString()) ? "Unknown error." : t.toString());
        }
    }

    private Document() {
    }

    private static final class PatternMapping {
        final Pattern pattern;
        final SegmentRefiner refiner;

        PatternMapping(String pattern, SegmentRefiner refiner) {
            this.pattern = Pattern.compile(pattern);
            this.refiner = refiner;
        }
    }
}

