/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.manual.segment;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Optional;
import li.cil.tis3d.api.manual.ImageRenderer;
import li.cil.tis3d.api.manual.InteractiveImageRenderer;
import li.cil.tis3d.client.manual.Document;
import li.cil.tis3d.client.manual.segment.AbstractSegment;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import org.lwjgl.opengl.GL11;

public final class RenderSegment
extends AbstractSegment
implements InteractiveSegment {
    private final Segment parent;
    private final String title;
    private final ImageRenderer imageRenderer;
    private int lastX = 0;
    private int lastY = 0;

    public RenderSegment(Segment parent, String title, ImageRenderer imageRenderer) {
        this.parent = parent;
        this.title = title;
        this.imageRenderer = imageRenderer;
    }

    @Override
    public Segment parent() {
        return this.parent;
    }

    @Override
    public Optional<String> tooltip() {
        if (this.imageRenderer instanceof InteractiveImageRenderer) {
            return Optional.of(((InteractiveImageRenderer)this.imageRenderer).getTooltip(this.title));
        }
        return Optional.of(this.title);
    }

    @Override
    public boolean onMouseClick(int mouseX, int mouseY) {
        return this.imageRenderer instanceof InteractiveImageRenderer && ((InteractiveImageRenderer)this.imageRenderer).onMouseClick(mouseX - this.lastX, mouseY - this.lastY);
    }

    @Override
    public void notifyHover() {
    }

    @Override
    public int nextY(int indent, int maxWidth, class_327 renderer) {
        return this.imageHeight(maxWidth) + (indent > 0 ? Document.lineHeight(renderer) : 0);
    }

    @Override
    public int nextX(int indent, int maxWidth, class_327 renderer) {
        return 0;
    }

    @Override
    public Optional<InteractiveSegment> render(int x, int y, int indent, int maxWidth, class_327 renderer, int mouseX, int mouseY) {
        int width = this.imageWidth(maxWidth);
        int height = this.imageHeight(maxWidth);
        int xOffset = (maxWidth - width) / 2;
        int yOffset = 2 + (indent > 0 ? Document.lineHeight(renderer) : 0);
        float s = this.scale(maxWidth);
        this.lastX = x + xOffset;
        this.lastY = y + yOffset;
        Optional<InteractiveSegment> hovered = this.checkHovered(mouseX, mouseY, x + xOffset, y + yOffset, width, height);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(x + xOffset), (float)(y + yOffset), (float)0.0f);
        GlStateManager.scalef((float)s, (float)s, (float)s);
        GlStateManager.enableBlend();
        GlStateManager.enableAlphaTest();
        if (hovered.isPresent()) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            GlStateManager.disableTexture();
            GL11.glBegin((int)7);
            GL11.glVertex2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)0.0f, (float)this.imageRenderer.getHeight());
            GL11.glVertex2f((float)this.imageRenderer.getWidth(), (float)this.imageRenderer.getHeight());
            GL11.glVertex2f((float)this.imageRenderer.getWidth(), (float)0.0f);
            GL11.glEnd();
            GlStateManager.enableTexture();
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.imageRenderer.render(mouseX - x, mouseY - y);
        GlStateManager.popMatrix();
        return hovered;
    }

    public String toString() {
        return String.format("![%s](%s)", this.title, this.imageRenderer);
    }

    private float scale(int maxWidth) {
        return Math.min(1.0f, (float)maxWidth / (float)this.imageRenderer.getWidth());
    }

    private int imageWidth(int maxWidth) {
        return Math.min(maxWidth, this.imageRenderer.getWidth());
    }

    private int imageHeight(int maxWidth) {
        return class_3532.method_15386((float)((float)this.imageRenderer.getHeight() * this.scale(maxWidth))) + 4;
    }
}

