/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.render.block.entity;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.init.Items;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_827;

public final class CasingBlockEntityRenderer
extends class_827<CasingBlockEntity> {
    private static final Set<Class<?>> BLACKLIST = new HashSet();

    public void render(CasingBlockEntity casing, double x, double y, double z, float partialTicks, int destroyStage) {
        double dx = x + 0.5;
        double dy = y + 0.5;
        double dz = z + 0.5;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)dx, (double)dy, (double)dz);
        class_308.method_1450();
        for (Face face : Face.VALUES) {
            if (this.isRenderingBackFace(face, dx, dy, dz)) continue;
            GlStateManager.pushMatrix();
            GlStateManager.pushLightingAttributes();
            this.setupMatrix(face);
            this.ensureSanity();
            class_310.method_1551().method_1549().method_4626(false, false);
            if (!this.isObserverHoldingKey() || !this.drawConfigOverlay(casing, face)) {
                this.drawModuleOverlay(casing, face, partialTicks);
            }
            class_310.method_1551().method_1549().method_4627();
            GlStateManager.popAttributes();
            GlStateManager.popMatrix();
        }
        class_308.method_1452();
        GlStateManager.popMatrix();
    }

    private boolean isRenderingBackFace(Face face, double dx, double dy, double dz) {
        class_2350 facing = Face.toDirection(face.getOpposite());
        double dotProduct = (double)facing.method_10148() * dx + (double)facing.method_10164() * (dy - (double)this.field_4367.field_4344.method_5751()) + (double)facing.method_10165() * dz;
        return dotProduct < 0.0;
    }

    private void setupMatrix(Face face) {
        switch (face) {
            case Y_NEG: {
                GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Y_POS: {
                GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Z_NEG: {
                GlStateManager.rotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case Z_POS: {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case X_NEG: {
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case X_POS: {
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.translated((double)0.5, (double)0.5, (double)-0.505);
        GlStateManager.scaled((double)-1.0, (double)-1.0, (double)1.0);
    }

    private void ensureSanity() {
        GlStateManager.enableTexture();
        RenderUtil.bindTexture(class_1059.field_5275);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.blendFunc((int)770, (int)771);
        RenderUtil.ignoreLighting();
    }

    private boolean drawConfigOverlay(CasingBlockEntity casing, Face face) {
        if (!this.isObserverKindaClose(casing)) {
            return false;
        }
        if (this.isObserverSneaking() && !casing.isLocked()) {
            Port lookingAtPort;
            class_1058 openSprite;
            class_1058 closedSprite;
            boolean isLookingAt = this.isObserverLookingAt(casing.method_11016(), face);
            if (isLookingAt) {
                closedSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED);
                openSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_OPEN);
                class_239 hitResult = this.field_4367.field_4350;
                assert (hitResult.method_17783() == class_239.class_240.field_1332) : "renderManager.hitResult.getBlockPos().getType() is not of type BLOCK even though it was in isObserverLookingAt";
                assert (hitResult instanceof class_3965) : "renderManager.hitResult.getBlockPos() is not a BlockHitResult even though it was in isObserverLookingAt";
                class_3965 blockHitResult = (class_3965)hitResult;
                class_2338 pos = blockHitResult.method_17777();
                assert (pos != null) : "renderManager.hitResult.getBlockPos() is null even though it was non-null in isObserverLookingAt";
                class_243 uv = TransformUtil.hitToUV(face, hitResult.method_17784().method_1020(new class_243((class_2382)pos)));
                lookingAtPort = Port.fromUVQuadrant(uv);
            } else {
                closedSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
                openSprite = null;
                lookingAtPort = null;
            }
            GlStateManager.pushMatrix();
            for (Port port : Port.CLOCKWISE) {
                class_1058 sprite;
                boolean isClosed = casing.isReceivingPipeLocked(face, port);
                class_1058 class_10582 = sprite = isClosed ? closedSprite : openSprite;
                if (sprite != null) {
                    RenderUtil.drawQuad(sprite);
                }
                if (port == lookingAtPort) {
                    RenderUtil.drawQuad(RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_HIGHLIGHT));
                }
                GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            GlStateManager.popMatrix();
            return isLookingAt;
        }
        class_1058 sprite = casing.isLocked() ? RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_LOCKED) : RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_UNLOCKED);
        RenderUtil.drawQuad(sprite);
        return true;
    }

    private void drawModuleOverlay(CasingBlockEntity casing, Face face, float partialTicks) {
        class_1058 closedSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.0, (double)-0.005);
        for (Port port : Port.CLOCKWISE) {
            boolean isClosed = casing.isReceivingPipeLocked(face, port);
            if (isClosed) {
                RenderUtil.drawQuad(closedSprite);
            }
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        GlStateManager.popMatrix();
        Module module = casing.getModule(face);
        if (module == null) {
            return;
        }
        if (BLACKLIST.contains(module.getClass())) {
            return;
        }
        int brightness = this.method_3565().method_8313(casing.getPosition().method_10093(Face.toDirection(face)), 0);
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)(brightness % 65536), (float)(brightness / 65536));
        try {
            module.render(this.field_4367, partialTicks);
        }
        catch (Exception e) {
            BLACKLIST.add(module.getClass());
            TIS3D.getLog().error("A module threw an exception while rendering, won't render again!", (Throwable)e);
        }
    }

    private boolean isObserverKindaClose(CasingBlockEntity casing) {
        return this.field_4367.field_4344.method_5677(casing.method_11016()) < 256.0;
    }

    private boolean isObserverHoldingKey() {
        for (class_1799 stack : this.field_4367.field_4344.method_5743()) {
            if (!Items.isKey(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isObserverSneaking() {
        return this.field_4367.field_4344.method_5715();
    }

    private boolean isObserverLookingAt(class_2338 pos, Face face) {
        class_239 hitResult = this.field_4367.field_4350;
        if (hitResult == null) {
            return false;
        }
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return false;
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        if (blockHitResult.method_17780() == null) {
            return false;
        }
        if (Face.fromDirection(blockHitResult.method_17780()) != face) {
            return false;
        }
        if (blockHitResult.method_17777() == null) {
            return false;
        }
        return Objects.equals(blockHitResult.method_17777(), pos);
    }
}

