/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.render.font;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import li.cil.tis3d.client.render.font.FontRenderer;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public abstract class AbstractFontRenderer
implements FontRenderer {
    private final Int2IntMap CHAR_MAP;
    private final int COLUMNS = this.getResolution() / (this.getCharWidth() + this.getGapU());
    private final float U_SIZE = (float)this.getCharWidth() / (float)this.getResolution();
    private final float V_SIZE = (float)this.getCharHeight() / (float)this.getResolution();
    private final float U_STEP = (float)(this.getCharWidth() + this.getGapU()) / (float)this.getResolution();
    private final float V_STEP = (float)(this.getCharHeight() + this.getGapV()) / (float)this.getResolution();

    AbstractFontRenderer() {
        this.CHAR_MAP = new Int2IntOpenHashMap();
        CharSequence chars = this.getCharacters();
        for (int index = 0; index < chars.length(); ++index) {
            this.CHAR_MAP.put((int)chars.charAt(index), index);
        }
    }

    @Override
    public void drawString(CharSequence value) {
        this.drawString(value, value.length());
    }

    @Override
    public void drawString(CharSequence value, int maxChars) {
        GlStateManager.pushMatrix();
        GlStateManager.depthMask((boolean)false);
        class_310.method_1551().method_1531().method_4618(this.getTextureLocation());
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1585);
        float tx = 0.0f;
        int end = Math.min(maxChars, value.length());
        for (int i = 0; i < end; ++i) {
            char ch = value.charAt(i);
            this.drawChar(tx, ch, buffer);
            tx += (float)(this.getCharWidth() + this.getGapU());
        }
        tessellator.method_1350();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
    }

    protected abstract CharSequence getCharacters();

    protected abstract class_2960 getTextureLocation();

    protected abstract int getResolution();

    protected abstract int getGapU();

    protected abstract int getGapV();

    private void drawChar(float x, char ch, class_287 buffer) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return;
        }
        int index = this.getCharIndex(ch);
        int column = index % this.COLUMNS;
        int row = index / this.COLUMNS;
        float u = (float)column * this.U_STEP;
        float v = (float)row * this.V_STEP;
        buffer.method_1315((double)x, (double)this.getCharHeight(), 0.0).method_1312((double)u, (double)(v + this.V_SIZE)).method_1344();
        buffer.method_1315((double)(x + (float)this.getCharWidth()), (double)this.getCharHeight(), 0.0).method_1312((double)(u + this.U_SIZE), (double)(v + this.V_SIZE)).method_1344();
        buffer.method_1315((double)(x + (float)this.getCharWidth()), 0.0, 0.0).method_1312((double)(u + this.U_SIZE), (double)v).method_1344();
        buffer.method_1315((double)x, 0.0, 0.0).method_1312((double)u, (double)v).method_1344();
    }

    private int getCharIndex(char ch) {
        if (!this.CHAR_MAP.containsKey((int)ch)) {
            return this.CHAR_MAP.get(63);
        }
        return this.CHAR_MAP.get((int)ch);
    }
}

