/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common;

import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.util.SimpleConfig;
import net.minecraft.class_2960;

public final class Settings {
    public static int maxPacketsPerTick = 10;
    public static int maxParticlesPerTick = 5;
    public static int maxCasingsPerController = 8;
    public static int maxLinesPerProgram = 40;
    public static int maxColumnsPerLine = 18;
    public static int maxInfraredQueueLength = 16;
    public static boolean animateTypingHand = true;
    public static final Set<class_2960> disabledModules = new HashSet<class_2960>();
    private static final String NAME_ANIMATE_TYPING = "module.terminal.animate_typing";
    private static final String NAME_MAX_PACKETS_PER_TICK = "network.max_packets_per_tick";
    private static final String NAME_MAX_PARTICLES_PER_TICK = "network.max_particles_per_tick";
    private static final String NAME_MAX_CASINGS_PER_CONTROLLER = "controller.max_casings";
    private static final String NAME_MAX_LINES_PER_PROGRAM = "module.execution.max_lines_per_program";
    private static final String NAME_MAX_COLUMNS_PER_LINE = "module.execution.max_columns_per_line";
    private static final String NAME_MAX_QUEUE_LENGTH = "module.infrared.max_queue_length";
    private static final String NAME_MODULE_ENABLED_PATTERN = "module.%s.enabled";
    private static final String COMMENT_ANIMATE_TYPING = "Whether to swing the player's arm while typing on a terminal module.";
    private static final String COMMENT_MAX_PACKETS_PER_TICK = "The maximum number of status packets modules may send per tick. When this is exceeded, throttling kicks in.";
    private static final String COMMENT_MAX_PARTICLES_PER_TICK = "The maximum number of particle effects data transfer may trigger per tick. When this is exceeded, throttling kicks in.";
    private static final String COMMENT_MAX_CASINGS_PER_CONTROLLER = "The maximum number of casings a single controller supports.";
    private static final String COMMENT_MAX_LINES_PER_PROGRAM = "The maximum number of lines an ASM program for an execution node may have.";
    private static final String COMMENT_MAX_COLUMNS_PER_LINE = "The maximum number of columns per line of an ASM program for an execution node may have.";
    private static final String COMMENT_MAX_QUEUE_LENGTH = "The maximum number of infrared packets that can be stored in the receiver's buffer.";
    private static final String COMMENT_MODULE_ENABLED_PATTERN = "Whether the %s module is enabled. Disabled modules are not registered, meaning if you disable them later on the items will disappear!";

    public static void load(File configFile) {
        SimpleConfig config = SimpleConfig.create(configFile);
        maxPacketsPerTick = config.getInt(NAME_MAX_PACKETS_PER_TICK, maxPacketsPerTick, 1, 500, COMMENT_MAX_PACKETS_PER_TICK);
        maxParticlesPerTick = config.getInt(NAME_MAX_PARTICLES_PER_TICK, maxParticlesPerTick, 1, 500, COMMENT_MAX_PARTICLES_PER_TICK);
        maxCasingsPerController = config.getInt(NAME_MAX_CASINGS_PER_CONTROLLER, maxCasingsPerController, 1, 512, COMMENT_MAX_CASINGS_PER_CONTROLLER);
        maxLinesPerProgram = config.getInt(NAME_MAX_LINES_PER_PROGRAM, maxLinesPerProgram, 1, 200, COMMENT_MAX_LINES_PER_PROGRAM);
        maxColumnsPerLine = config.getInt(NAME_MAX_COLUMNS_PER_LINE, maxColumnsPerLine, 1, 80, COMMENT_MAX_COLUMNS_PER_LINE);
        maxInfraredQueueLength = config.getInt(NAME_MAX_QUEUE_LENGTH, maxInfraredQueueLength, 1, 64, COMMENT_MAX_QUEUE_LENGTH);
        animateTypingHand = config.getBoolean(NAME_ANIMATE_TYPING, animateTypingHand, COMMENT_ANIMATE_TYPING);
        disabledModules.clear();
        int prefixLength = "module_*".length();
        for (class_2960 module : Constants.MODULES) {
            String path = module.method_12832();
            if (!path.startsWith("module_")) {
                TIS3D.getLog().warn("Module name with bad format, [{}], should start with [module_].", (Object)path);
                continue;
            }
            String name = String.valueOf(path.charAt(prefixLength - 1)).toLowerCase(Locale.ROOT) + path.substring(prefixLength);
            if (config.getBoolean(String.format(NAME_MODULE_ENABLED_PATTERN, name), true, String.format(COMMENT_MODULE_ENABLED_PATTERN, name))) continue;
            disabledModules.add(module);
        }
        config.save(configFile);
    }

    private Settings() {
    }
}

