/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.api;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import li.cil.tis3d.api.detail.ManualAPI;
import li.cil.tis3d.api.manual.ContentProvider;
import li.cil.tis3d.api.manual.ImageProvider;
import li.cil.tis3d.api.manual.ImageRenderer;
import li.cil.tis3d.api.manual.PathProvider;
import li.cil.tis3d.api.manual.TabIconRenderer;
import li.cil.tis3d.client.gui.GuiHelper;
import li.cil.tis3d.client.gui.ManualGui;
import li.cil.tis3d.common.TIS3D;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_437;

public final class ManualAPIImpl
implements ManualAPI {
    private static final String LANGUAGE_KEY = "%LANGUAGE%";
    private static final String FALLBACK_LANGUAGE = "en_US";
    private static final Pattern PATTERN_LANGUAGE_KEY = Pattern.compile("%LANGUAGE%");
    private static final String MESSAGE_CONTENT_LOOKUP_EXCEPTION = "A content provider threw an error when queried.";
    private static final String MESSAGE_IMAGE_PROVIDER_EXCEPTION = "An image provider threw an error when queried.";
    private static final String MESSAGE_PATH_PROVIDER_ITEM_EXCEPTION = "A path provider threw an error when queried with an item.";
    private static final String MESSAGE_PATH_PROVIDER_BLOCK_EXCEPTION = "A path provider threw an error when queried with a block.";
    public static final ManualAPIImpl INSTANCE = new ManualAPIImpl();
    private final Stack<History> history = new Stack();
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final List<PathProvider> pathProviders = new ArrayList<PathProvider>();
    private final List<ContentProvider> contentProviders = new ArrayList<ContentProvider>();
    private final List<PrefixedImageProvider> imageProviders = new ArrayList<PrefixedImageProvider>();

    public static int getHistorySize() {
        return ManualAPIImpl.INSTANCE.history.size();
    }

    public static void pushPath(String path) {
        ManualAPIImpl.INSTANCE.history.push(new History(path));
    }

    public static String peekPath() {
        return ManualAPIImpl.INSTANCE.history.peek().path;
    }

    public static int peekOffset() {
        return ManualAPIImpl.INSTANCE.history.peek().offset;
    }

    public static void setOffset(int offset) {
        ManualAPIImpl.INSTANCE.history.peek().offset = offset;
    }

    public static void popPath() {
        ManualAPIImpl.INSTANCE.history.pop();
    }

    public static List<Tab> getTabs() {
        return ManualAPIImpl.INSTANCE.tabs;
    }

    private ManualAPIImpl() {
        this.reset();
    }

    @Override
    public void addTab(TabIconRenderer renderer, @Nullable String tooltip, String path) {
        this.tabs.add(new Tab(renderer, tooltip, path));
        if (this.tabs.size() > 7) {
            TIS3D.getLog().warn("Gosh I'm popular! Too many tabs were added to the in-game manual, so some won't be shown. In case this actually happens, let me know and I'll look into making them scrollable or something...");
        }
    }

    @Override
    public void addProvider(PathProvider provider) {
        if (!this.pathProviders.contains(provider)) {
            this.pathProviders.add(provider);
        }
    }

    @Override
    public void addProvider(ContentProvider provider) {
        if (!this.contentProviders.contains(provider)) {
            this.contentProviders.add(provider);
        }
    }

    @Override
    public void addProvider(String prefix, ImageProvider provider) {
        String actualPrefix = Strings.isNullOrEmpty((String)prefix) ? "" : prefix + ":";
        for (PrefixedImageProvider entry : this.imageProviders) {
            if (!entry.prefix.equals(actualPrefix) || entry.provider != provider) continue;
            return;
        }
        this.imageProviders.add(new PrefixedImageProvider(actualPrefix, provider));
    }

    @Override
    @Nullable
    public String pathFor(class_1799 stack) {
        return this.pathFor((PathProvider p) -> p.pathFor(stack), MESSAGE_PATH_PROVIDER_ITEM_EXCEPTION);
    }

    @Override
    @Nullable
    public String pathFor(class_1937 world, class_2338 pos) {
        return this.pathFor((PathProvider p) -> p.pathFor(world, pos), MESSAGE_PATH_PROVIDER_BLOCK_EXCEPTION);
    }

    @Override
    @Nullable
    public Iterable<String> contentFor(String path) {
        String cleanPath = Files.simplifyPath((String)path);
        String language = class_310.method_1551().method_1526().method_4669().getCode();
        Optional<Iterable<String>> result = this.contentForWithRedirects(PATTERN_LANGUAGE_KEY.matcher(cleanPath).replaceAll(language));
        if (result.isPresent()) {
            return result.get();
        }
        return this.contentForWithRedirects(PATTERN_LANGUAGE_KEY.matcher(cleanPath).replaceAll(FALLBACK_LANGUAGE)).orElse(null);
    }

    @Override
    @Nullable
    public ImageRenderer imageFor(String href) {
        for (int i = this.imageProviders.size() - 1; i >= 0; --i) {
            PrefixedImageProvider entry = this.imageProviders.get(i);
            if (!href.startsWith(entry.prefix)) continue;
            try {
                ImageRenderer image = entry.provider.getImage(href.substring(entry.prefix.length()));
                if (image == null) continue;
                return image;
            }
            catch (Throwable t) {
                TIS3D.getLog().warn(MESSAGE_IMAGE_PROVIDER_EXCEPTION, t);
            }
        }
        return null;
    }

    @Override
    public void openFor(class_1657 player) {
        if (player.method_5770().field_9236) {
            GuiHelper.openManualGui();
        }
    }

    @Override
    public void reset() {
        this.history.clear();
        this.history.push(new History(String.format("%s/index.md", LANGUAGE_KEY)));
    }

    @Override
    public void navigate(String path) {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_437 screen = mc.field_1755;
        if (screen instanceof ManualGui) {
            ((ManualGui)screen).pushPage(path);
        } else {
            this.history.push(new History(path));
        }
    }

    public static String makeRelative(String path, String base) {
        if (path.startsWith("/")) {
            return path;
        }
        int lastSlash = base.lastIndexOf(47);
        if (lastSlash >= 0) {
            return base.substring(0, lastSlash + 1) + path;
        }
        return path;
    }

    @Nullable
    private String pathFor(ProviderQuery query, String warning) {
        for (PathProvider provider : this.pathProviders) {
            try {
                String path = query.pathFor(provider);
                if (path == null) continue;
                return path;
            }
            catch (Throwable t) {
                TIS3D.getLog().warn(warning, t);
            }
        }
        return null;
    }

    private Optional<Iterable<String>> contentForWithRedirects(String path) {
        return this.contentForWithRedirects(path, new ArrayList<String>());
    }

    private Optional<Iterable<String>> contentForWithRedirects(String path, List<String> seen) {
        String line;
        Iterable<String> lines;
        Iterator<String> iterator;
        if (seen.contains(path)) {
            ArrayList<String> message = new ArrayList<String>();
            message.add("Redirection loop: ");
            message.addAll(seen);
            message.add(path);
            return Optional.of(message);
        }
        Optional<Iterable<String>> content = this.doContentLookup(path);
        if (content.isPresent() && (iterator = (lines = content.get()).iterator()).hasNext() && (line = iterator.next()).toLowerCase(Locale.US).startsWith("#redirect ")) {
            ArrayList<String> newSeen = new ArrayList<String>(seen);
            newSeen.add(path);
            return this.contentForWithRedirects(ManualAPIImpl.makeRelative(line.substring("#redirect ".length()), path), newSeen);
        }
        return content;
    }

    private Optional<Iterable<String>> doContentLookup(String path) {
        for (ContentProvider provider : this.contentProviders) {
            try {
                Iterable<String> lines = provider.getContent(path);
                if (lines == null) continue;
                return Optional.of(lines);
            }
            catch (Throwable t) {
                TIS3D.getLog().warn(MESSAGE_CONTENT_LOOKUP_EXCEPTION, t);
            }
        }
        return Optional.empty();
    }

    @FunctionalInterface
    private static interface ProviderQuery {
        @Nullable
        public String pathFor(PathProvider var1);
    }

    private static final class PrefixedImageProvider {
        public final String prefix;
        public final ImageProvider provider;

        private PrefixedImageProvider(String prefix, ImageProvider provider) {
            this.prefix = prefix;
            this.provider = provider;
        }
    }

    public static final class Tab {
        public final TabIconRenderer renderer;
        public final String tooltip;
        public final String path;

        private Tab(TabIconRenderer renderer, @Nullable String tooltip, String path) {
            this.renderer = renderer;
            this.tooltip = tooltip;
            this.path = path;
        }
    }

    public static final class History {
        public final String path;
        public int offset = 0;

        private History(String path) {
            this.path = path;
        }
    }
}

