/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block.entity;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.block.entity.AbstractComputerBlockEntity;
import li.cil.tis3d.common.block.entity.ControllerBlockEntity;
import li.cil.tis3d.common.integration.redstone.RedstoneIntegration;
import li.cil.tis3d.common.inventory.CasingInventory;
import li.cil.tis3d.common.inventory.SidedInventoryProxy;
import li.cil.tis3d.common.machine.CasingImpl;
import li.cil.tis3d.common.machine.CasingProxy;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.CasingEnabledStateMessage;
import li.cil.tis3d.common.network.message.CasingLockedStateMessage;
import li.cil.tis3d.common.network.message.PipeLockedStateMessage;
import li.cil.tis3d.util.InventoryUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public final class CasingBlockEntity
extends AbstractComputerBlockEntity
implements SidedInventoryProxy,
CasingProxy {
    public static class_2591<CasingBlockEntity> TYPE;
    private final CasingInventory inventory = new CasingInventory(this);
    private final CasingImpl casing = new CasingImpl(this);
    private final boolean[][] locked = new boolean[6][4];
    private static final String TAG_CASING = "casing";
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_INVENTORY = "inventory";
    private static final String TAG_LOCKED = "closed";
    private ControllerBlockEntity controller;
    private boolean isEnabled;
    private boolean redstoneDirty = true;

    public CasingBlockEntity() {
        super(TYPE);
    }

    public boolean isCasingEnabled() {
        return this.isEnabled;
    }

    public void markRedstoneDirty() {
        this.redstoneDirty = true;
    }

    public void setReceivingPipeLocked(Face face, Port port, boolean value) {
        if (this.isReceivingPipeLocked(face, port) != value) {
            this.getReceivingPipe(face, port).cancelRead();
            this.locked[face.ordinal()][port.ordinal()] = value;
            this.sendReceivingPipeLockedState(face, port);
        }
    }

    public boolean isReceivingPipeLocked(Face face, Port port) {
        return this.locked[face.ordinal()][port.ordinal()];
    }

    public void setInventorySlotContents(int index, class_1799 stack, Port facing) {
        this.inventory.setInventorySlotContents(index, stack, facing);
    }

    @Nullable
    public ControllerBlockEntity getController() {
        return this.controller;
    }

    public void setController(@Nullable ControllerBlockEntity controller) {
        this.controller = controller;
    }

    @Override
    public void scheduleScan() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        if (world.field_9236) {
            return;
        }
        if (this.getController() != null) {
            this.getController().scheduleScan();
        } else {
            ControllerBlockEntity controller = this.findController();
            if (controller != null) {
                controller.scheduleScan();
            }
        }
    }

    public void setModule(Face face, @Nullable Module module) {
        this.casing.setModule(face, module);
    }

    public void lock(class_1799 stack) {
        this.casing.lock(stack);
        this.sendCasingLockedState();
    }

    public void unlock(class_1799 stack) {
        if (this.casing.unlock(stack)) {
            this.sendCasingLockedState();
        }
    }

    public void notifyModulesOfBlockChange(class_2338 neighborPos) {
        for (Face face : Face.VALUES) {
            Module module = this.getModule(face);
            if (!(module instanceof BlockChangeAware)) continue;
            class_2338 moduleNeighborPos = this.getPosition().method_10093(Face.toDirection(face));
            boolean isModuleNeighbor = Objects.equals(neighborPos, moduleNeighborPos);
            ((BlockChangeAware)module).onNeighborBlockChange(neighborPos, isModuleNeighbor);
        }
    }

    void onEnabled() {
        if (this.isEnabled) {
            return;
        }
        this.isEnabled = true;
        this.sendState();
        this.casing.onEnabled();
    }

    void onDisabled() {
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        this.sendState();
        this.casing.onDisabled();
    }

    void stepRedstone() {
        if (!this.redstoneDirty) {
            return;
        }
        this.redstoneDirty = false;
        for (Face face : Face.VALUES) {
            Module module = this.getCasing().getModule(face);
            if (module instanceof Redstone) {
                Redstone redstone = (Redstone)module;
                short signal = (short)RedstoneIntegration.INSTANCE.getRedstoneInput(redstone);
                redstone.setRedstoneInput(signal);
            }
            if (!(module instanceof BundledRedstone)) continue;
            BundledRedstone bundledRedstone = (BundledRedstone)module;
            for (int channel = 0; channel < 16; ++channel) {
                short signal = (short)RedstoneIntegration.INSTANCE.getBundledRedstoneInput(bundledRedstone, channel);
                bundledRedstone.setBundledRedstoneInput(channel, signal);
            }
        }
    }

    void stepModules() {
        this.casing.stepModules();
    }

    @Override
    protected void setNeighbor(Face face, @Nullable AbstractComputerBlockEntity neighbor) {
        super.setNeighbor(face, neighbor);
        class_1937 world = Objects.requireNonNull(this.method_10997());
        if (this.hasNeighbor(face)) {
            InventoryUtils.drop(world, this.method_11016(), this, face.ordinal(), this.method_5444(), Face.toDirection(face));
        }
        if (neighbor instanceof ControllerBlockEntity && this.getController() != neighbor && this.getController() != null) {
            this.getController().scheduleScan();
        }
    }

    @Override
    public void onBeforeWriteComplete(Face sendingFace, Port sendingPort) {
        super.onBeforeWriteComplete(sendingFace, sendingPort);
        Module module = this.getModule(sendingFace);
        if (module != null) {
            module.onBeforeWriteComplete(sendingPort);
        }
    }

    @Override
    public void onWriteComplete(Face sendingFace, Port sendingPort) {
        super.onWriteComplete(sendingFace, sendingPort);
        Module module = this.getModule(sendingFace);
        if (module != null) {
            module.onWriteComplete(sendingPort);
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        double maxDistance = 64.0;
        return player.method_5677(this.field_11867) <= 4096.0;
    }

    @Override
    public class_1278 getInventory() {
        return this.inventory;
    }

    @Override
    public Casing getCasing() {
        return this.casing;
    }

    public void method_11012() {
        super.method_11012();
        class_1937 world = Objects.requireNonNull(this.method_10997());
        if (!world.field_9236) {
            this.onDisabled();
        }
        this.dispose();
    }

    public double method_11006() {
        return 2304.0;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.dispose();
    }

    @Override
    public Pipe getReceivingPipe(Face face, Port port) {
        return this.isReceivingPipeLocked(face, port) ? LockedPipe.INSTANCE : super.getReceivingPipe(face, port);
    }

    @Override
    public void fromClientTag(class_2487 nbt) {
        super.fromClientTag(nbt);
        class_1937 world = Objects.requireNonNull(this.method_10997());
        this.isEnabled = nbt.method_10577(TAG_ENABLED);
        world.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
    }

    @Override
    public class_2487 toClientTag(class_2487 nbt) {
        super.toClientTag(nbt);
        nbt.method_10556(TAG_ENABLED, this.isEnabled);
        return nbt;
    }

    @Override
    protected void readFromNBTCommon(class_2487 nbt) {
        super.readFromNBTCommon(nbt);
        CasingBlockEntity.decompressClosed(nbt.method_10547(TAG_LOCKED), this.locked);
        class_2487 inventoryNbt = nbt.method_10562(TAG_INVENTORY);
        this.inventory.readFromNBT(inventoryNbt);
        class_2487 casingNbt = nbt.method_10562(TAG_CASING);
        this.casing.readFromNBT(casingNbt);
    }

    @Override
    protected void writeToNBTCommon(class_2487 nbt) {
        super.writeToNBTCommon(nbt);
        nbt.method_10570(TAG_LOCKED, CasingBlockEntity.compressClosed(this.locked));
        class_2487 inventoryNbt = new class_2487();
        this.inventory.writeToNBT(inventoryNbt);
        nbt.method_10566(TAG_INVENTORY, (class_2520)inventoryNbt);
        class_2487 casingNbt = new class_2487();
        this.casing.writeToNBT(casingNbt);
        nbt.method_10566(TAG_CASING, (class_2520)casingNbt);
    }

    @Environment(value=EnvType.CLIENT)
    public void setCasingLockedClient(boolean locked) {
        this.casing.setLocked(locked);
    }

    @Environment(value=EnvType.CLIENT)
    public void setStackAndModuleClient(int slot, class_1799 stack, class_2487 moduleData) {
        this.inventory.method_5447(slot, stack);
        Module module = this.casing.getModule(Face.VALUES[slot]);
        if (module != null) {
            module.readFromNBT(moduleData);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void setEnabledClient(boolean value) {
        this.isEnabled = value;
    }

    @Environment(value=EnvType.CLIENT)
    public void setReceivingPipeLockedClient(Face face, Port port, boolean value) {
        this.locked[face.ordinal()][port.ordinal()] = value;
    }

    @Nullable
    private ControllerBlockEntity findController() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        HashSet<class_2586> processed = new HashSet<class_2586>();
        ArrayDeque<class_2586> queue = new ArrayDeque<class_2586>();
        int casings = 0;
        processed.add(this);
        queue.add(this);
        while (!queue.isEmpty()) {
            class_2586 blockEntity = (class_2586)queue.remove();
            if (blockEntity.method_11015()) continue;
            if (blockEntity instanceof ControllerBlockEntity) {
                return (ControllerBlockEntity)blockEntity;
            }
            if (++casings > Settings.maxCasingsPerController) {
                this.onDisabled();
                return null;
            }
            if (ControllerBlockEntity.addNeighbors(world, blockEntity, processed, queue)) continue;
            return null;
        }
        this.onDisabled();
        return null;
    }

    private void sendState() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        CasingEnabledStateMessage message = new CasingEnabledStateMessage(this, this.isEnabled);
        Network.INSTANCE.sendToClientsInDimension(message, world);
    }

    private void dispose() {
        if (this.getController() != null) {
            this.getController().scheduleScan();
        }
        this.casing.onDisposed();
    }

    private void sendCasingLockedState() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        CasingLockedStateMessage message = new CasingLockedStateMessage(this, this.isLocked());
        Network.INSTANCE.sendToClientsNearLocation(message, world, this.method_11016(), 48);
        world.method_8396(null, this.method_11016(), class_3417.field_14962, class_3419.field_15245, 0.3f, this.isLocked() ? 0.5f : 0.6f);
    }

    private void sendReceivingPipeLockedState(Face face, Port port) {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        PipeLockedStateMessage message = new PipeLockedStateMessage(this, face, port, this.isReceivingPipeLocked(face, port));
        Network.INSTANCE.sendToClientsNearLocation(message, world, this.method_11016(), 48);
        world.method_8396(null, this.method_11016(), class_3417.field_14962, class_3419.field_15245, 0.3f, this.isReceivingPipeLocked(face, port) ? 0.5f : 0.6f);
    }

    private static void decompressClosed(byte[] compressed, boolean[][] decompressed) {
        if (compressed.length != 3) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int c = compressed[i >> 1] & 0xFF;
            if ((i & 1) == 1) {
                c >>>= 4;
            }
            boolean[] ports = decompressed[i];
            for (int j = 0; j < 4; ++j) {
                ports[j] = (c & 1 << j) != 0;
            }
        }
    }

    private static byte[] compressClosed(boolean[][] decompressed) {
        byte[] compressed = new byte[3];
        for (int i = 0; i < 6; ++i) {
            boolean[] ports = decompressed[i];
            int c = 0;
            for (int j = 0; j < 4; ++j) {
                if (!ports[j]) continue;
                c |= 1 << j;
            }
            if ((i & 1) == 1) {
                c <<= 4;
            }
            int n = i >> 1;
            compressed[n] = (byte)(compressed[n] | (byte)c);
        }
        return compressed;
    }

    private static final class LockedPipe
    implements Pipe {
        public static final Pipe INSTANCE = new LockedPipe();

        private LockedPipe() {
        }

        @Override
        public void beginWrite(short value) throws IllegalStateException {
            throw new IllegalStateException("Trying to write to a busy pipe. Check isWriting().");
        }

        @Override
        public void cancelWrite() {
        }

        @Override
        public boolean isWriting() {
            return true;
        }

        @Override
        public void beginRead() throws IllegalStateException {
            throw new IllegalStateException("Trying to write to a busy pipe. Check isReading().");
        }

        @Override
        public void cancelRead() {
        }

        @Override
        public boolean isReading() {
            return true;
        }

        @Override
        public boolean canTransfer() {
            return false;
        }

        @Override
        public short read() throws IllegalStateException {
            throw new IllegalStateException("No data to read. Check canTransfer().");
        }
    }
}

