/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.common.event.TickHandlerInfraredPacket;
import li.cil.tis3d.common.init.Entities;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.util.Raytracing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public final class InfraredPacketEntity
extends class_1297
implements InfraredPacket {
    private static final float TRAVEL_SPEED = 24.0f;
    private static final int DEFAULT_LIFETIME = 2;
    private static final String TAG_VALUE = "value";
    private static final String TAG_LIFETIME = "lifetime";
    private static final class_2940<Integer> DATA_VALUE = class_2945.method_12791(InfraredPacketEntity.class, (class_2941)class_2943.field_13327);
    private int lifetime;
    private short value;

    public InfraredPacketEntity(class_1937 world) {
        super(Entities.INFRARED_PACKET, world);
        this.field_5977 = true;
        this.method_5835(0.25f, 0.25f);
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void configure(class_243 start, class_243 direction, short value) {
        this.method_5814(start.field_1352, start.field_1351, start.field_1350);
        this.field_5967 = direction.field_1352 * 24.0;
        this.field_5984 = direction.field_1351 * 24.0;
        this.field_6006 = direction.field_1350 * 24.0;
        this.lifetime = 3;
        this.value = value;
        this.method_5841().method_12778(DATA_VALUE, (Object)(value & 0xFFFF));
    }

    public void updateLifetime() {
        if (this.lifetime-- < 1) {
            this.method_5650();
        }
    }

    private void revive() {
        this.field_5988 = false;
        if (!this.method_5770().field_9236) {
            TickHandlerInfraredPacket.INSTANCE.watchPacket(this);
        }
    }

    protected void method_5693() {
        this.method_5841().method_12784(DATA_VALUE, (Object)0);
        if (!this.method_5770().field_9236) {
            TickHandlerInfraredPacket.INSTANCE.watchPacket(this);
        }
    }

    public void method_5650() {
        super.method_5650();
        if (!this.method_5770().field_9236) {
            TickHandlerInfraredPacket.INSTANCE.unwatchPacket(this);
        }
    }

    protected void method_5749(class_2487 nbt) {
        this.lifetime = nbt.method_10550(TAG_LIFETIME);
        this.value = nbt.method_10568(TAG_VALUE);
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569(TAG_LIFETIME, this.lifetime);
        nbt.method_10575(TAG_VALUE, this.value);
    }

    public void method_5670() {
        if (this.lifetime < 1) {
            this.method_5650();
            return;
        }
        super.method_5670();
        class_239 hit = this.checkCollisions();
        this.emitParticles(hit);
        this.field_5987 += this.field_5967;
        this.field_6010 += this.field_5984;
        this.field_6035 += this.field_6006;
        this.method_5814(this.field_5987, this.field_6010, this.field_6035);
    }

    public boolean method_5713() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5659() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        return false;
    }

    @Override
    public short getPacketValue() {
        return this.value;
    }

    @Override
    public class_243 getPacketPosition() {
        return this.method_5812();
    }

    @Override
    public class_243 getPacketDirection() {
        return new class_243(this.field_5967, this.field_5984, this.field_6006).method_1029();
    }

    @Override
    public void redirectPacket(class_243 position, class_243 direction, int addedLifetime) {
        this.lifetime += addedLifetime;
        if (this.lifetime > 0) {
            this.revive();
            class_243 oldPos = this.method_5812();
            class_243 delta = position.method_1020(oldPos);
            double sqrDelta = delta.method_1026(delta);
            if (sqrDelta > 576.0) {
                double normalizer = 576.0 / sqrDelta;
                this.field_5987 = position.field_1352 * normalizer;
                this.field_6010 = position.field_1351 * normalizer;
                this.field_6035 = position.field_1350 * normalizer;
            } else {
                this.field_5987 = position.field_1352;
                this.field_6010 = position.field_1351;
                this.field_6035 = position.field_1350;
            }
            class_243 velocityVec = direction.method_1029();
            this.field_5967 = velocityVec.field_1352 * 24.0;
            this.field_5984 = velocityVec.field_1351 * 24.0;
            this.field_6006 = velocityVec.field_1350 * 24.0;
        }
    }

    private void emitParticles(@Nullable class_239 hit) {
        double dz;
        double dy;
        double dx;
        class_1937 world = this.method_5770();
        if (world.field_9236) {
            return;
        }
        double t = this.field_5974.nextDouble();
        if (hit == null || hit.method_17784() == null) {
            dx = this.field_5967;
            dy = this.field_5984;
            dz = this.field_6006;
        } else {
            dx = hit.method_17784().field_1352 - this.field_5987;
            dy = hit.method_17784().field_1351 - this.field_6010;
            dz = hit.method_17784().field_1350 - this.field_6035;
        }
        double xx = this.field_5987 + dx * t;
        double yy = this.field_6010 + dy * t;
        double zz = this.field_6035 + dz * t;
        Network.INSTANCE.sendRedstoneEffect(world, xx, yy, zz);
    }

    @Nullable
    private class_239 checkCollisions() {
        class_239 hitResult = this.checkCollision();
        if (hitResult != null) {
            class_243 oldPos = this.method_5812();
            switch (hitResult.method_17783()) {
                case field_1332: {
                    this.onBlockCollision((class_3965)hitResult);
                    break;
                }
                case field_1331: {
                    this.onEntityCollision((class_3966)hitResult);
                    break;
                }
                default: {
                    return null;
                }
            }
            class_243 newPos = this.method_5812();
            double delta = newPos.method_1020(oldPos).method_1033() / 24.0;
            this.field_5987 -= this.field_5967 * delta;
            this.field_6010 -= this.field_5984 * delta;
            this.field_6035 -= this.field_6006 * delta;
        }
        return hitResult;
    }

    @Nullable
    private class_239 checkCollision() {
        class_1937 world = this.method_5770();
        class_243 start = new class_243(this.field_5987, this.field_6010, this.field_6035);
        class_243 target = start.method_1031(this.field_5967, this.field_5984, this.field_6006);
        class_239 blockHit = Raytracing.raytrace(world, start, target, Raytracing::intersectIgnoringTransparent);
        class_239 entityHit = this.checkEntityCollision(world, start, target);
        if (blockHit != null && blockHit.method_17783() != class_239.class_240.field_1333 && entityHit != null && entityHit.method_17783() != class_239.class_240.field_1333) {
            if (blockHit.method_17784().method_1025(start) < entityHit.method_17784().method_1025(start)) {
                return blockHit;
            }
            return entityHit;
        }
        if (blockHit != null) {
            return blockHit;
        }
        if (entityHit != null) {
            return entityHit;
        }
        return null;
    }

    @Nullable
    private class_239 checkEntityCollision(class_1937 world, class_243 start, class_243 target) {
        class_3966 entityHit = null;
        double bestSqrDistance = Double.POSITIVE_INFINITY;
        List collisions = world.method_8333((class_1297)this, this.method_5829().method_1012(this.field_5967, this.field_5984, this.field_6006), class_1301.field_6155);
        for (class_1297 entity : collisions) {
            double sqrDistance;
            class_238 entityBounds;
            Optional hit;
            if (!entity.method_5863() || !(hit = (entityBounds = entity.method_5829()).method_992(start, target)).isPresent() || !((sqrDistance = start.method_1025((class_243)hit.get())) < bestSqrDistance)) continue;
            entityHit = new class_3966(entity, (class_243)hit.get());
            bestSqrDistance = sqrDistance;
        }
        return entityHit;
    }

    private void onBlockCollision(class_3965 hit) {
        class_1937 world = this.method_5770();
        class_2338 pos = hit.method_17777();
        if (pos == null) {
            return;
        }
        if (!world.method_8591(pos)) {
            return;
        }
        class_2248 block = world.method_8320(pos).method_11614();
        if (block == class_2246.field_10316 || block == class_2246.field_10027) {
            this.method_5717(pos);
            return;
        }
        this.method_5650();
        this.onInfraredReceiverCollision((class_239)hit, block);
        this.onInfraredReceiverCollision((class_239)hit, world.method_8321(pos));
    }

    private void onEntityCollision(class_3966 hit) {
        this.method_5650();
        this.onInfraredReceiverCollision((class_239)hit, hit.method_17782());
    }

    private void onInfraredReceiverCollision(class_239 hit, @Nullable Object provider) {
        if (provider instanceof InfraredReceiver) {
            ((InfraredReceiver)provider).onInfraredPacket(this, hit);
        }
    }
}

