/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.init;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.api.API;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.init.Blocks;
import li.cil.tis3d.common.item.CodeBookItem;
import li.cil.tis3d.common.item.KeyItem;
import li.cil.tis3d.common.item.ManualBookItem;
import li.cil.tis3d.common.item.ModuleItem;
import li.cil.tis3d.common.item.ReadOnlyMemoryModuleItem;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class Items {
    public static final class_1792 BOOK_CODE = new CodeBookItem(new class_1792.class_1793().method_7889(1).method_7892(API.itemGroup));
    public static final class_1792 BOOK_MANUAL = new ManualBookItem(new class_1792.class_1793().method_7889(16).method_7892(API.itemGroup));
    public static final class_1792 KEY = new KeyItem(new class_1792.class_1793().method_7889(1).method_7892(API.itemGroup));
    public static final class_1792 KEY_CREATIVE = new KeyItem(new class_1792.class_1793().method_7889(1).method_7892(API.itemGroup));
    public static final class_1792 PRISM = new class_1792(new class_1792.class_1793().method_7889(32).method_7892(API.itemGroup));
    public static final class_1747 CASING = new class_1747((class_2248)Blocks.CASING, new class_1792.class_1793().method_7892(API.itemGroup));
    public static final class_1747 CONTROLLER = new class_1747((class_2248)Blocks.CONTROLLER, new class_1792.class_1793().method_7892(API.itemGroup));
    private static final Map<class_2960, class_1792> modules = new HashMap<class_2960, class_1792>();

    public static Map<class_2960, class_1792> getModules() {
        return modules;
    }

    public static boolean isItem(class_1799 stack, @Nullable class_1792 item) {
        return !stack.method_7960() && stack.method_7909() == item;
    }

    public static boolean isBookCode(class_1799 stack) {
        return Items.isItem(stack, BOOK_CODE);
    }

    public static boolean isBookManual(class_1799 stack) {
        return Items.isItem(stack, BOOK_MANUAL);
    }

    public static boolean isKey(class_1799 stack) {
        return Items.isItem(stack, KEY) || Items.isKeyCreative(stack);
    }

    public static boolean isKeyCreative(class_1799 stack) {
        return Items.isItem(stack, KEY_CREATIVE);
    }

    public static boolean isModuleReadOnlyMemory(class_1799 stack) {
        return Items.isItem(stack, modules.get(Constants.NAME_ITEM_MODULE_READ_ONLY_MEMORY));
    }

    static void registerItems() {
        for (class_2960 moduleName : Constants.MODULES) {
            class_1792 module = Items.registerModule(moduleName);
            if (module == null) continue;
            modules.put(moduleName, module);
        }
        Items.registerItem(BOOK_CODE, Constants.NAME_ITEM_BOOK_CODE);
        Items.registerItem(BOOK_MANUAL, Constants.NAME_ITEM_BOOK_MANUAL);
        Items.registerItem(KEY, Constants.NAME_ITEM_KEY);
        Items.registerItem(KEY_CREATIVE, Constants.NAME_ITEM_KEY_CREATIVE);
        Items.registerItem(PRISM, Constants.NAME_ITEM_PRISM);
        Items.registerItem((class_1792)CASING, Constants.NAME_BLOCK_CASING);
        Items.registerItem((class_1792)CONTROLLER, Constants.NAME_BLOCK_CONTROLLER);
    }

    private static void registerItem(class_1792 item, class_2960 identifier) {
        Items.registerItem(item, identifier, true);
    }

    private static class_1792 registerItem(class_1792 item, class_2960 identifier, boolean isListed) {
        class_2378.field_11142.method_10272(identifier, (Object)item);
        if (!isListed) {
            return null;
        }
        return item;
    }

    private static class_1792 registerModule(class_2960 identifier) {
        class_1792.class_1793 settings;
        boolean isListed = !Settings.disabledModules.contains(identifier);
        class_1792.class_1793 class_17932 = settings = isListed ? new class_1792.class_1793().method_7892(API.itemGroup) : new class_1792.class_1793();
        if (Objects.equals(identifier, Constants.NAME_ITEM_MODULE_READ_ONLY_MEMORY)) {
            return Items.registerItem(new ReadOnlyMemoryModuleItem(settings), identifier, isListed);
        }
        return Items.registerItem(new ModuleItem(settings), identifier, isListed);
    }

    private Items() {
    }
}

