/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.minecraft;

import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.serial.SerialProtocolDocumentationReference;
import li.cil.tis3d.common.inject.AbstractFurnaceBlockEntityAccessors;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2609;

public final class FurnaceSerialInterfaceProvider
implements SerialInterfaceProvider {
    @Override
    public boolean worksWith(class_1937 world, class_2338 position, class_2350 side) {
        return world.method_8321(position) instanceof class_2609;
    }

    @Override
    public SerialInterface interfaceFor(class_1937 world, class_2338 position, class_2350 side) {
        class_2609 furnace = (class_2609)world.method_8321(position);
        if (furnace == null) {
            throw new IllegalArgumentException("Provided location does not contain a furnace. Check via worksWith first.");
        }
        return new SerialInterfaceFurnace(furnace);
    }

    @Override
    public SerialProtocolDocumentationReference getDocumentationReference() {
        return new SerialProtocolDocumentationReference("Minecraft Furnace", "protocols/minecraft_furnace.md");
    }

    @Override
    public boolean isValid(class_1937 world, class_2338 position, class_2350 side, SerialInterface serialInterface) {
        return serialInterface instanceof SerialInterfaceFurnace;
    }

    private static final class SerialInterfaceFurnace
    implements SerialInterface {
        private static final String TAG_MODE = "mode";
        private final class_2609 furnace;
        private Mode mode = Mode.PercentageFuel;

        SerialInterfaceFurnace(class_2609 furnace) {
            this.furnace = furnace;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public void write(short value) {
            this.mode = value == 0 ? Mode.PercentageFuel : Mode.PercentageProgress;
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public short peek() {
            switch (this.mode) {
                case PercentageFuel: {
                    int value = FurnaceField.RemainingFuelTicks.get(this.furnace);
                    int total = FurnaceField.TotalFuelTicks.get(this.furnace);
                    if (total > 0) {
                        return (short)(value * 100 / total);
                    }
                }
                case PercentageProgress: {
                    int value = FurnaceField.AccumulatedSmeltTicks.get(this.furnace);
                    int total = FurnaceField.TotalSmeltTicks.get(this.furnace);
                    if (total <= 0) break;
                    return (short)(value * 100 / total);
                }
            }
            return 0;
        }

        @Override
        public void skip() {
        }

        @Override
        public void reset() {
            this.mode = Mode.PercentageFuel;
        }

        @Override
        public void readFromNBT(class_2487 nbt) {
            this.mode = EnumUtils.readFromNBT(Mode.class, TAG_MODE, nbt);
        }

        @Override
        public void writeToNBT(class_2487 nbt) {
            EnumUtils.writeToNBT(this.mode, TAG_MODE, nbt);
        }

        private static enum Mode {
            PercentageFuel,
            PercentageProgress;

        }

        private static enum FurnaceField {
            RemainingFuelTicks,
            TotalFuelTicks,
            AccumulatedSmeltTicks,
            TotalSmeltTicks;


            public int get(class_2609 furnace) {
                AbstractFurnaceBlockEntityAccessors accessors = (AbstractFurnaceBlockEntityAccessors)furnace;
                switch (this) {
                    case RemainingFuelTicks: {
                        return accessors.getBurnTime();
                    }
                    case TotalFuelTicks: {
                        return accessors.getFuelTime();
                    }
                    case AccumulatedSmeltTicks: {
                        return accessors.getCookTime();
                    }
                    case TotalSmeltTicks: {
                        return accessors.getCookTimeTotal();
                    }
                }
                return 0;
            }
        }
    }
}

