/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.inventory;

import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.api.ModuleAPI;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.api.module.traits.Rotatable;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.init.Blocks;
import li.cil.tis3d.common.inventory.ArrayInventory;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.CasingInventoryMessage;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public final class CasingInventory
extends ArrayInventory
implements class_1278 {
    private final CasingBlockEntity blockEntity;

    public CasingInventory(CasingBlockEntity blockEntity) {
        super(Face.VALUES.length);
        this.blockEntity = blockEntity;
    }

    public void setInventorySlotContents(int index, class_1799 stack, Port facing) {
        if (this.items[index] == stack) {
            return;
        }
        if (!this.items[index].method_7960()) {
            this.onItemRemoved(index);
        }
        this.items[index] = stack;
        if (!this.items[index].method_7960()) {
            this.onItemAdded(index, facing);
        }
        this.method_5431();
    }

    @Override
    public int method_5444() {
        return 1;
    }

    @Override
    public void method_5431() {
        class_1937 world = Objects.requireNonNull(this.blockEntity.method_10997());
        class_2680 state = world.method_8320(this.blockEntity.method_11016());
        Blocks.CASING.updateBlockState(state, world, this.blockEntity.method_11016());
        this.blockEntity.method_5431();
        if (world.field_9236) {
            world.method_16109(this.blockEntity.method_11016());
        }
    }

    public int[] method_5494(class_2350 side) {
        return new int[side.ordinal()];
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 side) {
        return side != null && side.ordinal() == index && this.method_5438(index).method_7960() && this.blockEntity.getModule(Face.fromDirection(side)) == null && this.canInstall(stack, Face.fromDirection(side));
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 side) {
        return side.ordinal() == index && stack == this.method_5438(index);
    }

    private boolean canInstall(class_1799 stack, Face face) {
        return ModuleAPI.getProviderFor(stack, this.blockEntity, face) != null;
    }

    @Override
    protected void onItemAdded(int index) {
        this.onItemAdded(index, Port.UP);
    }

    private void onItemAdded(int index, Port facing) {
        class_1937 world = Objects.requireNonNull(this.blockEntity.method_10997());
        class_1799 stack = this.method_5438(index);
        if (stack.method_7960()) {
            return;
        }
        Face face = Face.VALUES[index];
        ModuleProvider provider = ModuleAPI.getProviderFor(stack, this.blockEntity, face);
        if (provider == null) {
            return;
        }
        Module module = provider.createModule(stack, this.blockEntity, face);
        if (module instanceof Rotatable) {
            ((Rotatable)module).setFacing(facing);
        }
        if (!world.field_9236) {
            class_2487 moduleData;
            if (module != null) {
                module.onInstalled(stack);
                moduleData = new class_2487();
                module.writeToNBT(moduleData);
            } else {
                moduleData = null;
            }
            CasingInventoryMessage message = new CasingInventoryMessage(this.blockEntity, index, stack, moduleData);
            Network.INSTANCE.sendToClientsNearLocation(message, world, this.blockEntity.getPosition(), 48);
        }
        this.blockEntity.setModule(Face.VALUES[index], module);
    }

    @Override
    protected void onItemRemoved(int index) {
        class_1937 world = Objects.requireNonNull(this.blockEntity.method_10997());
        Face face = Face.VALUES[index];
        Module module = this.blockEntity.getModule(face);
        this.blockEntity.setModule(face, null);
        if (!world.field_9236) {
            if (module != null) {
                module.onUninstalled(this.method_5438(index));
                module.onDisposed();
            }
            CasingInventoryMessage message = new CasingInventoryMessage(this.blockEntity, index, class_1799.field_8037, null);
            Network.INSTANCE.sendToClientsNearLocation(message, world, this.blockEntity.getPosition(), 48);
        }
    }
}

