/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.client.gui.GuiHelper;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.block.CasingBlock;
import li.cil.tis3d.util.FontRendererUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1751;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public final class CodeBookItem
extends class_1751 {
    public CodeBookItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 options) {
        super.method_7851(stack, world, tooltip, options);
        String info = class_1074.method_4662((String)"tis3d.tooltip.book_code", (Object[])new Object[0]);
        FontRendererUtils.addStringToTooltip(info, tooltip);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (world.field_9236) {
            GuiHelper.openCodeBookGui(player, hand);
        }
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    public class_1269 method_7884(class_1838 context) {
        return CasingBlock.activate(context) ? class_1269.field_5812 : super.method_7884(context);
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public int method_7837() {
        return 0;
    }

    public static class Data {
        private static final String CONTINUATION_MACRO = "#BWTM";
        private static final String TAG_PAGES = "pages";
        private static final String TAG_SELECTED = "selected";
        private final List<List<String>> pages = new ArrayList<List<String>>();
        private int selectedPage = 0;

        public int getSelectedPage() {
            return this.selectedPage;
        }

        public void setSelectedPage(int index) {
            this.selectedPage = index;
            this.validateSelectedPage();
        }

        public int getPageCount() {
            return this.pages.size();
        }

        public List<String> getPage(int index) {
            return Collections.unmodifiableList(this.pages.get(index));
        }

        public void addPage() {
            this.addOrSelectProgram(Collections.singletonList(""));
        }

        public void addOrSelectProgram(List<String> code) {
            if (code.isEmpty()) {
                return;
            }
            ArrayList<List<String>> newPages = new ArrayList<List<String>>();
            ArrayList<String> page = new ArrayList<String>();
            for (int i = 0; i < code.size(); ++i) {
                boolean isLastPage;
                String line = code.get(i);
                page.add(line);
                if (Objects.equals(line, CONTINUATION_MACRO)) {
                    newPages.add(new ArrayList(page));
                    page.clear();
                    continue;
                }
                if (page.size() != 20) continue;
                boolean bl = isLastPage = i + 1 == code.size();
                if (!isLastPage && !Data.isPartialProgram(page)) {
                    page.set(page.size() - 1, CONTINUATION_MACRO);
                    newPages.add(new ArrayList<String>(page));
                    page.clear();
                    page.add(line);
                    continue;
                }
                newPages.add(new ArrayList<String>(page));
                page.clear();
            }
            if (page.size() > 0) {
                newPages.add(page);
            }
            for (int startPage = 0; startPage < this.pages.size(); ++startPage) {
                if (!this.areAllPagesEqual(newPages, startPage)) continue;
                this.setSelectedPage(startPage);
                return;
            }
            this.pages.addAll(newPages);
            this.setSelectedPage(this.pages.size() - newPages.size());
        }

        public void setPage(int page, List<String> code) {
            this.pages.set(page, new ArrayList<String>(code));
        }

        public void removePage(int index) {
            this.pages.remove(index);
            this.validateSelectedPage();
        }

        public List<String> getProgram() {
            ArrayList<String> program = new ArrayList<String>(this.getPage(this.getSelectedPage()));
            ArrayList<String> leadingCode = new ArrayList<String>();
            ArrayList<String> trailingCode = new ArrayList<String>();
            this.getExtendedProgram(this.getSelectedPage(), program, leadingCode, trailingCode);
            program.addAll(0, leadingCode);
            program.addAll(trailingCode);
            return program;
        }

        public void getExtendedProgram(int page, List<String> program, List<String> leadingCode, List<String> trailingCode) {
            List<String> pageCode;
            for (int leadingPage = page - 1; leadingPage >= 0 && Data.isPartialProgram(pageCode = this.getPage(leadingPage)); --leadingPage) {
                leadingCode.addAll(0, pageCode);
            }
            if (Data.isPartialProgram(program)) {
                for (int trailingPage = page + 1; trailingPage < this.getPageCount(); ++trailingPage) {
                    pageCode = this.getPage(trailingPage);
                    trailingCode.addAll(pageCode);
                    if (!Data.isPartialProgram(pageCode)) break;
                }
            }
        }

        public void readFromNBT(class_2487 nbt) {
            this.pages.clear();
            class_2499 pagesNbt = nbt.method_10554(TAG_PAGES, 8);
            for (int index = 0; index < pagesNbt.size(); ++index) {
                this.pages.add(Arrays.asList(Constants.PATTERN_LINES.split(pagesNbt.method_10608(index))));
            }
            this.selectedPage = nbt.method_10550(TAG_SELECTED);
            this.validateSelectedPage();
        }

        public void writeToNBT(class_2487 nbt) {
            class_2499 pagesNbt = new class_2499();
            int removed = 0;
            for (int index = 0; index < this.pages.size(); ++index) {
                List<String> program = this.pages.get(index);
                if (program.size() > 1 || program.get(0).length() > 0) {
                    pagesNbt.add((Object)new class_2519(String.join((CharSequence)"\n", program)));
                    continue;
                }
                if (index >= this.selectedPage) continue;
                ++removed;
            }
            nbt.method_10566(TAG_PAGES, (class_2520)pagesNbt);
            nbt.method_10569(TAG_SELECTED, this.selectedPage - removed);
        }

        private void validateSelectedPage() {
            this.selectedPage = Math.max(0, Math.min(this.pages.size() - 1, this.selectedPage));
        }

        private boolean areAllPagesEqual(List<List<String>> newPages, int startPage) {
            for (int offset = 0; offset < newPages.size(); ++offset) {
                List<String> want;
                List<String> have = this.pages.get(startPage + offset);
                if (Objects.equals(have, want = newPages.get(offset))) continue;
                return false;
            }
            return true;
        }

        public static Data loadFromNBT(@Nullable class_2487 nbt) {
            Data data = new Data();
            if (nbt != null) {
                data.readFromNBT(nbt);
            }
            return data;
        }

        public static Data loadFromStack(class_1799 stack) {
            return Data.loadFromNBT(stack.method_7969());
        }

        public static void saveToStack(class_1799 stack, Data data) {
            class_2487 nbt = stack.method_7969();
            if (nbt == null) {
                nbt = new class_2487();
                stack.method_7980(nbt);
            }
            data.writeToNBT(nbt);
        }

        private static boolean isPartialProgram(List<String> program) {
            boolean continues = false;
            for (String line : program) {
                if (line.trim().isEmpty()) continue;
                continues = Objects.equals(line.trim().toUpperCase(Locale.US), CONTINUATION_MACRO);
            }
            return continues;
        }
    }
}

