/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.platform.GlStateManager;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2766;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_824;

public final class AudioModule
extends AbstractModule {
    private long lastStep = 0L;

    public AudioModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        class_1937 world = this.getCasing().getCasingWorld();
        this.stepInput();
        this.lastStep = world.method_8510();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        GlStateManager.enableBlend();
        RenderUtil.drawQuad(RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_AUDIO));
        GlStateManager.disableBlend();
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            class_1937 world;
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer() || (world = this.getCasing().getCasingWorld()).method_8510() <= this.lastStep) continue;
            this.playNote(receivingPipe.read());
        }
    }

    private void playNote(int value) {
        int noteId = (value & 0xFF00) >>> 8;
        int volume = Math.min(4, (value & 0xF0) >>> 4);
        int instrumentId = value & 0xF;
        if (instrumentId >= class_2766.values().length) {
            instrumentId = 0;
        }
        if (volume < 1) {
            return;
        }
        float pitch = (float)Math.pow(2.0, (double)(noteId - 12) / 12.0);
        class_2766 instrument = class_2766.values()[instrumentId];
        class_2350 facing = Face.toDirection(this.getFace());
        class_2338 pos = this.getCasing().getPosition();
        double x = (double)pos.method_10263() + 0.5 + (double)facing.method_10148() * 0.6;
        double y = (double)pos.method_10264() + 0.5 + (double)facing.method_10164() * 0.6;
        double z = (double)pos.method_10260() + 0.5 + (double)facing.method_10165() * 0.6;
        class_1937 world = this.getCasing().getCasingWorld();
        world.method_8465(null, x, y, z, instrument.method_11886(), class_3419.field_15245, (float)volume, pitch);
        ((class_3218)world).method_14199((class_2394)class_2398.field_11224, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }
}

