/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.platform.GlStateManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import li.cil.tis3d.api.BundledRedstoneAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.BundledRedstoneOutputChangedEvent;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.util.ColorUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_824;

public final class BundledRedstoneModule
extends AbstractModuleWithRotation
implements BundledRedstone {
    private final short[] output = new short[16];
    private final short[] input = new short[16];
    private short channel = 0;
    private static final String TAG_OUTPUT = "output";
    private static final String TAG_INPUT = "input";
    private static final String TAG_CHANNEL = "channel";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final float LEFT_U0 = 0.25f;
    private static final float RIGHT_U0 = 0.625f;
    private static final float SHARED_V0 = 0.3125f;
    private static final float V_STEP = 0.0625f;
    private long lastStep = 0L;
    private boolean scheduledNeighborUpdate = false;

    public BundledRedstoneModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        class_1937 world = this.getCasing().getCasingWorld();
        for (Port port : Port.VALUES) {
            this.stepOutput(port);
            this.stepInput(port);
        }
        if (this.scheduledNeighborUpdate && world.method_8510() > this.lastStep) {
            this.notifyNeighbors();
        }
        this.lastStep = world.method_8510();
    }

    @Override
    public void onDisabled() {
        Arrays.fill(this.input, (short)0);
        Arrays.fill(this.output, (short)0);
        this.channel = 0;
        BundledRedstoneOutputChangedEvent event = new BundledRedstoneOutputChangedEvent(this, -1);
        BundledRedstoneAPI.onBundledRedstoneOutputChanged(event);
        this.sendData();
    }

    @Override
    public void onEnabled() {
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput(port);
    }

    @Override
    public void onData(ByteBuf data) {
        int i;
        for (i = 0; i < this.input.length; ++i) {
            this.input[i] = data.readShort();
        }
        for (i = 0; i < this.output.length; ++i) {
            this.output[i] = data.readShort();
        }
        this.channel = data.readShort();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_BUNDLED_REDSTONE));
        if (!this.getCasing().isEnabled()) {
            return;
        }
        this.renderBar(this.output, 0.25f);
        this.renderBar(this.input, 0.625f);
        GlStateManager.disableTexture();
        int color = ColorUtils.getColorByIndex(this.channel);
        GlStateManager.color3f((float)ColorUtils.getRed(color), (float)ColorUtils.getGreen(color), (float)ColorUtils.getBlue(color));
        RenderUtil.drawUntexturedQuad(0.4375f, 0.4375f, 0.125f, 0.125f);
        GlStateManager.enableTexture();
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        int[] outputNbt = nbt.method_10561(TAG_OUTPUT);
        for (int i = 0; i < outputNbt.length; ++i) {
            this.output[i] = (short)outputNbt[i];
        }
        int[] inputNbt = nbt.method_10561(TAG_INPUT);
        for (int i = 0; i < inputNbt.length; ++i) {
            this.input[i] = (short)inputNbt[i];
        }
        this.channel = (short)Math.max(0, Math.min(this.input.length - 1, nbt.method_10568(TAG_CHANNEL)));
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        int[] outputNbt = new int[this.output.length];
        for (int i = 0; i < this.output.length; ++i) {
            outputNbt[i] = this.output[i];
        }
        nbt.method_10539(TAG_OUTPUT, outputNbt);
        int[] inputNbt = new int[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            inputNbt[i] = this.input[i];
        }
        nbt.method_10539(TAG_INPUT, inputNbt);
        nbt.method_10575(TAG_CHANNEL, this.channel);
    }

    @Override
    public int getBundledRedstoneOutput(int channel) {
        return this.output[channel];
    }

    @Override
    public void setBundledRedstoneInput(int channel, short value) {
        class_1937 world = this.getCasing().getCasingWorld();
        if (world.field_9236) {
            return;
        }
        if (value == this.input[channel]) {
            return;
        }
        this.input[channel] = value;
        this.getCasing().markDirty();
        this.cancelWrite();
        this.sendData();
    }

    @Override
    public short getBundledRedstoneInput(int channel) {
        return this.input[channel];
    }

    private void stepOutput(Port port) {
        Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
        if (!sendingPipe.isWriting()) {
            sendingPipe.beginWrite(this.input[this.channel]);
        }
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            this.process(receivingPipe.read());
        }
    }

    private void process(int value) {
        short hi = (short)((value & 0xFF00) >>> 8);
        short lo = (short)(value & 0xFF);
        if (hi == 255) {
            if (lo < 0 || lo >= this.input.length) {
                return;
            }
            if (lo != this.channel) {
                this.channel = lo;
                this.cancelWrite();
                this.sendData();
            }
        } else {
            this.setRedstoneOutput(hi, lo);
        }
    }

    private void setRedstoneOutput(int channel, short value) {
        if (channel < 0 || channel >= this.output.length) {
            return;
        }
        if (value == this.output[channel]) {
            return;
        }
        this.output[channel] = value;
        this.getCasing().markDirty();
        this.scheduledNeighborUpdate = true;
        BundledRedstoneOutputChangedEvent event = new BundledRedstoneOutputChangedEvent(this, channel);
        BundledRedstoneAPI.onBundledRedstoneOutputChanged(event);
        this.sendData();
    }

    private void notifyNeighbors() {
        class_1937 world = this.getCasing().getCasingWorld();
        this.scheduledNeighborUpdate = false;
        class_2248 blockType = world.method_8320(this.getCasing().getPosition()).method_11614();
        world.method_8452(this.getCasing().getPosition(), blockType);
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        for (short value : this.input) {
            data.writeShort((int)value);
        }
        for (short value : this.output) {
            data.writeShort((int)value);
        }
        data.writeShort((int)this.channel);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @Environment(value=EnvType.CLIENT)
    private void renderBar(short[] values, float u) {
        GlStateManager.disableTexture();
        for (int channel = 0; channel < values.length; ++channel) {
            if (values[channel] <= 0) continue;
            int color = ColorUtils.getColorByIndex(channel);
            GlStateManager.color3f((float)ColorUtils.getRed(color), (float)ColorUtils.getGreen(color), (float)ColorUtils.getBlue(color));
            float u0 = u + (float)(channel & 1) * 0.0625f;
            float v0 = 0.3125f + (float)(channel >> 1) * 0.0625f;
            RenderUtil.drawUntexturedQuad(u0, v0, 0.0625f, 0.0625f);
        }
        GlStateManager.enableTexture();
    }
}

