/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Deque;
import java.util.LinkedList;
import li.cil.tis3d.api.InfraredAPI;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.common.Settings;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2520;
import net.minecraft.class_824;

public final class InfraredModule
extends AbstractModule
implements InfraredReceiver {
    private final Deque<Short> receiveQueue = new LinkedList<Short>();
    private static final String TAG_RECEIVE_QUEUE = "receiveQueue";
    private long lastStep = 0L;

    public InfraredModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        class_1937 world = this.getCasing().getCasingWorld();
        this.stepOutput();
        this.stepInput();
        this.lastStep = world.method_8510();
    }

    @Override
    public void onDisabled() {
        this.receiveQueue.clear();
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.receiveQueue.removeFirst();
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_INFRARED));
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        int[] receiveQueueNbt;
        super.readFromNBT(nbt);
        this.receiveQueue.clear();
        for (int value : receiveQueueNbt = nbt.method_10561(TAG_RECEIVE_QUEUE)) {
            this.receiveQueue.addLast((short)value);
        }
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        int[] receiveQueueArray = new int[this.receiveQueue.size()];
        int i = 0;
        for (short value : this.receiveQueue) {
            receiveQueueArray[i++] = value;
        }
        class_2495 receiveQueueNbt = new class_2495(receiveQueueArray);
        nbt.method_10566(TAG_RECEIVE_QUEUE, (class_2520)receiveQueueNbt);
    }

    @Override
    public void onInfraredPacket(InfraredPacket packet, class_239 hit) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        class_1937 world = this.getCasing().getCasingWorld();
        if (world.field_9236) {
            return;
        }
        short value = packet.getPacketValue();
        if (this.receiveQueue.size() < Settings.maxInfraredQueueLength) {
            this.receiveQueue.addLast(value);
        }
    }

    private void stepOutput() {
        if (this.receiveQueue.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.receiveQueue.peekFirst());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            class_1937 world;
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer() || (world = this.getCasing().getCasingWorld()).method_8510() <= this.lastStep) continue;
            this.emitInfraredPacket(receivingPipe.read());
        }
    }

    private void emitInfraredPacket(short value) {
        class_2350 facing = Face.toDirection(this.getFace());
        class_2338 blockPos = this.getCasing().getPosition().method_10093(facing);
        class_1937 world = this.getCasing().getCasingWorld();
        class_243 position = new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
        class_243 direction = new class_243((double)facing.method_10148(), (double)facing.method_10164(), (double)facing.method_10165());
        InfraredAPI.sendPacket(world, position, direction, value);
    }
}

