/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.platform.GlStateManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.FontRendererAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_824;

public final class StackModule
extends AbstractModuleWithRotation {
    private final short[] stack = new short[16];
    private int top = -1;
    private static final String TAG_STACK = "stack";
    private static final String TAG_TOP = "top";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final int STACK_SIZE = 16;

    public StackModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.top = -1;
        this.sendData();
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.pop();
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.top = data.readByte();
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = data.readShort();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_STACK));
        if (!this.isEmpty() && rendererDispatcher.field_4344.method_5677(this.getCasing().getPosition()) < 64.0) {
            this.drawState();
        }
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        int[] stackNbt = nbt.method_10561(TAG_STACK);
        int count = Math.min(stackNbt.length, this.stack.length);
        for (int i = 0; i < count; ++i) {
            this.stack[i] = (short)stackNbt[i];
        }
        this.top = class_3532.method_15340((int)nbt.method_10550(TAG_TOP), (int)-1, (int)15);
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        int[] stackNbt = new int[this.stack.length];
        for (int i = 0; i < this.stack.length; ++i) {
            stackNbt[i] = this.stack[i];
        }
        nbt.method_10539(TAG_STACK, stackNbt);
        nbt.method_10569(TAG_TOP, this.top);
    }

    private boolean isEmpty() {
        return this.top < 0;
    }

    private boolean isFull() {
        return this.top >= 15;
    }

    private void push(short value) {
        this.stack[++this.top] = value;
        this.sendData();
    }

    private short peek() {
        return this.stack[this.top];
    }

    private void pop() {
        this.top = Math.max(-1, this.top - 1);
        this.sendData();
    }

    private void stepOutput() {
        if (this.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.peek());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            if (this.isFull()) {
                return;
            }
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.push(receivingPipe.read());
            this.cancelWrite();
            this.stepOutput();
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(this.top);
        for (short value : this.stack) {
            data.writeShort((int)value);
        }
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @Environment(value=EnvType.CLIENT)
    private void drawState() {
        GlStateManager.translatef((float)0.1875f, (float)0.3125f, (float)0.0f);
        GlStateManager.scalef((float)0.0078125f, (float)0.0078125f, (float)1.0f);
        GlStateManager.translatef((float)4.5f, (float)14.5f, (float)0.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i <= this.top; ++i) {
            FontRendererAPI.drawString(String.format("%4X", this.stack[i]));
            GlStateManager.translatef((float)0.0f, (float)(FontRendererAPI.getCharHeight() + 1), (float)0.0f);
            if ((i + 1) % 4 != 0) continue;
            GlStateManager.translatef((float)((FontRendererAPI.getCharWidth() + 1) * 5), (float)((FontRendererAPI.getCharHeight() + 1) * -4), (float)0.0f);
        }
    }
}

