/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.platform.GlStateManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.client.render.font.FontRenderer;
import li.cil.tis3d.client.render.font.NormalFontRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_824;

public final class TimerModule
extends AbstractModuleWithRotation {
    private long timer;
    private static final String TAG_TIMER = "timer";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final short OUTPUT_VALUE = 1;
    private boolean hasElapsed;

    public TimerModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        long worldTime;
        if (!this.hasElapsed && (worldTime = this.getCasing().getCasingWorld().method_8510()) >= this.timer) {
            this.hasElapsed = true;
        }
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.timer = 0L;
        this.hasElapsed = true;
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.timer = data.readLong();
        this.hasElapsed = false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_TIMER));
        if (!this.hasElapsed && rendererDispatcher.field_4344.method_5677(this.getCasing().getPosition()) < 64.0) {
            class_310 mc = class_310.method_1551();
            long worldTime = mc != null && mc.field_1687 != null ? mc.field_1687.method_8510() : 0L;
            float remaining = (float)(this.timer - worldTime) - partialTicks;
            if (remaining <= 0.0f) {
                this.hasElapsed = true;
            } else {
                this.drawState(remaining);
            }
        }
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        this.timer = nbt.method_10537(TAG_TIMER);
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        nbt.method_10544(TAG_TIMER, this.timer);
    }

    private void setTimer(short value) {
        long worldTime = this.getCasing().getCasingWorld().method_8510();
        this.timer = worldTime + (long)(value & 0xFFFF);
        boolean bl = this.hasElapsed = this.timer == worldTime;
        if (!this.hasElapsed) {
            this.cancelWrite();
        }
        this.sendData();
    }

    private void stepOutput() {
        if (!this.hasElapsed) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite((short)1);
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.setTimer(receivingPipe.read());
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeLong(this.timer);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @Environment(value=EnvType.CLIENT)
    private void drawState(float remaining) {
        float milliseconds = remaining * 50.0f;
        float seconds = milliseconds / 1000.0f;
        int minutes = (int)(seconds / 60.0f);
        String time = minutes > 0 ? String.format("%d:%02d", minutes, (int)seconds % 60) : String.format("%.2f", Float.valueOf(seconds));
        FontRenderer fontRenderer = NormalFontRenderer.INSTANCE;
        int width = time.length() * fontRenderer.getCharWidth();
        int height = fontRenderer.getCharHeight();
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.0f);
        GlStateManager.scalef((float)0.0125f, (float)0.0125f, (float)1.0f);
        GlStateManager.translatef((float)((float)(-width) / 2.0f + 1.0f), (float)((float)(-height) / 2.0f + 1.0f), (float)0.0f);
        fontRenderer.drawString(time);
    }
}

