/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.class_2487;

public final class MachineState {
    public int pc = 0;
    public short acc = 0;
    public short bak = 0;
    public Optional<Port> last = Optional.empty();
    public String[] code;
    private int pcPrev;
    private static final String TAG_CODE = "code";
    private static final String TAG_PC = "pc";
    private static final String TAG_ACC = "acc";
    private static final String TAG_BAK = "bak";
    private static final String TAG_LAST = "last";
    private static final String TAG_PC_PREV = "pcPrev";
    public final List<Instruction> instructions = new ArrayList<Instruction>(Settings.maxLinesPerProgram);
    public final HashMap<String, Integer> labels = new HashMap(Settings.maxLinesPerProgram);
    public final HashMap<Integer, Integer> lineNumbers = new HashMap(Settings.maxLinesPerProgram);

    public boolean finishCycle() {
        boolean hasChanged;
        boolean bl = hasChanged = this.pc != this.pcPrev;
        if (this.pc < 0 || this.pc >= this.instructions.size()) {
            this.pc = 0;
        }
        this.pcPrev = this.pc;
        return hasChanged;
    }

    public void reset() {
        this.pc = 0;
        this.acc = 0;
        this.bak = 0;
        this.last = Optional.empty();
    }

    public void clear() {
        this.reset();
        this.instructions.clear();
        this.labels.clear();
        this.code = null;
        this.lineNumbers.clear();
    }

    public void readFromNBT(class_2487 nbt) {
        if (nbt.method_10545(TAG_CODE)) {
            try {
                Compiler.compile(Arrays.asList(Constants.PATTERN_LINES.split(nbt.method_10558(TAG_CODE))), this);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.pc = nbt.method_10550(TAG_PC);
        this.acc = nbt.method_10568(TAG_ACC);
        this.bak = nbt.method_10568(TAG_BAK);
        this.last = nbt.method_10545(TAG_LAST) ? Optional.of(EnumUtils.readFromNBT(Port.class, TAG_LAST, nbt)) : Optional.empty();
        this.pcPrev = nbt.method_10550(TAG_PC_PREV);
    }

    public void writeToNBT(class_2487 nbt) {
        nbt.method_10569(TAG_PC, this.pc);
        nbt.method_10575(TAG_ACC, this.acc);
        nbt.method_10575(TAG_BAK, this.bak);
        this.last.ifPresent(port -> EnumUtils.writeToNBT(port, TAG_LAST, nbt));
        nbt.method_10569(TAG_PC_PREV, this.pcPrev);
        if (this.code != null) {
            nbt.method_10582(TAG_CODE, String.join((CharSequence)"\n", this.code));
        }
    }
}

