/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.compiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.Validator;
import li.cil.tis3d.common.module.execution.compiler.instruction.InstructionEmitter;
import li.cil.tis3d.common.module.execution.compiler.instruction.LabelInstructionEmitter;
import li.cil.tis3d.common.module.execution.compiler.instruction.MissingInstructionEmitter;
import li.cil.tis3d.common.module.execution.compiler.instruction.MoveInstructionEmitter;
import li.cil.tis3d.common.module.execution.compiler.instruction.TargetOrImmediateInstructionEmitter;
import li.cil.tis3d.common.module.execution.compiler.instruction.UnaryInstructionEmitter;
import li.cil.tis3d.common.module.execution.instruction.AddImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.AddInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseAndImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseAndInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseNotInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseOrImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseOrInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseShiftLeftImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseShiftLeftInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseShiftRightImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseShiftRightInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseXorImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.BitwiseXorInstruction;
import li.cil.tis3d.common.module.execution.instruction.DivImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.DivInstruction;
import li.cil.tis3d.common.module.execution.instruction.HaltAndCatchFireInstruction;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.common.module.execution.instruction.JumpEqualZeroInstruction;
import li.cil.tis3d.common.module.execution.instruction.JumpGreaterThanZeroInstruction;
import li.cil.tis3d.common.module.execution.instruction.JumpInstruction;
import li.cil.tis3d.common.module.execution.instruction.JumpLessThanZeroInstruction;
import li.cil.tis3d.common.module.execution.instruction.JumpNotZeroInstruction;
import li.cil.tis3d.common.module.execution.instruction.JumpRelativeImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.JumpRelativeInstruction;
import li.cil.tis3d.common.module.execution.instruction.LastRotateLeftInstruction;
import li.cil.tis3d.common.module.execution.instruction.LastRotateRightInstruction;
import li.cil.tis3d.common.module.execution.instruction.MulImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.MulInstruction;
import li.cil.tis3d.common.module.execution.instruction.NegateInstruction;
import li.cil.tis3d.common.module.execution.instruction.SaveInstruction;
import li.cil.tis3d.common.module.execution.instruction.SubtractImmediateInstruction;
import li.cil.tis3d.common.module.execution.instruction.SubtractInstruction;
import li.cil.tis3d.common.module.execution.instruction.SwapInstruction;
import li.cil.tis3d.common.module.execution.target.Target;

public final class Compiler {
    private static final Pattern PATTERN_COMMENT = Pattern.compile("#.*$");
    private static final Pattern PATTERN_DEFINE = Pattern.compile("#DEFINE\\s+(?<key>\\S+)\\s*(?<value>\\S+)\\s*$");
    private static final Pattern PATTERN_UNDEFINE = Pattern.compile("#UNDEF\\s+(?<key>\\S+)\\s*$");
    private static final Pattern PATTERN_LINE = Pattern.compile("^\\s*(?:(?<label>[^:\\s]+)\\s*:\\s*)?(?:(?<name>\\S+)\\s*(?<arg1>[^,\\s]+)?\\s*,?\\s*(?<arg2>[^,\\s]+)?\\s*(?<excess>.+)?)?\\s*$");
    private static final String INSTRUCTION_NO_NAME = "NOP";
    private static final Instruction INSTRUCTION_NOP = new AddInstruction(Target.NIL);
    private static final InstructionEmitter EMITTER_MISSING = new MissingInstructionEmitter();
    private static final Map<String, InstructionEmitter> EMITTER_MAP;

    public static void compile(Iterable<String> code, MachineState state) throws ParseException {
        state.clear();
        String[] lines = (String[])Iterables.toArray(code, String.class);
        if (lines.length > Settings.maxLinesPerProgram) {
            throw new ParseException("tis3d.compiler.too_many_lines", Settings.maxLinesPerProgram, 0, 0);
        }
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            lines[lineNumber] = lines[lineNumber].toUpperCase(Locale.US);
        }
        state.code = lines;
        try {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            HashMap<String, String> defines = new HashMap<String, String>();
            for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
                Matcher commentMatcher;
                String line;
                Matcher lineMatcher;
                Matcher undefineMatcher;
                if (lines[lineNumber].length() > Settings.maxColumnsPerLine) {
                    throw new ParseException("tis3d.compiler.too_many_columns", lineNumber, Settings.maxColumnsPerLine, Settings.maxColumnsPerLine);
                }
                Matcher defineMatcher = PATTERN_DEFINE.matcher(lines[lineNumber]);
                if (defineMatcher.matches()) {
                    Compiler.parseDefine(defineMatcher, defines);
                }
                if ((undefineMatcher = PATTERN_UNDEFINE.matcher(lines[lineNumber])).matches()) {
                    Compiler.parseUndefine(undefineMatcher, defines);
                }
                if (!(lineMatcher = PATTERN_LINE.matcher(line = (commentMatcher = PATTERN_COMMENT.matcher(lines[lineNumber])).replaceFirst("").trim())).matches()) {
                    throw new ParseException("tis3d.compiler.invalid_format", lineNumber, 0, 0);
                }
                Compiler.parseLabel(lineMatcher, state, lineNumber);
                Compiler.parseInstruction(lineMatcher, state, lineNumber, defines, validators);
            }
            for (Validator validator : validators) {
                validator.accept(state);
            }
        }
        catch (ParseException e) {
            state.clear();
            state.code = lines;
            throw e;
        }
    }

    private static void parseDefine(Matcher matcher, Map<String, String> defines) {
        String key = matcher.group("key");
        if (key == null) {
            return;
        }
        String value = matcher.group("value");
        if (value == null) {
            return;
        }
        if (key.equals(value)) {
            return;
        }
        if (defines.containsKey(value)) {
            value = defines.get(value);
        }
        defines.put(key, value);
    }

    private static void parseUndefine(Matcher matcher, Map<String, String> defines) {
        String key = matcher.group("key");
        if (key == null) {
            return;
        }
        defines.remove(key);
    }

    private static void parseLabel(Matcher matcher, MachineState state, int lineNumber) throws ParseException {
        String label = matcher.group("label");
        if (label == null) {
            return;
        }
        if (state.labels.containsKey(label)) {
            throw new ParseException("tis3d.compiler.label_duplicate", lineNumber, matcher.start("label"), matcher.end("label"));
        }
        state.labels.put(label, state.instructions.size());
    }

    private static void parseInstruction(Matcher matcher, MachineState state, int lineNumber, Map<String, String> defines, List<Validator> validators) throws ParseException {
        String name = matcher.group("name");
        if (name == null) {
            return;
        }
        Instruction instruction = EMITTER_MAP.getOrDefault(name, EMITTER_MISSING).compile(matcher, lineNumber, defines, validators);
        state.lineNumbers.put(state.instructions.size(), lineNumber);
        state.instructions.add(instruction);
    }

    private Compiler() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)INSTRUCTION_NO_NAME, (Object)new UnaryInstructionEmitter(() -> INSTRUCTION_NOP));
        builder.put((Object)"HCF", (Object)new UnaryInstructionEmitter(() -> HaltAndCatchFireInstruction.INSTANCE));
        builder.put((Object)"JMP", (Object)new LabelInstructionEmitter(JumpInstruction::new));
        builder.put((Object)"JEZ", (Object)new LabelInstructionEmitter(JumpEqualZeroInstruction::new));
        builder.put((Object)"JGZ", (Object)new LabelInstructionEmitter(JumpGreaterThanZeroInstruction::new));
        builder.put((Object)"JLZ", (Object)new LabelInstructionEmitter(JumpLessThanZeroInstruction::new));
        builder.put((Object)"JNZ", (Object)new LabelInstructionEmitter(JumpNotZeroInstruction::new));
        builder.put((Object)"JRO", (Object)new TargetOrImmediateInstructionEmitter(JumpRelativeInstruction::new, JumpRelativeImmediateInstruction::new));
        builder.put((Object)"MOV", (Object)new MoveInstructionEmitter());
        builder.put((Object)"SAV", (Object)new UnaryInstructionEmitter(() -> SaveInstruction.INSTANCE));
        builder.put((Object)"SWP", (Object)new UnaryInstructionEmitter(() -> SwapInstruction.INSTANCE));
        builder.put((Object)"NEG", (Object)new UnaryInstructionEmitter(() -> NegateInstruction.INSTANCE));
        builder.put((Object)"ADD", (Object)new TargetOrImmediateInstructionEmitter(AddInstruction::new, AddImmediateInstruction::new));
        builder.put((Object)"SUB", (Object)new TargetOrImmediateInstructionEmitter(SubtractInstruction::new, SubtractImmediateInstruction::new));
        builder.put((Object)"MUL", (Object)new TargetOrImmediateInstructionEmitter(MulInstruction::new, MulImmediateInstruction::new));
        builder.put((Object)"DIV", (Object)new TargetOrImmediateInstructionEmitter(DivInstruction::new, DivImmediateInstruction::new));
        builder.put((Object)"NOT", (Object)new UnaryInstructionEmitter(() -> BitwiseNotInstruction.INSTANCE));
        builder.put((Object)"AND", (Object)new TargetOrImmediateInstructionEmitter(BitwiseAndInstruction::new, BitwiseAndImmediateInstruction::new));
        builder.put((Object)"OR", (Object)new TargetOrImmediateInstructionEmitter(BitwiseOrInstruction::new, BitwiseOrImmediateInstruction::new));
        builder.put((Object)"XOR", (Object)new TargetOrImmediateInstructionEmitter(BitwiseXorInstruction::new, BitwiseXorImmediateInstruction::new));
        builder.put((Object)"SHL", (Object)new TargetOrImmediateInstructionEmitter(BitwiseShiftLeftInstruction::new, BitwiseShiftLeftImmediateInstruction::new));
        builder.put((Object)"SHR", (Object)new TargetOrImmediateInstructionEmitter(BitwiseShiftRightInstruction::new, BitwiseShiftRightImmediateInstruction::new));
        builder.put((Object)"RLLAST", (Object)new UnaryInstructionEmitter(() -> LastRotateLeftInstruction.INSTANCE));
        builder.put((Object)"RRLAST", (Object)new UnaryInstructionEmitter(() -> LastRotateRightInstruction.INSTANCE));
        EMITTER_MAP = builder.build();
    }
}

