/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.client.network.handler.CasingEnabledStateMessageHandler;
import li.cil.tis3d.client.network.handler.CasingInventoryMessageHandler;
import li.cil.tis3d.client.network.handler.CasingLockedStateMessageHandler;
import li.cil.tis3d.client.network.handler.HaltAndCatchFireMessageHandler;
import li.cil.tis3d.client.network.handler.PipeLockedStateMessageHandler;
import li.cil.tis3d.client.network.handler.ReadOnlyMemoryModuleDataClientMessageHandler;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.network.handler.AbstractMessageHandler;
import li.cil.tis3d.common.network.handler.CasingDataMessageHandler;
import li.cil.tis3d.common.network.handler.CodeBookDataMessageHandler;
import li.cil.tis3d.common.network.handler.ReadOnlyMemoryModuleDataServerMessageHandler;
import li.cil.tis3d.common.network.message.AbstractMessage;
import li.cil.tis3d.common.network.message.CasingDataMessage;
import li.cil.tis3d.common.network.message.CasingEnabledStateMessage;
import li.cil.tis3d.common.network.message.CasingInventoryMessage;
import li.cil.tis3d.common.network.message.CasingLockedStateMessage;
import li.cil.tis3d.common.network.message.CodeBookDataMessage;
import li.cil.tis3d.common.network.message.HaltAndCatchFireMessage;
import li.cil.tis3d.common.network.message.PipeLockedStateMessage;
import li.cil.tis3d.common.network.message.ReadOnlyMemoryModuleDataMessage;
import li.cil.tis3d.util.Side;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;

public final class Network {
    public static final Network INSTANCE = new Network();
    public static final int RANGE_HIGH = 48;
    public static final int RANGE_MEDIUM = 32;
    public static final int RANGE_LOW = 16;
    private final Map<Class<AbstractMessage>, class_2960> messageIdCache = new HashMap<Class<AbstractMessage>, class_2960>();
    private static final int TICK_TIME = 50;
    private static final Set<Position> particleQueue = new HashSet<Position>();
    private static long lastParticlesSent = 0L;
    private static int particlesSent = 0;
    private static int particleSendInterval = 50;
    private static int packetsSentServer = 0;
    private static int packetsSentClient = 0;
    private static int throttleServer = 0;
    private static int throttleClient = 0;
    private static final Stack<CasingSendQueue> queuePool = new Stack();
    private static final Map<Casing, CasingSendQueue> clientQueues = new HashMap<Casing, CasingSendQueue>();
    private static final Map<Casing, CasingSendQueue> serverQueues = new HashMap<Casing, CasingSendQueue>();

    public void initClient() {
        this.registerMessage(new CasingDataMessageHandler(), CasingDataMessage.class, Side.CLIENT);
        this.registerMessage(new CasingEnabledStateMessageHandler(), CasingEnabledStateMessage.class, Side.CLIENT);
        this.registerMessage(new CasingLockedStateMessageHandler(), CasingLockedStateMessage.class, Side.CLIENT);
        this.registerMessage(new CasingInventoryMessageHandler(), CasingInventoryMessage.class, Side.CLIENT);
        this.registerMessage(new HaltAndCatchFireMessageHandler(), HaltAndCatchFireMessage.class, Side.CLIENT);
        this.registerMessage(new PipeLockedStateMessageHandler(), PipeLockedStateMessage.class, Side.CLIENT);
        this.registerMessage(new ReadOnlyMemoryModuleDataClientMessageHandler(), ReadOnlyMemoryModuleDataMessage.class, Side.CLIENT);
    }

    public void initServer() {
        this.registerMessage(new CodeBookDataMessageHandler(), CodeBookDataMessage.class, Side.SERVER);
        this.registerMessage(new CasingDataMessageHandler(), CasingDataMessage.class, Side.SERVER);
        this.registerMessage(new ReadOnlyMemoryModuleDataServerMessageHandler(), ReadOnlyMemoryModuleDataMessage.class, Side.SERVER);
    }

    public void sendModuleData(Casing casing, Face face, class_2487 data, byte type) {
        Network.getQueueFor(casing).queueData(face, data, type);
    }

    public void sendModuleData(Casing casing, Face face, ByteBuf data, byte type) {
        Network.getQueueFor(casing).queueData(face, data, type);
    }

    public void sendRedstoneEffect(class_1937 world, double x, double y, double z) {
        class_2680 state;
        class_2338 position = new class_2338(x, y, z);
        if (!world.method_8591(position) && (state = world.method_8320(position)).method_11619()) {
            return;
        }
        Network.queueParticleEffect(world, (float)x, (float)y, (float)z);
    }

    public int sendToClientsInDimension(AbstractMessage message, class_1937 world) {
        if (world.field_9228.isEmpty()) {
            return 0;
        }
        class_2960 id = this.getMessageIdentifier(message.getClass());
        class_2540 buffer = this.serializeMessage(message);
        class_2658 packet = new class_2658(id, buffer);
        int sent = 0;
        for (class_1657 player : world.field_9228) {
            if (!(player instanceof class_3222)) continue;
            ((class_3222)player).field_13987.method_14364((class_2596)packet);
            ++sent;
        }
        return sent;
    }

    public int sendToClientsNearLocation(AbstractMessage message, class_1937 world, class_2338 pos, int range) {
        if (world.field_9228.isEmpty()) {
            return 0;
        }
        class_2960 id = this.getMessageIdentifier(message.getClass());
        class_2540 buffer = this.serializeMessage(message);
        class_2658 packet = new class_2658(id, buffer);
        return this.sendToClientsNearLocation((class_2596<?>)packet, world, pos, range);
    }

    public void sendToClient(AbstractMessage message, class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_2960 id = this.getMessageIdentifier(message.getClass());
        class_2540 buffer = this.serializeMessage(message);
        class_2658 packet = new class_2658(id, buffer);
        ((class_3222)player).field_13987.method_14364((class_2596)packet);
    }

    public void sendToServer(AbstractMessage message) {
        class_2960 id = this.getMessageIdentifier(message.getClass());
        class_2540 buffer = this.serializeMessage(message);
        class_2817 packet = new class_2817(id, buffer);
        class_634 networkHandler = Objects.requireNonNull(class_310.method_1551().method_1562());
        networkHandler.method_2883((class_2596)packet);
    }

    private int sendToClientsNearLocation(class_2596<?> packet, class_1937 world, class_2338 pos, int range) {
        int rangeSq = range * range;
        int sent = 0;
        for (class_1657 player : world.field_9228) {
            if (!(player instanceof class_3222) || !(player.method_5831(pos) < (double)rangeSq)) continue;
            class_3222 networkedPlayer = (class_3222)player;
            networkedPlayer.field_13987.method_14364(packet);
            if (networkedPlayer.field_13987.field_14127.method_10756()) continue;
            ++sent;
        }
        return sent;
    }

    private <TMessage extends AbstractMessage> void registerMessage(AbstractMessageHandler<TMessage> handler, Class<TMessage> messageClass, Side handlerSide) {
        ClientSidePacketRegistry registry;
        switch (handlerSide) {
            case CLIENT: {
                registry = ClientSidePacketRegistry.INSTANCE;
                break;
            }
            case SERVER: {
                registry = ServerSidePacketRegistry.INSTANCE;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        class_2960 id = this.getMessageIdentifier(messageClass);
        registry.register(id, (context, buffer) -> {
            try {
                AbstractMessage message = (AbstractMessage)messageClass.newInstance();
                message.fromBytes((ByteBuf)buffer);
                handler.onMessage(message, context);
            }
            catch (Exception e) {
                TIS3D.getLog().error((Object)e);
            }
        });
    }

    private <TMessage extends AbstractMessage> class_2960 getMessageIdentifier(Class<TMessage> messageClass) {
        return this.messageIdCache.computeIfAbsent(messageClass, clazz -> new class_2960("tis3d", clazz.getSimpleName().toLowerCase(Locale.ROOT)));
    }

    private class_2540 serializeMessage(AbstractMessage message) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        message.toBytes((ByteBuf)buffer);
        return buffer;
    }

    public void serverTick() {
        Network.flushCasingQueues(Side.SERVER);
        Network.flushParticleQueue();
    }

    public void clientTick() {
        Network.flushCasingQueues(Side.CLIENT);
    }

    private static void queueParticleEffect(class_1937 world, float x, float y, float z) {
        Position position = new Position(world, x, y, z);
        particleQueue.add(position);
    }

    private static void flushParticleQueue() {
        long now = System.currentTimeMillis();
        if (now - lastParticlesSent < (long)particleSendInterval) {
            return;
        }
        lastParticlesSent = now;
        particlesSent = 0;
        particleQueue.forEach(rec$ -> ((Position)rec$).sendMessage());
        if (particlesSent > Settings.maxParticlesPerTick) {
            int throttle = (int)Math.ceil((float)particlesSent / (float)Settings.maxParticlesPerTick);
            particleSendInterval = Math.min(2000, 50 * throttle);
        } else {
            particleSendInterval = 50;
        }
        particleQueue.clear();
    }

    private static int getPacketsSent(Side side) {
        return side == Side.CLIENT ? packetsSentClient : packetsSentServer;
    }

    private static void resetPacketsSent(Side side) {
        if (side == Side.CLIENT) {
            packetsSentClient = 0;
        } else {
            packetsSentServer = 0;
        }
    }

    private static void incrementPacketsSent(Side side) {
        if (side == Side.CLIENT) {
            ++packetsSentClient;
        } else {
            ++packetsSentServer;
        }
    }

    private static int getThrottle(Side side) {
        return side == Side.CLIENT ? throttleClient : throttleServer;
    }

    private static void setThrottle(Side side, int value) {
        if (side == Side.CLIENT) {
            throttleClient = value;
        } else {
            throttleServer = value;
        }
    }

    private static void decrementThrottle(Side side) {
        if (side == Side.CLIENT) {
            --throttleClient;
        } else {
            --throttleServer;
        }
    }

    private static Map<Casing, CasingSendQueue> getQueues(Side side) {
        if (side == Side.CLIENT) {
            return clientQueues;
        }
        return serverQueues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CasingSendQueue getQueueFor(Casing casing) {
        class_1937 world = casing.getCasingWorld();
        Side side = world.field_9236 ? Side.CLIENT : Side.SERVER;
        Map<Casing, CasingSendQueue> queues = Network.getQueues(side);
        CasingSendQueue queue = queues.get(casing);
        if (queue == null) {
            Stack<CasingSendQueue> stack = queuePool;
            synchronized (stack) {
                queue = queuePool.size() > 0 ? queuePool.pop() : new CasingSendQueue();
            }
            queues.put(casing, queue);
        }
        return queue;
    }

    private static void flushCasingQueues(Side side) {
        if (Network.getThrottle(side) > 0) {
            Network.decrementThrottle(side);
            return;
        }
        Network.resetPacketsSent(side);
        Map<Casing, CasingSendQueue> queues = Network.getQueues(side);
        queues.forEach(Network::flushCasingQueue);
        Network.clearQueues(queues);
        int sent = Network.getPacketsSent(side);
        if (sent > Settings.maxPacketsPerTick) {
            int throttle = (int)Math.min(40.0, Math.ceil((float)sent / (float)Settings.maxPacketsPerTick));
            Network.setThrottle(side, throttle);
        }
    }

    private static void flushCasingQueue(Casing casing, CasingSendQueue queue) {
        queue.flush(casing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearQueues(Map<Casing, CasingSendQueue> queues) {
        Stack<CasingSendQueue> stack = queuePool;
        synchronized (stack) {
            queuePool.addAll(queues.values());
        }
        queues.clear();
    }

    private Network() {
    }

    private static final class ModuleSendQueue {
        private final List<QueueEntry> sendQueue = new ArrayList<QueueEntry>();
        private final BitSet sentTypes = new BitSet(255);

        private ModuleSendQueue() {
        }

        private void queueData(class_2487 data, byte type) {
            this.sendQueue.add(new QueueEntryNBT(type, data));
        }

        private void queueData(ByteBuf data, byte type) {
            this.sendQueue.add(new QueueEntryByteBuf(type, data));
        }

        private ByteBuf collectData() {
            int i;
            ByteBuf data = Unpooled.buffer();
            int firstToWrite = this.sendQueue.size();
            for (i = this.sendQueue.size() - 1; i >= 0; --i) {
                byte type = this.sendQueue.get((int)i).type;
                if (type >= 0) {
                    if (this.sentTypes.get(type)) continue;
                    this.sentTypes.set(type);
                }
                this.sendQueue.add(this.sendQueue.get(i));
            }
            for (i = this.sendQueue.size() - 1; i >= firstToWrite; --i) {
                this.sendQueue.get(i).write(data);
            }
            this.sendQueue.clear();
            this.sentTypes.clear();
            return data;
        }

        private static final class QueueEntryByteBuf
        extends QueueEntry {
            public final ByteBuf data;

            private QueueEntryByteBuf(byte type, ByteBuf data) {
                super(type);
                this.data = data;
            }

            @Override
            public void write(ByteBuf buffer) {
                if (this.data.readableBytes() > 0) {
                    buffer.writeBoolean(false);
                    buffer.writeShort(this.data.readableBytes());
                    buffer.writeBytes(this.data);
                }
            }
        }

        private static final class QueueEntryNBT
        extends QueueEntry {
            public final class_2487 data;

            private QueueEntryNBT(byte type, class_2487 data) {
                super(type);
                this.data = data;
            }

            @Override
            public void write(ByteBuf buffer) {
                ByteBuf data = Unpooled.buffer();
                ByteBufOutputStream bos = new ByteBufOutputStream(data);
                try {
                    class_2507.method_10634((class_2487)this.data, (OutputStream)bos);
                    if (data.readableBytes() > 0) {
                        buffer.writeBoolean(true);
                        buffer.writeShort(data.readableBytes());
                        buffer.writeBytes(data);
                    }
                }
                catch (IOException e) {
                    TIS3D.getLog().warn("Failed sending packet.", (Throwable)e);
                }
            }
        }

        private static abstract class QueueEntry {
            public final byte type;

            private QueueEntry(byte type) {
                this.type = type;
            }

            public abstract void write(ByteBuf var1);
        }
    }

    private static final class CasingSendQueue {
        private final ModuleSendQueue[] moduleQueues = new ModuleSendQueue[Face.VALUES.length];

        private CasingSendQueue() {
            for (int i = 0; i < this.moduleQueues.length; ++i) {
                this.moduleQueues[i] = new ModuleSendQueue();
            }
        }

        private void queueData(Face face, class_2487 data, byte type) {
            this.moduleQueues[face.ordinal()].queueData(data, type);
        }

        private void queueData(Face face, ByteBuf data, byte type) {
            this.moduleQueues[face.ordinal()].queueData(data, type);
        }

        private void flush(Casing casing) {
            class_1937 world = casing.getCasingWorld();
            Side side = world.field_9236 ? Side.CLIENT : Side.SERVER;
            ByteBuf data = Unpooled.buffer();
            this.collectData(data);
            if (data.readableBytes() > 0) {
                boolean didSend;
                CasingDataMessage message = new CasingDataMessage(casing, data);
                if (side == Side.CLIENT) {
                    INSTANCE.sendToServer(message);
                    didSend = true;
                } else {
                    boolean bl = didSend = INSTANCE.sendToClientsNearLocation(message, casing.getCasingWorld(), casing.getPosition(), 48) > 0;
                }
                if (didSend) {
                    Network.incrementPacketsSent(side);
                }
            }
        }

        private void collectData(ByteBuf data) {
            for (int i = 0; i < this.moduleQueues.length; ++i) {
                ByteBuf moduleData = this.moduleQueues[i].collectData();
                if (moduleData.readableBytes() <= 0) continue;
                data.writeByte(i);
                data.writeShort(moduleData.readableBytes());
                data.writeBytes(moduleData);
            }
        }
    }

    private static final class Position {
        private final class_1937 world;
        private final float x;
        private final float y;
        private final float z;

        private Position(class_1937 world, float x, float y, float z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private void sendMessage() {
            class_2675 packet = new class_2675((class_2394)class_2390.field_11188, false, this.x, this.y, this.z, 0.0f, 0.0f, 0.0f, 0.0f, 1);
            if (INSTANCE.sendToClientsNearLocation((class_2596)packet, this.world, new class_2338((double)this.x, (double)this.y, (double)this.z), 16) > 0) {
                particlesSent++;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Position that = (Position)obj;
            return this.world.field_9247.method_12460() == that.world.field_9247.method_12460() && Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0 && Float.compare(that.z, this.z) == 0;
        }

        public int hashCode() {
            int result = this.world.field_9247.method_12460().method_12484();
            result = 31 * result + (this.x != 0.0f ? Float.floatToIntBits(this.x) : 0);
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
            return result;
        }
    }
}

