/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.handler;

import javax.annotation.Nullable;
import li.cil.tis3d.common.network.message.AbstractMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.PacketContext;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractMessageHandler<T extends AbstractMessage> {
    public void onMessage(T message, PacketContext context) {
        if (context.getTaskQueue().method_5387()) {
            this.onMessageSynchronized(message, context);
        } else {
            context.getTaskQueue().execute(() -> this.onMessageSynchronized(message, context));
        }
    }

    protected abstract void onMessageSynchronized(T var1, PacketContext var2);

    @Nullable
    protected class_1937 getWorld(class_2874 dimension, PacketContext context) {
        switch (context.getPacketEnvironment()) {
            case CLIENT: {
                return AbstractMessageHandler.getWorldClient(dimension, context);
            }
            case SERVER: {
                return AbstractMessageHandler.getWorldServer(dimension, context);
            }
        }
        return null;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    private static class_1937 getWorldClient(class_2874 dimension, PacketContext context) {
        class_1657 player = context.getPlayer();
        if (player == null) {
            return null;
        }
        class_1937 world = player.field_6002;
        if (world == null) {
            return null;
        }
        if (world.method_8597().method_12460() != dimension) {
            return null;
        }
        return world;
    }

    @Nullable
    private static class_1937 getWorldServer(class_2874 dimension, PacketContext context) {
        MinecraftServer server = context.getPlayer().method_5682();
        if (server == null) {
            return null;
        }
        return server.method_3847(dimension);
    }
}

