/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.network.handler.AbstractMessageHandlerWithLocation;
import li.cil.tis3d.common.network.message.CasingDataMessage;
import net.fabricmc.fabric.api.network.PacketContext;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2586;

public final class CasingDataMessageHandler
extends AbstractMessageHandlerWithLocation<CasingDataMessage> {
    @Override
    protected void onMessageSynchronized(CasingDataMessage message, PacketContext context) {
        class_2586 blockEntity = this.getBlockEntity(message, context);
        if (!(blockEntity instanceof CasingBlockEntity)) {
            return;
        }
        CasingBlockEntity casing = (CasingBlockEntity)blockEntity;
        ByteBuf data = message.getData();
        while (data.readableBytes() > 0) {
            Module module = casing.getModule(Face.VALUES[data.readByte()]);
            ByteBuf moduleData = data.readBytes((int)data.readShort());
            while (moduleData.readableBytes() > 0) {
                boolean isNbt = moduleData.readBoolean();
                short size = moduleData.readShort();
                ByteBuf packet = moduleData.readBytes((int)size);
                if (module == null) continue;
                if (isNbt) {
                    try {
                        ByteBufInputStream bis = new ByteBufInputStream(packet);
                        class_2487 nbt = class_2507.method_10629((InputStream)bis);
                        module.onData(nbt);
                    }
                    catch (IOException e) {
                        TIS3D.getLog().warn("Invalid packet received.", (Throwable)e);
                    }
                    continue;
                }
                module.onData(packet);
            }
        }
    }
}

