/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.util;

import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;

public final class Raytracing {
    @Nullable
    public static class_3965 intersectIgnoringLiquids(class_1937 world, class_2338 position, class_243 start, class_243 end) {
        class_2680 state = world.method_8320(position);
        if (state.method_11628((class_1922)world, position) != null) {
            return state.method_11628((class_1922)world, position).method_1092(start, end, position);
        }
        return null;
    }

    @Nullable
    public static class_3965 intersectIgnoringTransparent(class_1937 world, class_2338 position, class_243 start, class_243 end) {
        class_2680 state = world.method_8320(position);
        if (!state.method_11620().method_15804()) {
            return null;
        }
        if (state.method_11628((class_1922)world, position) != null) {
            return state.method_11628((class_1922)world, position).method_1092(start, end, position);
        }
        return null;
    }

    @Nullable
    public static class_239 raytrace(class_1937 world, class_243 start, class_243 end) {
        return Raytracing.raytrace(world, start, end, Raytracing::intersectIgnoringLiquids);
    }

    @Nullable
    public static class_239 raytrace(class_1937 world, class_243 start, class_243 end, CollisionDetector callback) {
        int startPosX = class_3532.method_15357((double)start.field_1352);
        int startPosY = class_3532.method_15357((double)start.field_1351);
        int startPosZ = class_3532.method_15357((double)start.field_1350);
        int endPosX = class_3532.method_15357((double)end.field_1352);
        int endPosY = class_3532.method_15357((double)end.field_1351);
        int endPosZ = class_3532.method_15357((double)end.field_1350);
        int stepX = Integer.compare(endPosX, startPosX);
        int stepY = Integer.compare(endPosY, startPosY);
        int stepZ = Integer.compare(endPosZ, startPosZ);
        int gxp = startPosX + (endPosX > startPosX ? 1 : 0);
        int gyp = startPosY + (endPosY > startPosY ? 1 : 0);
        int gzp = startPosZ + (endPosZ > startPosZ ? 1 : 0);
        double vx = end.field_1352 == start.field_1352 ? 1.0 : end.field_1352 - start.field_1352;
        double vy = end.field_1351 == start.field_1351 ? 1.0 : end.field_1351 - start.field_1351;
        double vz = end.field_1350 == start.field_1350 ? 1.0 : end.field_1350 - start.field_1350;
        double vxvy = vx * vy;
        double vxvz = vx * vz;
        double vyvz = vy * vz;
        double scaledErrorX = (double)stepX * vyvz;
        double scaledErrorY = (double)stepY * vxvz;
        double scaledErrorZ = (double)stepZ * vxvy;
        double errorX = ((double)gxp - start.field_1352) * vyvz;
        double errorY = ((double)gyp - start.field_1351) * vxvz;
        double errorZ = ((double)gzp - start.field_1350) * vxvy;
        int currentPosX = startPosX;
        int currentPosY = startPosY;
        int currentPosZ = startPosZ;
        int emergencyExit = 200;
        while (--emergencyExit > 0) {
            class_2338 position = new class_2338(currentPosX, currentPosY, currentPosZ);
            class_239 hit = callback.intersect(world, position, start, end);
            if (hit != null && hit.method_17783() != class_239.class_240.field_1333) {
                return hit;
            }
            if (currentPosX == endPosX && currentPosY == endPosY && currentPosZ == endPosZ) {
                return null;
            }
            double xr = Math.abs(errorX);
            double yr = Math.abs(errorY);
            double zr = Math.abs(errorZ);
            if (stepX != 0 && (stepY == 0 || xr < yr) && (stepZ == 0 || xr < zr)) {
                currentPosX += stepX;
                errorX += scaledErrorX;
                continue;
            }
            if (stepY != 0 && (stepZ == 0 || yr < zr)) {
                currentPosY += stepY;
                errorY += scaledErrorY;
                continue;
            }
            if (stepZ == 0) continue;
            currentPosZ += stepZ;
            errorZ += scaledErrorZ;
        }
        return null;
    }

    private Raytracing() {
    }

    @FunctionalInterface
    public static interface CollisionDetector {
        @Nullable
        public class_239 intersect(class_1937 var1, class_2338 var2, class_243 var3, class_243 var4);
    }
}

