/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.util;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;

public final class SimpleConfig {
    private static final String COMMENT_PREFIX = "#";
    private static final String KEY_VALUE_ASSIGNMENT = "=";
    private final List<String> segments = new ArrayList<String>();
    private final Object2IntMap<String> entryMap = new Object2IntArrayMap();

    public String getString(String key, String defaultValue, @Nullable String comment) {
        int index = this.entryMap.getOrDefault((Object)key, -1);
        if (index < 0) {
            if (comment != null) {
                if (this.segments.size() > 0) {
                    this.segments.add(System.lineSeparator());
                }
                this.segments.add(COMMENT_PREFIX);
                this.segments.add(" ");
                this.segments.add(comment);
            }
            if (this.segments.size() > 0) {
                this.segments.add(System.lineSeparator());
            }
            this.segments.add(key);
            this.segments.add(KEY_VALUE_ASSIGNMENT);
            this.segments.add(defaultValue);
            index = this.segments.size() - 1;
            this.segments.add(System.lineSeparator());
        }
        return this.segments.get(index);
    }

    public int getInt(String key, int defaultValue, @Nullable String comment) {
        String value = this.getString(key, String.valueOf(defaultValue), comment);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            LogManager.getLogger().error("Failed parsing config value [{}] as integer.", (Object)value);
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue, int minValue, int maxValue, @Nullable String comment) {
        int value = this.getInt(key, defaultValue, String.format("%s [%d, %d]", comment, minValue, maxValue));
        if (value > maxValue) {
            value = maxValue;
        }
        if (value < minValue) {
            value = minValue;
        }
        return value;
    }

    public boolean getBoolean(String key, boolean defaultValue, @Nullable String comment) {
        String value = this.getString(key, String.valueOf(defaultValue), comment);
        return Boolean.parseBoolean(value);
    }

    public static SimpleConfig create(File file) {
        SimpleConfig config = new SimpleConfig();
        config.load(file);
        return config;
    }

    public void load(File file) {
        this.segments.clear();
        this.entryMap.clear();
        if (!file.exists()) {
            return;
        }
        if (!file.canRead()) {
            LogManager.getLogger().error("Cannot read config file [{}].", (Object)file);
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                String trimmedLine = line.trim();
                if (trimmedLine.isEmpty() || trimmedLine.startsWith(COMMENT_PREFIX)) {
                    this.segments.add(line);
                    this.segments.add(System.lineSeparator());
                    continue;
                }
                int splitIndex = line.indexOf(KEY_VALUE_ASSIGNMENT);
                if (splitIndex < 0) {
                    this.segments.add(line);
                    this.segments.add(System.lineSeparator());
                    LogManager.getLogger().warn("Failed parsing config line [{}] in file [{}].", (Object)lineNumber, (Object)file);
                    continue;
                }
                String key = line.substring(0, splitIndex);
                String value = line.substring(splitIndex + 1);
                if (key.trim().isEmpty()) {
                    this.segments.add(line);
                    this.segments.add(System.lineSeparator());
                    LogManager.getLogger().warn("Empty key in config line [{}] in file [{}].", (Object)lineNumber, (Object)file);
                    continue;
                }
                this.segments.add(key);
                this.segments.add(KEY_VALUE_ASSIGNMENT);
                this.segments.add(value);
                this.entryMap.put((Object)key.trim(), this.segments.size() - 1);
                this.segments.add(System.lineSeparator());
            }
        }
        catch (IOException e) {
            LogManager.getLogger().error((Object)e);
        }
    }

    public void save(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LogManager.getLogger().error("Failed creating directory for config file [{}].", (Object)file);
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String segment : this.segments) {
                writer.write(segment);
            }
        }
        catch (IOException e) {
            LogManager.getLogger().error((Object)e);
        }
    }
}

