/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomconfigs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.therandomlabs.randomconfigs.api.event.player.PlayerAttackEntityCallback;
import com.therandomlabs.randomconfigs.api.event.player.PlayerTickCallback;
import com.therandomlabs.randomconfigs.api.event.world.CreateSpawnPositionCallback;
import com.therandomlabs.randomconfigs.api.event.world.EntityAddedCallback;
import com.therandomlabs.randomconfigs.api.event.world.WorldInitializeCallback;
import com.therandomlabs.randomconfigs.attackspeeds.AttackSpeeds;
import com.therandomlabs.randomconfigs.configs.DefaultConfigs;
import com.therandomlabs.randomconfigs.gamerules.DefaultGameRules;
import com.therandomlabs.randomconfigs.gamerules.DefaultGameRulesHandler;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.Jankson;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.JsonObject;
import com.therandomlabs.randomconfigs.repackage.blue.endless.jankson.impl.SyntaxError;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RandomConfigs
implements ModInitializer {
    public static final String MOD_ID = "randomconfigs";
    public static final Logger LOGGER = LogManager.getLogger((String)"randomconfigs");
    public static final boolean IS_CLIENT = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Path MC_DIR = Paths.get(".", new String[0]).toAbsolutePath().normalize();
    public static final Path CONFIG_DIR = MC_DIR.resolve("config").resolve("randomconfigs");
    public static final String NEWLINE_REGEX = "(\r\n|\r|\n)";
    public static final Pattern NEWLINE = Pattern.compile("(\r\n|\r|\n)");
    private static Field modifiers;

    public void onInitialize() {
        try {
            DefaultConfigs.handle();
        }
        catch (IOException ex) {
            RandomConfigs.crashReport("Failed to handle default configs", ex);
        }
        try {
            DefaultGameRules.ensureExists();
        }
        catch (IOException ex) {
            RandomConfigs.crashReport("Failed to load default gamerules", ex);
        }
        try {
            AttackSpeeds.reload();
        }
        catch (IOException ex) {
            RandomConfigs.crashReport("Failed to load attack speeds", ex);
        }
        DefaultGameRulesHandler handler = new DefaultGameRulesHandler();
        WorldInitializeCallback.EVENT.register((Object)handler);
        CreateSpawnPositionCallback.EVENT.register((Object)handler);
        AttackSpeeds attackSpeeds = new AttackSpeeds();
        EntityAddedCallback.EVENT.register((Object)attackSpeeds);
        PlayerTickCallback.EVENT.register((Object)attackSpeeds);
        PlayerAttackEntityCallback.EVENT.register((Object)attackSpeeds);
        AttackSpeeds.registerCommand();
    }

    public static Path getFile(String file) {
        Path path = MC_DIR.resolve(file);
        if (RandomConfigs.isParent(path, MC_DIR)) {
            throw new IllegalArgumentException("Invalid path: " + file);
        }
        return path;
    }

    public static Path getConfig(String fileName) {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        catch (IOException ex) {
            RandomConfigs.crashReport("Failed to create: " + CONFIG_DIR, ex);
        }
        Path path = CONFIG_DIR.resolve(fileName).normalize();
        if (RandomConfigs.isParent(path, CONFIG_DIR)) {
            throw new IllegalArgumentException("Invalid config path: " + fileName);
        }
        return path;
    }

    public static String read(Path path) {
        try {
            return StringUtils.join(Files.readAllLines(path), (String)System.lineSeparator());
        }
        catch (IOException ex) {
            if (!(ex instanceof NoSuchFileException)) {
                RandomConfigs.crashReport("Failed to read file: " + path, ex);
            }
            return null;
        }
    }

    public static Path getJson(String jsonName) {
        return RandomConfigs.getConfig(jsonName + ".json");
    }

    public static JsonObject readJson(Path json) {
        String raw = RandomConfigs.read(json);
        if (raw != null) {
            try {
                return Jankson.builder().build().load(raw);
            }
            catch (SyntaxError ex) {
                RandomConfigs.crashReport("Failed to read JSON: " + json, ex);
            }
        }
        return null;
    }

    public static <T> T readJson(Path json, Class<T> clazz) {
        String raw = RandomConfigs.read(json);
        if (raw != null) {
            try {
                Jankson jankson = Jankson.builder().build();
                raw = clazz.isArray() ? jankson.load("{\"array\":" + raw + "}").get("array").toJson() : jankson.load(raw).toJson();
                return (T)GSON.fromJson(raw, clazz);
            }
            catch (SyntaxError ex) {
                RandomConfigs.crashReport("Failed to read JSON: " + json, ex);
            }
        }
        return null;
    }

    public static void writeJson(Path json, Object object) {
        String raw = GSON.toJson(object).replaceAll(" {2}", "\t");
        try {
            Files.write(json, (raw + System.lineSeparator()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            RandomConfigs.crashReport("Failed to write to: " + json, ex);
        }
    }

    public static boolean isParent(Path parent, Path path) {
        while ((path = path.getParent()) != null) {
            if (!path.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static String readString(InputStream stream) {
        Scanner scanner = new Scanner(stream, "UTF-8").useDelimiter("\\A");
        String string = scanner.hasNext() ? scanner.next() : "";
        scanner.close();
        return string;
    }

    public static List<String> readLines(InputStream stream) {
        return Arrays.asList(NEWLINE.split(RandomConfigs.readString(stream)));
    }

    public static void crashReport(String message, Exception ex) {
        throw new class_148(new class_128(message, (Throwable)ex));
    }

    public static Field findField(Class<?> clazz, String name, String obfName) {
        for (Field field : clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (!name.equals(fieldName) && !obfName.equals(fieldName)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public static Field removeFinalModifier(Field field) {
        try {
            if (modifiers == null) {
                modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
            }
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception ex) {
            RandomConfigs.crashReport("Failed to make " + field.getName() + " non-final", ex);
        }
        return field;
    }
}

