/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomconfigs.attackspeeds;

import com.therandomlabs.randomconfigs.RandomConfigs;
import com.therandomlabs.randomconfigs.api.event.player.PlayerAttackEntityCallback;
import com.therandomlabs.randomconfigs.api.event.player.PlayerTickCallback;
import com.therandomlabs.randomconfigs.api.event.world.EntityAddedCallback;
import com.therandomlabs.randomconfigs.api.event.world.WorldInitializeCallback;
import com.therandomlabs.randomconfigs.attackspeeds.ASReloadCommand;
import com.therandomlabs.randomconfigs.attackspeeds.AttackSpeedConfig;
import com.therandomlabs.randomconfigs.attackspeeds.ItemAttackSpeed;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.fabric.api.registry.CommandRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_1612;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class AttackSpeeds
implements EntityAddedCallback,
PlayerTickCallback,
PlayerAttackEntityCallback,
WorldInitializeCallback {
    public static final Path JSON = RandomConfigs.getJson("attackspeeds");
    private static AttackSpeedConfig speeds = new AttackSpeedConfig();
    private static boolean firstReload = true;

    @Override
    public void onEntityAdded(class_3218 world, class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1324 attackSpeed = ((class_1657)entity).method_5996(class_1612.field_7356);
            attackSpeed.method_6192(AttackSpeeds.speeds.enabled ? AttackSpeeds.speeds.defaultAttackSpeed : 4.0);
        }
    }

    @Override
    public void onPlayerTick(class_3222 player) {
        if (!AttackSpeeds.speeds.enabled || AttackSpeeds.speeds.itemAttackSpeeds == null) {
            return;
        }
        class_1792 item = player.method_5998(player.method_6058()).method_7909();
        class_1324 attackSpeed = player.method_5996(class_1612.field_7356);
        ItemAttackSpeed speed = AttackSpeeds.speeds.itemAttackSpeeds.get(item);
        attackSpeed.method_6192(speed == null ? AttackSpeeds.speeds.defaultAttackSpeed : speed.speed);
    }

    @Override
    public boolean onPlayerAttackEntity(class_3222 player, class_1297 target) {
        if (player.method_7261(0.5f) == 1.0f) {
            return true;
        }
        class_1792 item = player.method_5998(player.method_6058()).method_7909();
        ItemAttackSpeed speed = AttackSpeeds.speeds.itemAttackSpeeds.get(item);
        if (speed == null) {
            if (AttackSpeeds.speeds.disableAttacksDuringAttackCooldownByDefault) {
                player.method_7350();
                return false;
            }
        } else if (speed.disableAttacksDuringAttackCooldown) {
            player.method_7350();
            return false;
        }
        return true;
    }

    @Override
    public void onInitialize(class_3218 world) {
        try {
            AttackSpeeds.reload();
        }
        catch (IOException ex) {
            RandomConfigs.crashReport("Failed to load attack speeds", ex);
        }
    }

    public static AttackSpeedConfig get() {
        return speeds;
    }

    public static void reload() throws IOException {
        if (Files.exists(JSON, new LinkOption[0])) {
            speeds = RandomConfigs.readJson(JSON, AttackSpeedConfig.class);
            if (firstReload) {
                firstReload = false;
            } else {
                speeds.ensureCorrect();
            }
        }
        RandomConfigs.writeJson(JSON, speeds);
    }

    public static void registerCommand() {
        if (AttackSpeeds.speeds.asreloadCommand) {
            CommandRegistry.INSTANCE.register(false, ASReloadCommand::register);
        }
    }
}

