/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomconfigs.configs;

import com.therandomlabs.randomconfigs.RandomConfigs;
import com.therandomlabs.randomconfigs.configs.ConfigSide;
import com.therandomlabs.randomconfigs.configs.DefaultConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public final class DefaultConfigs {
    public static final Path DIRECTORY = RandomConfigs.getConfig("defaultconfigs");
    public static final Path JSON = RandomConfigs.getJson("defaultconfigs");
    public static final Path OLD_JSON = RandomConfigs.getJson("defaultconfigs_old");

    private DefaultConfigs() {
    }

    public static void handle() throws IOException {
        DefaultConfig[] configs = RandomConfigs.readJson(JSON, DefaultConfig[].class);
        if (configs == null) {
            Files.createDirectories(DIRECTORY, new FileAttribute[0]);
            return;
        }
        DefaultConfig[] oldConfigs = RandomConfigs.readJson(OLD_JSON, DefaultConfig[].class);
        Files.copy(JSON, OLD_JSON, StandardCopyOption.REPLACE_EXISTING);
        if (oldConfigs == null) {
            for (DefaultConfig config : configs) {
                DefaultConfigs.handle(config, config.version);
            }
        } else {
            for (DefaultConfig config : configs) {
                int oldVersion = config.version;
                for (DefaultConfig oldConfig : oldConfigs) {
                    if (!Paths.get(config.source, new String[0]).equals(Paths.get(oldConfig.source, new String[0]))) continue;
                    if (!Paths.get(config.destination, new String[0]).equals(Paths.get(oldConfig.destination, new String[0]))) break;
                    oldVersion = oldConfig.version;
                    break;
                }
                DefaultConfigs.handle(config, oldVersion);
            }
        }
        RandomConfigs.writeJson(JSON, configs);
    }

    public static void handle(DefaultConfig config, int oldVersion) throws IOException {
        if (config.source == null) {
            throw new NullPointerException("source");
        }
        if (config.destination == null) {
            throw new NullPointerException("destination");
        }
        if (config.side == null) {
            throw new NullPointerException("side");
        }
        if (config.side == ConfigSide.CLIENT && !RandomConfigs.IS_CLIENT) {
            return;
        }
        if (config.side == ConfigSide.SERVER && RandomConfigs.IS_CLIENT) {
            return;
        }
        Path source = RandomConfigs.getConfig("defaultconfigs/" + config.source);
        Path destination = RandomConfigs.getFile(config.destination);
        if (config.version != oldVersion || !Files.exists(destination, new LinkOption[0])) {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

